/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffMessages;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffRestoreAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class RevertLineAction
extends QuickDiffRestoreAction {
    private int fLine;

    public RevertLineAction(ITextEditor iTextEditor, boolean bl) {
        super(QuickDiffMessages.getResourceBundle(), "RevertLineAction.", iTextEditor, bl);
    }

    @Override
    public boolean computeEnablement() {
        if (!super.computeEnablement()) {
            return false;
        }
        this.fLine = this.getLastLine();
        if (this.fLine == -1) {
            return false;
        }
        ILineDiffer iLineDiffer = this.getDiffer();
        if (iLineDiffer == null) {
            return false;
        }
        ILineDiffInfo iLineDiffInfo = iLineDiffer.getLineInfo(this.fLine);
        if (iLineDiffInfo == null || iLineDiffInfo.getChangeType() == 0) {
            return false;
        }
        if (iLineDiffInfo.getChangeType() == 1) {
            this.setText(QuickDiffMessages.getString("RevertLineAction.delete.label"));
        } else {
            this.setText(QuickDiffMessages.getString("RevertLineAction.label"));
        }
        return true;
    }

    @Override
    public void runCompoundChange() {
        if (!this.isEnabled()) {
            return;
        }
        ILineDiffer iLineDiffer = this.getDiffer();
        if (iLineDiffer != null) {
            try {
                iLineDiffer.revertLine(this.fLine);
            }
            catch (BadLocationException badLocationException) {
                this.setStatus(badLocationException.getMessage());
            }
        }
    }
}

