/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffMessages;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffRestoreAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class RevertBlockAction
extends QuickDiffRestoreAction {
    private static final String PREFIX = "RevertBlockAction.";
    private int fLine;

    public RevertBlockAction(ITextEditor iTextEditor, boolean bl) {
        super(QuickDiffMessages.getResourceBundle(), PREFIX, iTextEditor, bl);
    }

    @Override
    public boolean computeEnablement() {
        if (!super.computeEnablement()) {
            return false;
        }
        this.fLine = this.getLastLine();
        if (this.fLine == -1) {
            return false;
        }
        ILineDiffer iLineDiffer = this.getDiffer();
        if (iLineDiffer == null) {
            return false;
        }
        ILineDiffInfo iLineDiffInfo = iLineDiffer.getLineInfo(this.fLine);
        if (iLineDiffInfo == null || iLineDiffInfo.getChangeType() == 0) {
            return false;
        }
        boolean bl = false;
        if (this.fLine > 0) {
            iLineDiffInfo = iLineDiffer.getLineInfo(this.fLine - 1);
            boolean bl2 = bl = iLineDiffInfo != null && iLineDiffInfo.hasChanges();
        }
        if (!bl) {
            iLineDiffInfo = iLineDiffer.getLineInfo(this.fLine + 1);
            boolean bl3 = bl = iLineDiffInfo != null && iLineDiffInfo.hasChanges();
        }
        return bl;
    }

    @Override
    public void runCompoundChange() {
        if (!this.isEnabled()) {
            return;
        }
        ILineDiffer iLineDiffer = this.getDiffer();
        if (iLineDiffer != null) {
            try {
                iLineDiffer.revertBlock(this.fLine);
            }
            catch (BadLocationException badLocationException) {
                this.setStatus(badLocationException.getMessage());
            }
        }
    }
}

