/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffMessages;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffRestoreAction;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.texteditor.ITextEditor;

public class RestoreAction
extends QuickDiffRestoreAction {
    private static final String PREFIX = "RestoreAction.";
    private int fLine;

    public RestoreAction(ITextEditor iTextEditor, boolean bl) {
        super(QuickDiffMessages.getResourceBundle(), PREFIX, iTextEditor, bl);
    }

    @Override
    public boolean computeEnablement() {
        if (!super.computeEnablement()) {
            return false;
        }
        this.fLine = this.getLastLine();
        if (this.fLine == -1) {
            return false;
        }
        ILineDiffer iLineDiffer = this.getDiffer();
        if (iLineDiffer == null) {
            return false;
        }
        ILineDiffInfo iLineDiffInfo = iLineDiffer.getLineInfo(this.fLine);
        if (iLineDiffInfo == null || iLineDiffInfo.getRemovedLinesAbove() <= 0 && iLineDiffInfo.getRemovedLinesBelow() <= 0) {
            return false;
        }
        if (iLineDiffInfo.getRemovedLinesBelow() == 0) {
            --this.fLine;
        } else {
            iLineDiffInfo.getRemovedLinesAbove();
        }
        iLineDiffInfo = iLineDiffer.getLineInfo(this.fLine);
        if (iLineDiffInfo == null) {
            return false;
        }
        if (iLineDiffInfo.getRemovedLinesBelow() == 1) {
            this.setText(QuickDiffMessages.getString("RestoreAction.label"));
        } else {
            this.setText(NLSUtility.format(QuickDiffMessages.getString("RestoreAction.multiple.label"), String.valueOf(iLineDiffInfo.getRemovedLinesBelow())));
        }
        return true;
    }

    @Override
    public void runCompoundChange() {
        if (!this.isEnabled()) {
            return;
        }
        ILineDiffer iLineDiffer = this.getDiffer();
        if (iLineDiffer != null) {
            try {
                iLineDiffer.restoreAfterLine(this.fLine);
            }
            catch (BadLocationException badLocationException) {
                this.setStatus(badLocationException.getMessage());
            }
        }
    }
}

