/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import java.util.ResourceBundle;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public abstract class QuickDiffRestoreAction
extends TextEditorAction
implements ISelectionChangedListener {
    private int fLastLine = -1;
    private final boolean fIsRulerAction;

    QuickDiffRestoreAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor, boolean bl) {
        super(resourceBundle, string, iTextEditor);
        this.fIsRulerAction = bl;
        ISelectionProvider iSelectionProvider = iTextEditor.getSelectionProvider();
        if (iSelectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)iSelectionProvider).addPostSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    protected abstract void runCompoundChange();

    public void run() {
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null || !this.validateEditorInputState()) {
            return;
        }
        IRewriteTarget iRewriteTarget = (IRewriteTarget)iTextEditor.getAdapter(IRewriteTarget.class);
        if (iRewriteTarget != null) {
            iRewriteTarget.beginCompoundChange();
        }
        this.runCompoundChange();
        if (iRewriteTarget != null) {
            iRewriteTarget.endCompoundChange();
        }
    }

    public void update() {
        super.update();
        this.setEnabled(this.computeEnablement());
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.update();
    }

    protected boolean computeEnablement() {
        if (!super.isEnabled()) {
            return false;
        }
        if (!this.canModifyEditor()) {
            return false;
        }
        this.fLastLine = this.computeLine(this.fIsRulerAction);
        return true;
    }

    protected ITextSelection getSelection() {
        if (this.getTextEditor() == null) {
            return null;
        }
        ISelectionProvider iSelectionProvider = this.getTextEditor().getSelectionProvider();
        if (iSelectionProvider == null) {
            return null;
        }
        ISelection iSelection = iSelectionProvider.getSelection();
        if (iSelection instanceof ITextSelection) {
            return (ITextSelection)iSelection;
        }
        return null;
    }

    protected int getLastLine() {
        return this.fLastLine;
    }

    private int computeLine(boolean bl) {
        ITextSelection iTextSelection;
        IVerticalRulerInfo iVerticalRulerInfo;
        int n = bl ? ((iVerticalRulerInfo = this.getRuler()) == null ? -1 : iVerticalRulerInfo.getLineOfLastMouseButtonActivity()) : ((iTextSelection = this.getSelection()) == null ? -1 : iTextSelection.getEndLine());
        return n;
    }

    private IAnnotationModelExtension getModel() {
        IEditorInput iEditorInput;
        if (this.getTextEditor() == null) {
            return null;
        }
        IDocumentProvider iDocumentProvider = this.getTextEditor().getDocumentProvider();
        IAnnotationModel iAnnotationModel = iDocumentProvider.getAnnotationModel((Object)(iEditorInput = this.getTextEditor().getEditorInput()));
        if (iAnnotationModel instanceof IAnnotationModelExtension) {
            return (IAnnotationModelExtension)iAnnotationModel;
        }
        return null;
    }

    protected ILineDiffer getDiffer() {
        IAnnotationModelExtension iAnnotationModelExtension = this.getModel();
        if (iAnnotationModelExtension != null) {
            return (ILineDiffer)iAnnotationModelExtension.getAnnotationModel((Object)"diff");
        }
        return null;
    }

    protected IVerticalRulerInfo getRuler() {
        if (this.getTextEditor() != null) {
            return (IVerticalRulerInfo)this.getTextEditor().getAdapter(IVerticalRulerInfo.class);
        }
        return null;
    }

    protected void setStatus(String string) {
        IEditorStatusLine iEditorStatusLine;
        if (this.getTextEditor() != null && (iEditorStatusLine = (IEditorStatusLine)this.getTextEditor().getAdapter(IEditorStatusLine.class)) != null) {
            iEditorStatusLine.setMessage(true, string, null);
        }
    }
}

