/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffMessages;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;

public class LastSaveReferenceProvider
implements IQuickDiffReferenceProvider,
IElementStateListener {
    private boolean fDocumentRead = false;
    private IDocument fReference = null;
    private String fId;
    private IDocumentProvider fDocumentProvider;
    private IEditorInput fEditorInput;
    private final Object fLock = new Object();
    private final Object fDocumentAccessorLock = new Object();
    private boolean fDocumentLocked;
    private IProgressMonitor fProgressMonitor;
    private ITextEditor fEditor;

    public IDocument getReference(IProgressMonitor iProgressMonitor) {
        if (!this.fDocumentRead) {
            this.readDocument(iProgressMonitor, true);
        }
        return this.fReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IProgressMonitor iProgressMonitor = this.fProgressMonitor;
        if (iProgressMonitor != null) {
            iProgressMonitor.setCanceled(true);
        }
        IDocumentProvider iDocumentProvider = this.fDocumentProvider;
        Object object = this.fLock;
        synchronized (object) {
            if (iDocumentProvider != null) {
                iDocumentProvider.removeElementStateListener((IElementStateListener)this);
            }
            this.fEditorInput = null;
            this.fDocumentProvider = null;
            this.fReference = null;
            this.fDocumentRead = false;
            this.fProgressMonitor = null;
            this.fEditor = null;
        }
    }

    public String getId() {
        return this.fId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveEditor(ITextEditor iTextEditor) {
        IDocumentProvider iDocumentProvider = null;
        IEditorInput iEditorInput = null;
        if (iTextEditor != null) {
            iDocumentProvider = iTextEditor.getDocumentProvider();
            iEditorInput = iTextEditor.getEditorInput();
        }
        if (iDocumentProvider != this.fDocumentProvider || iEditorInput != this.fEditorInput) {
            this.dispose();
            Object object = this.fLock;
            synchronized (object) {
                this.fEditor = iTextEditor;
                this.fDocumentProvider = iDocumentProvider;
                this.fEditorInput = iEditorInput;
            }
        }
    }

    public boolean isEnabled() {
        return this.fEditorInput != null && this.fDocumentProvider != null;
    }

    public void setId(String string) {
        this.fId = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readDocument(IProgressMonitor iProgressMonitor, boolean bl) {
        IDocumentProvider iDocumentProvider = this.fDocumentProvider;
        IEditorInput iEditorInput = this.fEditorInput;
        IDocument iDocument = this.fReference;
        ITextEditor iTextEditor = this.fEditor;
        if (iDocumentProvider instanceof IStorageDocumentProvider && iEditorInput instanceof IStorageEditorInput) {
            Object object;
            IStorageEditorInput iStorageEditorInput = (IStorageEditorInput)iEditorInput;
            IStorageDocumentProvider iStorageDocumentProvider = (IStorageDocumentProvider)iDocumentProvider;
            if (iDocument == null) {
                if (bl || this.fDocumentRead) {
                    iDocument = new Document();
                } else {
                    return;
                }
            }
            IJobManager iJobManager = Job.getJobManager();
            try {
                object = iStorageEditorInput.getStorage();
                if (object == null) {
                    return;
                }
                this.fProgressMonitor = iProgressMonitor;
                ISchedulingRule iSchedulingRule = this.getSchedulingRule((IStorage)object);
                try {
                    this.lockDocument(iProgressMonitor, iJobManager, iSchedulingRule);
                    String string = object instanceof IEncodedStorage ? ((IEncodedStorage)object).getCharset() : null;
                    boolean bl2 = LastSaveReferenceProvider.isUTF8BOM(string, object);
                    LastSaveReferenceProvider.setDocumentContent(iDocument, object, string, iProgressMonitor, bl2);
                }
                finally {
                    this.unlockDocument(iJobManager, iSchedulingRule);
                    this.fProgressMonitor = null;
                }
            }
            catch (CoreException coreException) {
                return;
            }
            if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
                return;
            }
            object = this.fLock;
            synchronized (object) {
                if (this.fDocumentProvider == iStorageDocumentProvider && this.fEditorInput == iStorageEditorInput) {
                    this.fReference = iDocument;
                    this.fDocumentRead = true;
                    this.addElementStateListener(iTextEditor, iDocumentProvider);
                }
            }
        }
    }

    private ISchedulingRule getSchedulingRule(IStorage iStorage) {
        if (iStorage instanceof ISchedulingRule) {
            return (ISchedulingRule)iStorage;
        }
        if (iStorage != null) {
            return (ISchedulingRule)iStorage.getAdapter(ISchedulingRule.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockDocument(IProgressMonitor iProgressMonitor, IJobManager iJobManager, ISchedulingRule iSchedulingRule) {
        if (iSchedulingRule != null) {
            iJobManager.beginRule(iSchedulingRule, iProgressMonitor);
        } else {
            Object object = this.fDocumentAccessorLock;
            synchronized (object) {
                while (this.fDocumentLocked) {
                    try {
                        this.fDocumentAccessorLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new OperationCanceledException();
                    }
                }
                this.fDocumentLocked = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockDocument(IJobManager iJobManager, ISchedulingRule iSchedulingRule) {
        if (iSchedulingRule != null) {
            iJobManager.endRule(iSchedulingRule);
        } else {
            Object object = this.fDocumentAccessorLock;
            synchronized (object) {
                this.fDocumentLocked = false;
                this.fDocumentAccessorLock.notifyAll();
            }
        }
    }

    private void addElementStateListener(ITextEditor iTextEditor, final IDocumentProvider iDocumentProvider) {
        Shell shell;
        IWorkbenchWindow iWorkbenchWindow;
        IWorkbenchPartSite iWorkbenchPartSite;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = LastSaveReferenceProvider.this.fLock;
                synchronized (object) {
                    if (LastSaveReferenceProvider.this.fDocumentProvider == iDocumentProvider) {
                        iDocumentProvider.addElementStateListener((IElementStateListener)LastSaveReferenceProvider.this);
                    }
                }
            }
        };
        Display display = null;
        if (iTextEditor != null && (iWorkbenchPartSite = iTextEditor.getSite()) != null && (iWorkbenchWindow = iWorkbenchPartSite.getWorkbenchWindow()) != null && (shell = iWorkbenchWindow.getShell()) != null) {
            display = shell.getDisplay();
        }
        if (display != null && !display.isDisposed()) {
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    /*
     * Exception decompiling
     */
    private static void setDocumentContent(IDocument var0, IStorage var1_1, String var2_2, IProgressMonitor var3_3, boolean var4_4) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isUTF8BOM(String string, IStorage iStorage) throws CoreException {
        byte[] byArray;
        IFile iFile;
        IContentDescription iContentDescription;
        if (iStorage instanceof IFile && "UTF-8".equals(string) && (iContentDescription = (iFile = (IFile)iStorage).getContentDescription()) != null && (byArray = (byte[])iContentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK)) != null) {
            if (byArray != IContentDescription.BOM_UTF_8) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.error.wrongByteOrderMark"), null));
            }
            return true;
        }
        return false;
    }

    public void elementDirtyStateChanged(Object object, boolean bl) {
        if (!bl && object == this.fEditorInput) {
            new ReadJob().schedule();
        }
    }

    public void elementContentAboutToBeReplaced(Object object) {
    }

    public void elementContentReplaced(Object object) {
        if (object == this.fEditorInput) {
            new ReadJob().schedule();
        }
    }

    public void elementDeleted(Object object) {
    }

    public void elementMoved(Object object, Object object2) {
    }

    private final class ReadJob
    extends Job {
        public ReadJob() {
            super(QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.readJob.label"));
            this.setSystem(true);
            this.setPriority(20);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor iProgressMonitor) {
            Class<OutOfMemoryError> clazz = OutOfMemoryError.class;
            synchronized (OutOfMemoryError.class) {
                LastSaveReferenceProvider.this.readDocument(iProgressMonitor, false);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Status.OK_STATUS;
            }
        }
    }
}

