/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public final class CompositeRevertAction
extends Action
implements IUpdate,
ISelectionChangedListener {
    private final IAction[] fActions;

    public CompositeRevertAction(ITextEditor iTextEditor, IAction[] iActionArray) {
        this.fActions = new IAction[iActionArray.length];
        int n = 0;
        while (n < iActionArray.length) {
            Assert.isNotNull((Object)iActionArray[n]);
            ++n;
        }
        System.arraycopy(iActionArray, 0, this.fActions, 0, iActionArray.length);
        ISelectionProvider iSelectionProvider = iTextEditor.getSelectionProvider();
        if (iSelectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)iSelectionProvider).addPostSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.update();
    }

    public void update() {
        int n = 0;
        while (n < this.fActions.length) {
            if (this.fActions[n] instanceof IUpdate) {
                ((IUpdate)this.fActions[n]).update();
            }
            ++n;
        }
        IAction iAction = this.getEnabledAction();
        this.setEnabled(this.getEnabledAction() != null);
        if (iAction == null) {
            return;
        }
        this.setText(iAction.getText());
        this.setToolTipText(iAction.getToolTipText());
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.update();
    }

    public void run() {
        IAction iAction = this.getEnabledAction();
        if (iAction != null) {
            iAction.run();
        }
    }

    private IAction getEnabledAction() {
        int n = 0;
        while (n < this.fActions.length) {
            if (this.fActions[n].isEnabled()) {
                return this.fActions[n];
            }
            ++n;
        }
        return null;
    }
}

