/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text.templates;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionTemplateMessages;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.osgi.framework.Bundle;

public class ContributionTemplateStore
extends TemplateStore {
    private static final String TEMPLATES_EXTENSION_POINT = "org.eclipse.ui.editors.templates";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CONTEXT_TYPE_ID = "contextTypeId";
    private static final String DESCRIPTION = "description";
    private static final String AUTO_INSERT = "autoinsert";
    private static final String TEMPLATE = "template";
    private static final String PATTERN = "pattern";
    private static final String INCLUDE = "include";
    private static final String FILE = "file";
    private static final String TRANSLATIONS = "translations";

    public ContributionTemplateStore(IPreferenceStore iPreferenceStore, String string) {
        super(iPreferenceStore, string);
    }

    public ContributionTemplateStore(ContextTypeRegistry contextTypeRegistry, IPreferenceStore iPreferenceStore, String string) {
        super(contextTypeRegistry, iPreferenceStore, string);
    }

    protected void loadContributedTemplates() throws IOException {
        IConfigurationElement[] iConfigurationElementArray = ContributionTemplateStore.getTemplateExtensions();
        Collection collection = this.readContributedTemplates(iConfigurationElementArray);
        for (TemplatePersistenceData templatePersistenceData : collection) {
            this.internalAdd(templatePersistenceData);
        }
    }

    private Collection readContributedTemplates(IConfigurationElement[] iConfigurationElementArray) throws IOException {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if (iConfigurationElementArray[n].getName().equals(TEMPLATE)) {
                this.createTemplate(arrayList, iConfigurationElementArray[n]);
            } else if (iConfigurationElementArray[n].getName().equals(INCLUDE)) {
                this.readIncludedTemplates(arrayList, iConfigurationElementArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    private void readIncludedTemplates(Collection collection, IConfigurationElement iConfigurationElement) throws IOException {
        block41: {
            Bundle bundle;
            URL uRL;
            String string = iConfigurationElement.getAttribute(FILE);
            if (string != null && (uRL = FileLocator.find((Bundle)(bundle = Platform.getBundle((String)iConfigurationElement.getContributor().getName())), (IPath)Path.fromOSString((String)string), null)) != null) {
                PropertyResourceBundle propertyResourceBundle = null;
                InputStream inputStream = null;
                InputStream inputStream2 = null;
                try {
                    URL uRL2;
                    String string2 = iConfigurationElement.getAttribute(TRANSLATIONS);
                    if (string2 != null && (uRL2 = FileLocator.find((Bundle)bundle, (IPath)Path.fromOSString((String)string2), null)) != null) {
                        inputStream = uRL2.openStream();
                        propertyResourceBundle = new PropertyResourceBundle(inputStream);
                    }
                    inputStream2 = new BufferedInputStream(uRL.openStream());
                    uRL2 = new TemplateReaderWriter();
                    TemplatePersistenceData[] templatePersistenceDataArray = uRL2.read(inputStream2, propertyResourceBundle);
                    int n = 0;
                    while (n < templatePersistenceDataArray.length) {
                        TemplatePersistenceData templatePersistenceData = templatePersistenceDataArray[n];
                        if (templatePersistenceData.isCustom()) {
                            if (templatePersistenceData.getId() == null) {
                                EditorsPlugin.logErrorMessage(NLSUtility.format(ContributionTemplateMessages.ContributionTemplateStore_ignore_no_id, templatePersistenceData.getTemplate().getName()));
                            } else {
                                EditorsPlugin.logErrorMessage(NLSUtility.format(ContributionTemplateMessages.ContributionTemplateStore_ignore_deleted, templatePersistenceData.getTemplate().getName()));
                            }
                        } else if (this.validateTemplate(templatePersistenceData.getTemplate())) {
                            collection.add(templatePersistenceData);
                        }
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    block39: {
                        try {
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException iOException) {
                                try {
                                    if (inputStream2 != null) {
                                        inputStream2.close();
                                    }
                                    break block39;
                                }
                                catch (IOException iOException2) {}
                                break block39;
                            }
                        }
                        catch (Throwable throwable2) {
                            try {
                                if (inputStream2 != null) {
                                    inputStream2.close();
                                }
                            }
                            catch (IOException iOException) {}
                            throw throwable2;
                        }
                        try {
                            if (inputStream2 != null) {
                                inputStream2.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (inputStream2 != null) {
                                inputStream2.close();
                            }
                            break block41;
                        }
                        catch (IOException iOException3) {}
                        break block41;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream2 != null) {
                            inputStream2.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean validateTemplate(Template template) {
        String string = template.getContextTypeId();
        if (!this.contextExists(string)) {
            return false;
        }
        if (this.getRegistry() != null) {
            try {
                this.getRegistry().getContextType(string).validate(template.getPattern());
            }
            catch (TemplateException templateException) {
                EditorsPlugin.log(NLSUtility.format(ContributionTemplateMessages.ContributionTemplateStore_ignore_validation_failed, template.getName()), templateException);
                return false;
            }
        }
        return true;
    }

    private boolean contextExists(String string) {
        return string != null && (this.getRegistry() == null || this.getRegistry().getContextType(string) != null);
    }

    private static IConfigurationElement[] getTemplateExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATES_EXTENSION_POINT);
    }

    private void createTemplate(Collection collection, IConfigurationElement iConfigurationElement) {
        String string;
        String string2;
        String string3;
        String string4 = iConfigurationElement.getAttribute(CONTEXT_TYPE_ID);
        if (this.contextExists(string4) && ContributionTemplateStore.isValidTemplateId(string3 = iConfigurationElement.getAttribute(ID)) && (string2 = iConfigurationElement.getAttribute(NAME)) != null && (string = iConfigurationElement.getChildren(PATTERN)[0].getValue()) != null) {
            String string5;
            String string6 = iConfigurationElement.getAttribute(DESCRIPTION);
            if (string6 == null) {
                string6 = "";
            }
            boolean bl = (string5 = iConfigurationElement.getAttribute(AUTO_INSERT)) == null ? true : Boolean.valueOf(string5);
            Template template = new Template(string2, string6, string4, string, bl);
            TemplatePersistenceData templatePersistenceData = new TemplatePersistenceData(template, true, string3);
            if (this.validateTemplate(template)) {
                collection.add(templatePersistenceData);
            }
        }
    }

    private static boolean isValidTemplateId(String string) {
        return string != null && string.trim().length() != 0;
    }

    protected void handleException(IOException iOException) {
        EditorsPlugin.log(iOException);
    }
}

