/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text.templates;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class ContributionContextTypeRegistry
extends ContextTypeRegistry {
    private static final String TEMPLATES_EXTENSION_POINT = "org.eclipse.ui.editors.templates";
    private static final String CONTEXT_TYPE = "contextType";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String RESOLVER = "resolver";
    private static final String CONTEXT_TYPE_ID = "contextTypeId";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";
    private static final String REGISTRY = "contextTypeRegistry";
    private static final String REGISTRY_ID = "registryId";

    public ContributionContextTypeRegistry(String string) {
        this.readRegistry(string);
    }

    public ContributionContextTypeRegistry() {
    }

    private void readRegistry(String string) {
        Assert.isNotNull((Object)string);
        IConfigurationElement[] iConfigurationElementArray = ContributionContextTypeRegistry.getTemplateExtensions();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string2;
            if (iConfigurationElementArray[n].getName().equals(REGISTRY) && string.equals(string2 = iConfigurationElementArray[n].getAttribute(ID))) {
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    if (iConfigurationElementArray[n2].getName().equals(CONTEXT_TYPE) && string.equals(iConfigurationElementArray[n2].getAttribute(REGISTRY_ID))) {
                        this.addContextType(iConfigurationElementArray[n2].getAttribute(ID));
                    }
                    ++n2;
                }
                return;
            }
            ++n;
        }
        Assert.isTrue((boolean)false, (String)"invalid registry id");
    }

    public void addContextType(String string) {
        Assert.isNotNull((Object)string);
        if (this.getContextType(string) != null) {
            return;
        }
        TemplateContextType templateContextType = ContributionContextTypeRegistry.createContextType(string);
        if (templateContextType != null) {
            this.addContextType(templateContextType);
        }
    }

    public static TemplateContextType createContextType(String string) {
        TemplateContextType templateContextType;
        Assert.isNotNull((Object)string);
        IConfigurationElement[] iConfigurationElementArray = ContributionContextTypeRegistry.getTemplateExtensions();
        try {
            templateContextType = ContributionContextTypeRegistry.createContextType(iConfigurationElementArray, string);
            if (templateContextType != null) {
                TemplateVariableResolver[] templateVariableResolverArray = ContributionContextTypeRegistry.createResolvers(iConfigurationElementArray, string);
                int n = 0;
                while (n < templateVariableResolverArray.length) {
                    templateContextType.addResolver(templateVariableResolverArray[n]);
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            EditorsPlugin.log(coreException);
            templateContextType = null;
        }
        return templateContextType;
    }

    private static TemplateContextType createContextType(IConfigurationElement[] iConfigurationElementArray, String string) throws CoreException {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string2;
            if (iConfigurationElementArray[n].getName().equals(CONTEXT_TYPE) && string.equals(string2 = iConfigurationElementArray[n].getAttribute(ID))) {
                return ContributionContextTypeRegistry.createContextType(iConfigurationElementArray[n]);
            }
            ++n;
        }
        return null;
    }

    private static TemplateVariableResolver[] createResolvers(IConfigurationElement[] iConfigurationElementArray, String string) {
        ArrayList<TemplateVariableResolver> arrayList = new ArrayList<TemplateVariableResolver>();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string2;
            if (iConfigurationElementArray[n].getName().equals(RESOLVER) && string.equals(string2 = iConfigurationElementArray[n].getAttribute(CONTEXT_TYPE_ID))) {
                try {
                    TemplateVariableResolver templateVariableResolver = ContributionContextTypeRegistry.createResolver(iConfigurationElementArray[n]);
                    if (templateVariableResolver != null) {
                        arrayList.add(templateVariableResolver);
                    }
                }
                catch (CoreException coreException) {
                    EditorsPlugin.log(coreException);
                }
            }
            ++n;
        }
        return arrayList.toArray(new TemplateVariableResolver[arrayList.size()]);
    }

    private static IConfigurationElement[] getTemplateExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATES_EXTENSION_POINT);
    }

    private static TemplateContextType createContextType(IConfigurationElement iConfigurationElement) throws CoreException {
        String string = iConfigurationElement.getAttribute(ID);
        try {
            TemplateContextType templateContextType = (TemplateContextType)iConfigurationElement.createExecutableExtension(CLASS);
            String string2 = iConfigurationElement.getAttribute(NAME);
            if (string2 == null) {
                string2 = string;
            }
            if (templateContextType.getId() == null) {
                templateContextType.setId(string);
            }
            if (templateContextType.getName() == null) {
                templateContextType.setName(string2);
            }
            return templateContextType;
        }
        catch (ClassCastException classCastException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, "extension does not implement " + TemplateContextType.class.getName(), (Throwable)classCastException));
        }
    }

    private static TemplateVariableResolver createResolver(IConfigurationElement iConfigurationElement) throws CoreException {
        try {
            String string = iConfigurationElement.getAttribute(TYPE);
            if (string != null) {
                TemplateVariableResolver templateVariableResolver = (TemplateVariableResolver)iConfigurationElement.createExecutableExtension(CLASS);
                templateVariableResolver.setType(string);
                String string2 = iConfigurationElement.getAttribute(DESCRIPTION);
                templateVariableResolver.setDescription(string2 == null ? "" : string2);
                return templateVariableResolver;
            }
        }
        catch (ClassCastException classCastException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, "extension does not implement " + TemplateVariableResolver.class.getName(), (Throwable)classCastException));
        }
        return null;
    }
}

