/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.hyperlink.MultipleHyperlinkPresenter;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.HyperlinkDetectorRegistry;
import org.eclipse.ui.texteditor.spelling.SpellingCorrectionProcessor;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class TextSourceViewerConfiguration
extends SourceViewerConfiguration {
    protected IPreferenceStore fPreferenceStore;

    public TextSourceViewerConfiguration() {
    }

    public TextSourceViewerConfiguration(IPreferenceStore iPreferenceStore) {
        this.fPreferenceStore = iPreferenceStore;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer iSourceViewer) {
        return new DefaultAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return TextSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    protected boolean isShowInVerticalRuler(Annotation annotation) {
        AnnotationPreference annotationPreference = this.getAnnotationPreference(annotation);
        if (annotationPreference == null) {
            return true;
        }
        String string = annotationPreference.getVerticalRulerPreferenceKey();
        return string == null || this.fPreferenceStore.getBoolean(string);
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer iSourceViewer) {
        return new DefaultAnnotationHover(true){

            protected boolean isIncluded(Annotation annotation) {
                return TextSourceViewerConfiguration.this.isShowInOverviewRuler(annotation);
            }
        };
    }

    protected boolean isShowInOverviewRuler(Annotation annotation) {
        AnnotationPreference annotationPreference = this.getAnnotationPreference(annotation);
        if (annotationPreference == null) {
            return true;
        }
        String string = annotationPreference.getOverviewRulerPreferenceKey();
        return string != null && this.fPreferenceStore.getBoolean(string);
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer iSourceViewer, String string) {
        return new int[]{255};
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        return new TextHover(iSourceViewer);
    }

    protected boolean isShownInText(Annotation annotation) {
        AnnotationPreference annotationPreference = this.getAnnotationPreference(annotation);
        if (annotationPreference == null) {
            return false;
        }
        String string = annotationPreference.getTextPreferenceKey();
        return !(string != null ? !this.fPreferenceStore.getBoolean(string) : (string = annotationPreference.getHighlightPreferenceKey()) == null || !this.fPreferenceStore.getBoolean(string));
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation == null || this.fPreferenceStore == null) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }

    public int getTabWidth(ISourceViewer iSourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getTabWidth(iSourceViewer);
        }
        return this.fPreferenceStore.getInt("tabWidth");
    }

    public String[] getIndentPrefixes(ISourceViewer iSourceViewer, String string) {
        String[] stringArray = this.getIndentPrefixesForTab(this.getTabWidth(iSourceViewer));
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        if (n > 2 && this.fPreferenceStore != null && this.fPreferenceStore.getBoolean("spacesForTabs")) {
            String string2 = stringArray[0];
            stringArray[0] = stringArray[n - 2];
            stringArray[n - 2] = string2;
        }
        return stringArray;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer iSourceViewer) {
        if (iSourceViewer == null || this.fPreferenceStore == null) {
            return super.getHyperlinkDetectors(iSourceViewer);
        }
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        return this.getRegisteredHyperlinkDetectors(iSourceViewer);
    }

    protected final IHyperlinkDetector[] getRegisteredHyperlinkDetectors(ISourceViewer iSourceViewer) {
        HyperlinkDetectorRegistry hyperlinkDetectorRegistry = EditorsUI.getHyperlinkDetectorRegistry();
        Map map = this.getHyperlinkDetectorTargets(iSourceViewer);
        Assert.isNotNull((Object)map);
        IHyperlinkDetector[] iHyperlinkDetectorArray = null;
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            IAdaptable iAdaptable = (IAdaptable)entry.getValue();
            iHyperlinkDetectorArray = this.merge(iHyperlinkDetectorArray, hyperlinkDetectorRegistry.createHyperlinkDetectors(string, iAdaptable));
        }
        return iHyperlinkDetectorArray;
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer iSourceViewer) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("org.eclipse.ui.DefaultTextEditor", null);
        return hashMap;
    }

    public int getHyperlinkStateMask(ISourceViewer iSourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getHyperlinkStateMask(iSourceViewer);
        }
        String string = this.fPreferenceStore.getString("hyperlinkKeyModifier");
        int n = TextSourceViewerConfiguration.computeStateMask(string);
        if (n == -1) {
            n = this.fPreferenceStore.getInt("hyperlinkKeyModifierMask");
        }
        return n;
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer iSourceViewer) {
        if (this.fPreferenceStore == null) {
            return new MultipleHyperlinkPresenter(new RGB(0, 0, 255));
        }
        return new MultipleHyperlinkPresenter(this.fPreferenceStore);
    }

    protected static final int findLocalizedModifier(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (string.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    protected static final int computeStateMask(String string) {
        if (string == null) {
            return -1;
        }
        if (string.length() == 0) {
            return 0;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;.:+-* ");
        while (stringTokenizer.hasMoreTokens()) {
            int n2 = TextSourceViewerConfiguration.findLocalizedModifier(stringTokenizer.nextToken());
            if (n2 == 0 || (n & n2) == n2) {
                return -1;
            }
            n |= n2;
        }
        return n;
    }

    public IUndoManager getUndoManager(ISourceViewer iSourceViewer) {
        if (this.fPreferenceStore == null || !this.fPreferenceStore.contains("undoHistorySize")) {
            return super.getUndoManager(iSourceViewer);
        }
        int n = this.fPreferenceStore.getInt("undoHistorySize");
        return new TextViewerUndoManager(n);
    }

    public IReconciler getReconciler(ISourceViewer iSourceViewer) {
        if (this.fPreferenceStore == null || !this.fPreferenceStore.getBoolean("spellingEnabled")) {
            return null;
        }
        SpellingService spellingService = EditorsUI.getSpellingService();
        if (spellingService.getActiveSpellingEngineDescriptor(this.fPreferenceStore) == null) {
            return null;
        }
        SpellingReconcileStrategy spellingReconcileStrategy = new SpellingReconcileStrategy(iSourceViewer, spellingService);
        MonoReconciler monoReconciler = new MonoReconciler((IReconcilingStrategy)spellingReconcileStrategy, false);
        monoReconciler.setDelay(500);
        return monoReconciler;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer iSourceViewer) {
        if (this.fPreferenceStore == null || !this.fPreferenceStore.getBoolean("spellingEnabled")) {
            return null;
        }
        QuickAssistAssistant quickAssistAssistant = new QuickAssistAssistant();
        quickAssistAssistant.setQuickAssistProcessor((IQuickAssistProcessor)new SpellingCorrectionProcessor());
        quickAssistAssistant.setRestoreCompletionProposalSize(EditorsPlugin.getDefault().getDialogSettingsSection("quick_assist_proposal_size"));
        quickAssistAssistant.setInformationControlCreator(this.getQuickAssistAssistantInformationControlCreator());
        return quickAssistAssistant;
    }

    private IInformationControlCreator getQuickAssistAssistantInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, EditorsPlugin.getAdditionalInfoAffordanceString());
            }
        };
    }

    private IHyperlinkDetector[] merge(IHyperlinkDetector[] iHyperlinkDetectorArray, IHyperlinkDetector[] iHyperlinkDetectorArray2) {
        if (iHyperlinkDetectorArray == null && iHyperlinkDetectorArray2 == null) {
            return null;
        }
        if (iHyperlinkDetectorArray == null) {
            return iHyperlinkDetectorArray2;
        }
        if (iHyperlinkDetectorArray2 == null) {
            return iHyperlinkDetectorArray;
        }
        int n = iHyperlinkDetectorArray.length + iHyperlinkDetectorArray2.length;
        IHyperlinkDetector[] iHyperlinkDetectorArray3 = new IHyperlinkDetector[n];
        System.arraycopy(iHyperlinkDetectorArray, 0, iHyperlinkDetectorArray3, 0, iHyperlinkDetectorArray.length);
        System.arraycopy(iHyperlinkDetectorArray2, 0, iHyperlinkDetectorArray3, iHyperlinkDetectorArray.length, iHyperlinkDetectorArray2.length);
        return iHyperlinkDetectorArray3;
    }

    private final class TextHover
    extends DefaultTextHover
    implements ITextHoverExtension {
        public TextHover(ISourceViewer iSourceViewer) {
            super(iSourceViewer);
        }

        protected boolean isIncluded(Annotation annotation) {
            return TextSourceViewerConfiguration.this.isShownInText(annotation);
        }

        public IInformationControlCreator getHoverControlCreator() {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell shell) {
                    return new DefaultInformationControl(shell, EditorsUI.getTooltipAffordanceString());
                }
            };
        }
    }
}

