/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ISynchronizationContext;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.ILocationProviderExtension;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.UISynchronizationContext;
import org.eclipse.ui.internal.editors.text.WorkspaceOperationRunner;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IDocumentProviderExtension2;
import org.eclipse.ui.texteditor.IDocumentProviderExtension3;
import org.eclipse.ui.texteditor.IDocumentProviderExtension4;
import org.eclipse.ui.texteditor.IDocumentProviderExtension5;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.IElementStateListenerExtension;
import org.eclipse.ui.texteditor.ISchedulingRuleProvider;
import org.osgi.framework.Bundle;

public class TextFileDocumentProvider
implements IDocumentProvider,
IDocumentProviderExtension,
IDocumentProviderExtension2,
IDocumentProviderExtension3,
IDocumentProviderExtension5,
IStorageDocumentProvider,
IDocumentProviderExtension4 {
    private IDocumentProvider fParentProvider;
    private final Map fFileInfoMap = new HashMap();
    private final Map fFileBufferMap = new HashMap();
    private List fElementStateListeners = new ArrayList();
    private final IFileBufferListener fFileBufferListener = new FileBufferListener();
    private IProgressMonitor fProgressMonitor;
    private WorkspaceOperationRunner fOperationRunner;
    private IResourceRuleFactory fResourceRuleFactory;

    public TextFileDocumentProvider() {
        this(null);
    }

    public TextFileDocumentProvider(IDocumentProvider iDocumentProvider) {
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        iTextFileBufferManager.setSynchronizationContext((ISynchronizationContext)new UISynchronizationContext());
        if (iDocumentProvider != null) {
            this.setParentDocumentProvider(iDocumentProvider);
        }
        this.fResourceRuleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
    }

    public final void setParentDocumentProvider(IDocumentProvider iDocumentProvider) {
        Assert.isTrue((boolean)(iDocumentProvider instanceof IDocumentProviderExtension));
        Assert.isTrue((boolean)(iDocumentProvider instanceof IDocumentProviderExtension2));
        Assert.isTrue((boolean)(iDocumentProvider instanceof IDocumentProviderExtension3));
        Assert.isTrue((boolean)(iDocumentProvider instanceof IStorageDocumentProvider));
        this.fParentProvider = iDocumentProvider;
    }

    protected final IDocumentProvider getParentProvider() {
        if (this.fParentProvider == null) {
            this.fParentProvider = new StorageDocumentProvider();
        }
        return this.fParentProvider;
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor iProgressMonitor) {
        if (this.fOperationRunner == null) {
            this.fOperationRunner = new WorkspaceOperationRunner();
        }
        this.fOperationRunner.setProgressMonitor(iProgressMonitor);
        return this.fOperationRunner;
    }

    protected void executeOperation(DocumentProviderOperation documentProviderOperation, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            IRunnableContext iRunnableContext = this.getOperationRunner(iProgressMonitor);
            if (iRunnableContext != null) {
                iRunnableContext.run(false, false, (IRunnableWithProgress)documentProviderOperation);
            } else {
                documentProviderOperation.run(iProgressMonitor);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof CoreException) {
                throw (CoreException)throwable;
            }
            String string = throwable.getMessage() != null ? throwable.getMessage() : "";
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, string, throwable));
        }
        catch (InterruptedException interruptedException) {
            String string = interruptedException.getMessage() != null ? interruptedException.getMessage() : "";
            throw new CoreException((IStatus)new Status(8, "org.eclipse.ui.editors", 0, string, (Throwable)interruptedException));
        }
    }

    public void connect(Object object) throws CoreException {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo == null) {
            fileInfo = this.createFileInfo(object);
            if (fileInfo == null) {
                this.getParentProvider().connect(object);
                return;
            }
            fileInfo.fElement = object;
            this.fFileInfoMap.put(object, fileInfo);
            this.storeFileBufferMapping(object, fileInfo);
        }
        ++fileInfo.fCount;
    }

    private void storeFileBufferMapping(Object object, FileInfo fileInfo) {
        Object object2 = this.fFileBufferMap.get(fileInfo.fTextFileBuffer);
        if (object2 instanceof List) {
            List list = (List)object2;
            list.add(object);
            return;
        }
        if (object2 == null) {
            object2 = object;
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(object2);
            arrayList.add(object);
            object2 = arrayList;
        }
        this.fFileBufferMap.put(fileInfo.fTextFileBuffer, object2);
    }

    protected FileInfo createEmptyFileInfo() {
        return new FileInfo();
    }

    protected FileInfo createFileInfo(Object object) throws CoreException {
        Object object2;
        if (!(object instanceof IAdaptable)) {
            return null;
        }
        IAdaptable iAdaptable = (IAdaptable)object;
        IFile iFile = null;
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer iTextFileBuffer = null;
        LocationKind locationKind = null;
        iFile = (IFile)iAdaptable.getAdapter(IFile.class);
        if (iFile != null) {
            object2 = iFile.getFullPath();
            locationKind = LocationKind.IFILE;
            iTextFileBufferManager.connect((IPath)object2, locationKind, this.getProgressMonitor());
            iTextFileBuffer = iTextFileBufferManager.getTextFileBuffer((IPath)object2, locationKind);
        } else {
            URI uRI;
            object2 = (ILocationProvider)iAdaptable.getAdapter(ILocationProvider.class);
            if (object2 instanceof ILocationProviderExtension) {
                uRI = ((ILocationProviderExtension)object2).getURI(object);
                if (ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uRI).length == 0) {
                    IFileStore iFileStore = EFS.getStore((URI)uRI);
                    iTextFileBufferManager.connectFileStore(iFileStore, this.getProgressMonitor());
                    iTextFileBuffer = iTextFileBufferManager.getFileStoreTextFileBuffer(iFileStore);
                }
            }
            if (iTextFileBuffer == null && object2 != null) {
                uRI = object2.getPath(object);
                if (uRI == null) {
                    return null;
                }
                locationKind = LocationKind.NORMALIZE;
                iTextFileBufferManager.connect((IPath)uRI, locationKind, this.getProgressMonitor());
                iTextFileBuffer = iTextFileBufferManager.getTextFileBuffer((IPath)uRI, locationKind);
                iFile = FileBuffers.getWorkspaceFileAtLocation((IPath)uRI);
            }
        }
        if (iTextFileBuffer != null) {
            iTextFileBuffer.requestSynchronizationContext();
            object2 = this.createEmptyFileInfo();
            ((FileInfo)object2).fTextFileBuffer = iTextFileBuffer;
            ((FileInfo)object2).fTextFileBufferLocationKind = locationKind;
            ((FileInfo)object2).fCachedReadOnlyState = this.isSystemFileReadOnly((FileInfo)object2);
            if (iFile != null) {
                ((FileInfo)object2).fModel = this.createAnnotationModel(iFile);
            }
            if (((FileInfo)object2).fModel == null) {
                ((FileInfo)object2).fModel = ((FileInfo)object2).fTextFileBuffer.getAnnotationModel();
            }
            this.setUpSynchronization((FileInfo)object2);
            return object2;
        }
        return null;
    }

    protected void setUpSynchronization(FileInfo fileInfo) {
        if (fileInfo == null || fileInfo.fTextFileBuffer == null) {
            return;
        }
        IDocument iDocument = fileInfo.fTextFileBuffer.getDocument();
        IAnnotationModel iAnnotationModel = fileInfo.fModel;
        if (iDocument instanceof ISynchronizable) {
            Object object = ((ISynchronizable)iDocument).getLockObject();
            if (object == null) {
                object = new Object();
                ((ISynchronizable)iDocument).setLockObject(object);
            }
            if (iAnnotationModel instanceof ISynchronizable) {
                ((ISynchronizable)iAnnotationModel).setLockObject(object);
            }
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile iFile) {
        return null;
    }

    public void disconnect(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo == null) {
            this.getParentProvider().disconnect(object);
            return;
        }
        if (fileInfo.fCount == 1) {
            this.fFileInfoMap.remove(object);
            this.removeFileBufferMapping(object, fileInfo);
            this.disposeFileInfo(object, fileInfo);
        } else {
            --fileInfo.fCount;
        }
    }

    private void removeFileBufferMapping(Object object, FileInfo fileInfo) {
        Object v = this.fFileBufferMap.get(fileInfo.fTextFileBuffer);
        if (v == null) {
            return;
        }
        if (v instanceof List) {
            List list = (List)v;
            list.remove(object);
            if (list.size() == 1) {
                this.fFileBufferMap.put(fileInfo.fTextFileBuffer, list.get(0));
            }
        } else if (v == object) {
            this.fFileBufferMap.remove(fileInfo.fTextFileBuffer);
        }
    }

    protected void disposeFileInfo(Object object, FileInfo fileInfo) {
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        try {
            fileInfo.fTextFileBuffer.releaseSynchronizationContext();
            if (fileInfo.fTextFileBufferLocationKind != null) {
                iTextFileBufferManager.disconnect(fileInfo.fTextFileBuffer.getLocation(), fileInfo.fTextFileBufferLocationKind, this.getProgressMonitor());
            } else {
                iTextFileBufferManager.disconnectFileStore(fileInfo.fTextFileBuffer.getFileStore(), this.getProgressMonitor());
            }
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, "FileDocumentProvider.disposeElementInfo");
        }
    }

    protected Iterator getElements(IFileBuffer iFileBuffer) {
        Object v = this.fFileBufferMap.get(iFileBuffer);
        if (v instanceof List) {
            return new ArrayList((List)v).iterator();
        }
        return new SingleElementIterator(v);
    }

    public IDocument getDocument(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            return fileInfo.fTextFileBuffer.getDocument();
        }
        return this.getParentProvider().getDocument(object);
    }

    public void resetDocument(Object object) throws CoreException {
        final FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            DocumentProviderOperation documentProviderOperation = new DocumentProviderOperation(){

                @Override
                protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                    fileInfo.fTextFileBuffer.revert(iProgressMonitor);
                    if (fileInfo.fModel instanceof AbstractMarkerAnnotationModel) {
                        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = (AbstractMarkerAnnotationModel)fileInfo.fModel;
                        abstractMarkerAnnotationModel.resetMarkers();
                    }
                }

                @Override
                public ISchedulingRule getSchedulingRule() {
                    if (fileInfo.fElement instanceof IFileEditorInput) {
                        IFileEditorInput iFileEditorInput = (IFileEditorInput)fileInfo.fElement;
                        return TextFileDocumentProvider.this.fResourceRuleFactory.refreshRule((IResource)iFileEditorInput.getFile());
                    }
                    return null;
                }
            };
            this.executeOperation(documentProviderOperation, this.getProgressMonitor());
        } else {
            this.getParentProvider().resetDocument(object);
        }
    }

    public final void saveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        if (object == null) {
            return;
        }
        DocumentProviderOperation documentProviderOperation = this.createSaveOperation(object, iDocument, bl);
        if (documentProviderOperation != null) {
            this.executeOperation(documentProviderOperation, iProgressMonitor);
        } else {
            this.getParentProvider().saveDocument(iProgressMonitor, object, iDocument, bl);
        }
    }

    protected DocumentProviderOperation createSaveOperation(Object object, final IDocument iDocument, final boolean bl) throws CoreException {
        final FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            if (fileInfo.fTextFileBuffer.getDocument() != iDocument) {
                Status status = new Status(2, "org.eclipse.ui.editors", 0, TextEditorMessages.TextFileDocumentProvider_saveAsTargetOpenInEditor, null);
                throw new CoreException((IStatus)status);
            }
            return new DocumentProviderOperation(){

                @Override
                public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                    TextFileDocumentProvider.this.commitFileBuffer(iProgressMonitor, fileInfo, bl);
                }

                @Override
                public ISchedulingRule getSchedulingRule() {
                    if (fileInfo.fElement instanceof IFileEditorInput) {
                        IFileEditorInput iFileEditorInput = (IFileEditorInput)fileInfo.fElement;
                        return TextFileDocumentProvider.this.computeSchedulingRule((IResource)iFileEditorInput.getFile());
                    }
                    return null;
                }
            };
        }
        if (object instanceof IFileEditorInput) {
            final IFile iFile = ((IFileEditorInput)object).getFile();
            return new DocumentProviderOperation(){

                @Override
                public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                    TextFileDocumentProvider.this.createFileFromDocument(iProgressMonitor, iFile, iDocument);
                }

                @Override
                public ISchedulingRule getSchedulingRule() {
                    return TextFileDocumentProvider.this.computeSchedulingRule((IResource)iFile);
                }
            };
        }
        if (object instanceof IURIEditorInput) {
            final URI uRI = ((IURIEditorInput)object).getURI();
            return new DocumentProviderOperation(){

                @Override
                public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                    TextFileDocumentProvider.this.createFileStoreFromDocument(iProgressMonitor, uRI, iDocument);
                }

                @Override
                public ISchedulingRule getSchedulingRule() {
                    return null;
                }
            };
        }
        return null;
    }

    protected void commitFileBuffer(IProgressMonitor iProgressMonitor, FileInfo fileInfo, boolean bl) throws CoreException {
        Object object;
        IFile iFile;
        Assert.isNotNull((Object)fileInfo);
        if (fileInfo.fElement instanceof IFileEditorInput && !(iFile = (object = (IFileEditorInput)fileInfo.fElement).getFile()).isSynchronized(0) && this.isDeleted(object)) {
            fileInfo.fTextFileBuffer.setDirty(true);
        }
        fileInfo.fTextFileBuffer.commit(iProgressMonitor, bl);
        if (fileInfo.fModel instanceof AbstractMarkerAnnotationModel) {
            object = (AbstractMarkerAnnotationModel)fileInfo.fModel;
            ((AbstractMarkerAnnotationModel)((Object)object)).updateMarkers(fileInfo.fTextFileBuffer.getDocument());
        }
    }

    protected void createFileFromDocument(IProgressMonitor iProgressMonitor, IFile iFile, IDocument iDocument) throws CoreException {
        try {
            iProgressMonitor.beginTask(TextEditorMessages.TextFileDocumentProvider_beginTask_saving, 2000);
            ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
            iTextFileBufferManager.connect(iFile.getFullPath(), LocationKind.IFILE, iProgressMonitor);
            ITextFileBuffer iTextFileBuffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer(iFile.getFullPath(), LocationKind.IFILE);
            iTextFileBuffer.getDocument().set(iDocument.get());
            iTextFileBuffer.commit(iProgressMonitor, true);
            iTextFileBufferManager.disconnect(iFile.getFullPath(), LocationKind.IFILE, iProgressMonitor);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void createFileStoreFromDocument(IProgressMonitor iProgressMonitor, URI uRI, IDocument iDocument) throws CoreException {
        try {
            iProgressMonitor.beginTask(TextEditorMessages.TextFileDocumentProvider_beginTask_saving, 2000);
            IFileStore iFileStore = EFS.getStore((URI)uRI);
            FileBuffers.getTextFileBufferManager().connectFileStore(iFileStore, iProgressMonitor);
            ITextFileBuffer iTextFileBuffer = FileBuffers.getTextFileBufferManager().getFileStoreTextFileBuffer(iFileStore);
            iTextFileBuffer.getDocument().set(iDocument.get());
            iTextFileBuffer.commit(iProgressMonitor, true);
            FileBuffers.getTextFileBufferManager().disconnectFileStore(iFileStore, iProgressMonitor);
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public long getModificationStamp(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            return fileInfo.fTextFileBuffer.getModificationStamp();
        }
        return this.getParentProvider().getModificationStamp(object);
    }

    public long getSynchronizationStamp(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            return 0L;
        }
        return this.getParentProvider().getSynchronizationStamp(object);
    }

    public boolean isDeleted(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            IFileStore iFileStore = this.getFileStore(fileInfo);
            return iFileStore == null ? true : !iFileStore.fetchInfo().exists();
        }
        return this.getParentProvider().isDeleted(object);
    }

    public boolean mustSaveDocument(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            return fileInfo.fCount == 1 && fileInfo.fTextFileBuffer.isDirty();
        }
        return this.getParentProvider().mustSaveDocument(object);
    }

    public boolean canSaveDocument(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            return fileInfo.fTextFileBuffer.isDirty();
        }
        return this.getParentProvider().canSaveDocument(object);
    }

    public IAnnotationModel getAnnotationModel(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            return fileInfo.fModel;
        }
        return this.getParentProvider().getAnnotationModel(object);
    }

    public void aboutToChange(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo == null) {
            this.getParentProvider().aboutToChange(object);
        }
    }

    public void changed(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo == null) {
            this.getParentProvider().changed(object);
        }
    }

    public void addElementStateListener(IElementStateListener iElementStateListener) {
        Assert.isNotNull((Object)iElementStateListener);
        if (!this.fElementStateListeners.contains(iElementStateListener)) {
            this.fElementStateListeners.add(iElementStateListener);
            if (this.fElementStateListeners.size() == 1) {
                ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
                iTextFileBufferManager.addFileBufferListener(this.fFileBufferListener);
            }
        }
        this.getParentProvider().addElementStateListener(iElementStateListener);
    }

    public void removeElementStateListener(IElementStateListener iElementStateListener) {
        Assert.isNotNull((Object)iElementStateListener);
        this.fElementStateListeners.remove(iElementStateListener);
        if (this.fElementStateListeners.size() == 0) {
            ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
            iTextFileBufferManager.removeFileBufferListener(this.fFileBufferListener);
        }
        this.getParentProvider().removeElementStateListener(iElementStateListener);
    }

    public boolean isReadOnly(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            return fileInfo.fCachedReadOnlyState;
        }
        return ((IDocumentProviderExtension)this.getParentProvider()).isReadOnly(object);
    }

    public boolean isModifiable(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            return fileInfo.fTextFileBuffer.isStateValidated() ? !this.isReadOnly(object) : true;
        }
        return ((IDocumentProviderExtension)this.getParentProvider()).isModifiable(object);
    }

    public void validateState(Object object, final Object object2) throws CoreException {
        final FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            DocumentProviderOperation documentProviderOperation = new DocumentProviderOperation(){

                @Override
                protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                    fileInfo.fTextFileBuffer.validateState(iProgressMonitor, object2);
                }

                @Override
                public ISchedulingRule getSchedulingRule() {
                    if (fileInfo.fElement instanceof IFileEditorInput) {
                        IFileEditorInput iFileEditorInput = (IFileEditorInput)fileInfo.fElement;
                        return TextFileDocumentProvider.this.fResourceRuleFactory.validateEditRule(new IResource[]{iFileEditorInput.getFile()});
                    }
                    return null;
                }
            };
            this.executeOperation(documentProviderOperation, this.getProgressMonitor());
        } else {
            ((IDocumentProviderExtension)this.getParentProvider()).validateState(object, object2);
        }
    }

    public boolean isStateValidated(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            return fileInfo.fTextFileBuffer.isStateValidated();
        }
        return ((IDocumentProviderExtension)this.getParentProvider()).isStateValidated(object);
    }

    public void updateStateCache(Object object) throws CoreException {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            boolean bl = this.isSystemFileReadOnly(fileInfo);
            if (!fileInfo.fCachedReadOnlyState && bl) {
                fileInfo.fTextFileBuffer.resetStateValidation();
            }
            fileInfo.fCachedReadOnlyState = bl;
        } else {
            ((IDocumentProviderExtension)this.getParentProvider()).updateStateCache(object);
        }
    }

    public void setCanSaveDocument(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo == null) {
            ((IDocumentProviderExtension)this.getParentProvider()).setCanSaveDocument(object);
        }
    }

    public IStatus getStatus(Object object) {
        IFile iFile;
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo == null) {
            return ((IDocumentProviderExtension)this.getParentProvider()).getStatus(object);
        }
        IStatus iStatus = fileInfo.fTextFileBuffer.getStatus();
        if (iStatus.getCode() == 274) {
            String string = iStatus.getMessage();
            IBindingService iBindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
            String string2 = iBindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.file.refresh");
            string = string2 != null ? String.valueOf(string) + NLSUtility.format(TextEditorMessages.TextFileDocumentProvider_error_outOfSyncHintWithKeyBinding, string2) : String.valueOf(string) + TextEditorMessages.TextFileDocumentProvider_error_outOfSyncHint;
            return new Status(iStatus.getSeverity(), iStatus.getPlugin(), iStatus.getCode(), string, iStatus.getException());
        }
        if (iStatus.getSeverity() != 4 && object instanceof IFileEditorInput && ((iFile = FileBuffers.getWorkspaceFileAtLocation((IPath)fileInfo.fTextFileBuffer.getLocation())) == null || !iFile.exists())) {
            String string = NLSUtility.format(TextEditorMessages.TextFileDocumentProvider_error_doesNotExist, ((IFileEditorInput)object).getFile().getFullPath());
            return new Status(4, "org.eclipse.ui.editors", 368, string, null);
        }
        return iStatus;
    }

    public void synchronize(Object object) throws CoreException {
        final FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            DocumentProviderOperation documentProviderOperation = new DocumentProviderOperation(){

                @Override
                protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                    fileInfo.fTextFileBuffer.revert(iProgressMonitor);
                }

                @Override
                public ISchedulingRule getSchedulingRule() {
                    if (fileInfo.fElement instanceof IFileEditorInput) {
                        IFileEditorInput iFileEditorInput = (IFileEditorInput)fileInfo.fElement;
                        return TextFileDocumentProvider.this.fResourceRuleFactory.refreshRule((IResource)iFileEditorInput.getFile());
                    }
                    return null;
                }
            };
            this.executeOperation(documentProviderOperation, this.getProgressMonitor());
        } else {
            ((IDocumentProviderExtension)this.getParentProvider()).synchronize(object);
        }
    }

    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.fProgressMonitor = iProgressMonitor;
        ((IDocumentProviderExtension2)this.getParentProvider()).setProgressMonitor(iProgressMonitor);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    public boolean isSynchronized(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            return fileInfo.fTextFileBuffer.isSynchronized();
        }
        return ((IDocumentProviderExtension3)this.getParentProvider()).isSynchronized(object);
    }

    public boolean isNotSynchronizedException(Object object, CoreException coreException) {
        IStatus iStatus = coreException.getStatus();
        if (iStatus == null || iStatus instanceof MultiStatus) {
            return false;
        }
        if (iStatus.getException() != null) {
            return false;
        }
        return iStatus.getCode() == 274;
    }

    @Override
    public String getDefaultEncoding() {
        return FileBuffers.getTextFileBufferManager().getDefaultEncoding();
    }

    @Override
    public String getEncoding(Object object) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            return fileInfo.fTextFileBuffer.getEncoding();
        }
        return ((IStorageDocumentProvider)this.getParentProvider()).getEncoding(object);
    }

    @Override
    public void setEncoding(Object object, String string) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            fileInfo.fTextFileBuffer.setEncoding(string);
        } else {
            ((IStorageDocumentProvider)this.getParentProvider()).setEncoding(object, string);
        }
    }

    public IContentType getContentType(Object object) throws CoreException {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(object);
        if (fileInfo != null) {
            return fileInfo.fTextFileBuffer.getContentType();
        }
        IDocumentProvider iDocumentProvider = this.getParentProvider();
        if (iDocumentProvider instanceof IDocumentProviderExtension4) {
            return ((IDocumentProviderExtension4)iDocumentProvider).getContentType(object);
        }
        return null;
    }

    protected void handleCoreException(CoreException coreException, String string) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog iLog = Platform.getLog((Bundle)bundle);
        Status status = string != null ? new Status(4, "org.eclipse.ui", 0, string, (Throwable)coreException) : coreException.getStatus();
        iLog.log((IStatus)status);
    }

    protected IFileStore getFileStore(FileInfo fileInfo) {
        return fileInfo.fTextFileBuffer.getFileStore();
    }

    protected File getSystemFile(FileInfo fileInfo) {
        IPath iPath = fileInfo.fTextFileBuffer.getLocation();
        return FileBuffers.getSystemFileAtLocation((IPath)iPath);
    }

    protected boolean isSystemFileReadOnly(FileInfo fileInfo) {
        IFileStore iFileStore = this.getFileStore(fileInfo);
        if (iFileStore == null) {
            return false;
        }
        IFileInfo iFileInfo = iFileStore.fetchInfo();
        return iFileInfo.exists() && iFileInfo.getAttribute(2);
    }

    protected FileInfo getFileInfo(Object object) {
        return (FileInfo)this.fFileInfoMap.get(object);
    }

    protected Iterator getConnectedElementsIterator() {
        return new HashSet(this.fFileInfoMap.keySet()).iterator();
    }

    protected Iterator getFileInfosIterator() {
        return new ArrayList(this.fFileInfoMap.values()).iterator();
    }

    protected void fireElementStateChanging(Object object) {
        ArrayList arrayList = new ArrayList(this.fElementStateListeners);
        for (Object e : arrayList) {
            if (!(e instanceof IElementStateListenerExtension)) continue;
            IElementStateListenerExtension iElementStateListenerExtension = (IElementStateListenerExtension)e;
            iElementStateListenerExtension.elementStateChanging(object);
        }
    }

    protected void fireElementStateChangeFailed(Object object) {
        ArrayList arrayList = new ArrayList(this.fElementStateListeners);
        for (Object e : arrayList) {
            if (!(e instanceof IElementStateListenerExtension)) continue;
            IElementStateListenerExtension iElementStateListenerExtension = (IElementStateListenerExtension)e;
            iElementStateListenerExtension.elementStateChangeFailed(object);
        }
    }

    protected ISchedulingRule computeSchedulingRule(IResource iResource) {
        if (iResource.exists()) {
            return this.fResourceRuleFactory.modifyRule(iResource);
        }
        IResource iResource2 = iResource;
        while ((iResource2 = (iResource = iResource2).getParent()) != null && !iResource2.exists()) {
        }
        return this.fResourceRuleFactory.createRule(iResource);
    }

    protected static abstract class DocumentProviderOperation
    implements IRunnableWithProgress,
    ISchedulingRuleProvider {
        protected DocumentProviderOperation() {
        }

        protected abstract void execute(IProgressMonitor var1) throws CoreException;

        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            try {
                this.execute(iProgressMonitor);
            }
            catch (CoreException coreException) {
                throw new InvocationTargetException(coreException);
            }
        }

        public ISchedulingRule getSchedulingRule() {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
    }

    protected class FileBufferListener
    implements IFileBufferListener {
        public void bufferContentAboutToBeReplaced(IFileBuffer iFileBuffer) {
            ArrayList arrayList = new ArrayList(TextFileDocumentProvider.this.fElementStateListeners);
            for (IElementStateListener iElementStateListener : arrayList) {
                Iterator iterator = TextFileDocumentProvider.this.getElements(iFileBuffer);
                while (iterator.hasNext()) {
                    iElementStateListener.elementContentAboutToBeReplaced(iterator.next());
                }
            }
        }

        public void bufferContentReplaced(IFileBuffer iFileBuffer) {
            ArrayList arrayList = new ArrayList(TextFileDocumentProvider.this.fElementStateListeners);
            for (IElementStateListener iElementStateListener : arrayList) {
                Iterator iterator = TextFileDocumentProvider.this.getElements(iFileBuffer);
                while (iterator.hasNext()) {
                    iElementStateListener.elementContentReplaced(iterator.next());
                }
            }
        }

        public void stateChanging(IFileBuffer iFileBuffer) {
            Iterator iterator = TextFileDocumentProvider.this.getElements(iFileBuffer);
            while (iterator.hasNext()) {
                TextFileDocumentProvider.this.fireElementStateChanging(iterator.next());
            }
        }

        public void dirtyStateChanged(IFileBuffer iFileBuffer, boolean bl) {
            ArrayList arrayList = new ArrayList(TextFileDocumentProvider.this.fElementStateListeners);
            for (IElementStateListener iElementStateListener : arrayList) {
                Iterator iterator = TextFileDocumentProvider.this.getElements(iFileBuffer);
                while (iterator.hasNext()) {
                    iElementStateListener.elementDirtyStateChanged(iterator.next(), bl);
                }
            }
        }

        public void stateValidationChanged(IFileBuffer iFileBuffer, boolean bl) {
            ArrayList arrayList = new ArrayList(TextFileDocumentProvider.this.fElementStateListeners);
            for (Object e : arrayList) {
                if (!(e instanceof IElementStateListenerExtension)) continue;
                IElementStateListenerExtension iElementStateListenerExtension = (IElementStateListenerExtension)e;
                Iterator iterator = TextFileDocumentProvider.this.getElements(iFileBuffer);
                while (iterator.hasNext()) {
                    iElementStateListenerExtension.elementStateValidationChanged(iterator.next(), bl);
                }
            }
        }

        public void underlyingFileMoved(IFileBuffer iFileBuffer, IPath iPath) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IFile iFile = iWorkspace.getRoot().getFile(iPath);
            FileEditorInput fileEditorInput = new FileEditorInput(iFile);
            ArrayList arrayList = new ArrayList(TextFileDocumentProvider.this.fElementStateListeners);
            for (IElementStateListener iElementStateListener : arrayList) {
                Iterator iterator = TextFileDocumentProvider.this.getElements(iFileBuffer);
                while (iterator.hasNext()) {
                    iElementStateListener.elementMoved(iterator.next(), (Object)fileEditorInput);
                }
            }
        }

        public void underlyingFileDeleted(IFileBuffer iFileBuffer) {
            ArrayList arrayList = new ArrayList(TextFileDocumentProvider.this.fElementStateListeners);
            for (IElementStateListener iElementStateListener : arrayList) {
                Iterator iterator = TextFileDocumentProvider.this.getElements(iFileBuffer);
                while (iterator.hasNext()) {
                    iElementStateListener.elementDeleted(iterator.next());
                }
            }
        }

        public void stateChangeFailed(IFileBuffer iFileBuffer) {
            Iterator iterator = TextFileDocumentProvider.this.getElements(iFileBuffer);
            while (iterator.hasNext()) {
                TextFileDocumentProvider.this.fireElementStateChangeFailed(iterator.next());
            }
        }

        public void bufferCreated(IFileBuffer iFileBuffer) {
        }

        public void bufferDisposed(IFileBuffer iFileBuffer) {
        }
    }

    protected static class FileInfo {
        public Object fElement;
        public int fCount;
        public ITextFileBuffer fTextFileBuffer;
        public LocationKind fTextFileBufferLocationKind;
        public IAnnotationModel fModel;
        public boolean fCachedReadOnlyState;

        protected FileInfo() {
        }
    }

    protected static class NullProvider
    implements IDocumentProvider,
    IDocumentProviderExtension,
    IDocumentProviderExtension2,
    IDocumentProviderExtension3,
    IDocumentProviderExtension4,
    IDocumentProviderExtension5,
    IStorageDocumentProvider {
        private static final IStatus STATUS_ERROR = new Status(4, "org.eclipse.ui.editors", 0, TextEditorMessages.NullProvider_error, null);

        protected NullProvider() {
        }

        public void connect(Object object) throws CoreException {
        }

        public void disconnect(Object object) {
        }

        public IDocument getDocument(Object object) {
            return null;
        }

        public void resetDocument(Object object) throws CoreException {
        }

        public void saveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        }

        public long getModificationStamp(Object object) {
            return 0L;
        }

        public long getSynchronizationStamp(Object object) {
            return 0L;
        }

        public boolean isDeleted(Object object) {
            return true;
        }

        public boolean mustSaveDocument(Object object) {
            return false;
        }

        public boolean canSaveDocument(Object object) {
            return false;
        }

        public IAnnotationModel getAnnotationModel(Object object) {
            return null;
        }

        public void aboutToChange(Object object) {
        }

        public void changed(Object object) {
        }

        public void addElementStateListener(IElementStateListener iElementStateListener) {
        }

        public void removeElementStateListener(IElementStateListener iElementStateListener) {
        }

        public boolean isReadOnly(Object object) {
            return true;
        }

        public boolean isModifiable(Object object) {
            return false;
        }

        public void validateState(Object object, Object object2) throws CoreException {
        }

        public boolean isStateValidated(Object object) {
            return true;
        }

        public void updateStateCache(Object object) throws CoreException {
        }

        public void setCanSaveDocument(Object object) {
        }

        public IStatus getStatus(Object object) {
            return STATUS_ERROR;
        }

        public void synchronize(Object object) throws CoreException {
        }

        public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        }

        public IProgressMonitor getProgressMonitor() {
            return new NullProgressMonitor();
        }

        public boolean isSynchronized(Object object) {
            return true;
        }

        public boolean isNotSynchronizedException(Object object, CoreException coreException) {
            return false;
        }

        @Override
        public String getDefaultEncoding() {
            return null;
        }

        @Override
        public String getEncoding(Object object) {
            return null;
        }

        @Override
        public void setEncoding(Object object, String string) {
        }

        public IContentType getContentType(Object object) throws CoreException {
            return null;
        }
    }

    private static class SingleElementIterator
    implements Iterator {
        private Object fElement;

        public SingleElementIterator(Object object) {
            this.fElement = object;
        }

        @Override
        public boolean hasNext() {
            return this.fElement != null;
        }

        public Object next() {
            if (this.fElement != null) {
                Object object = this.fElement;
                this.fElement = null;
                return object;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

