/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class TextEditorActionContributor
extends BasicTextEditorActionContributor {
    private RetargetTextEditorAction fChangeEncodingAction = new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ChangeEncodingAction.");
    private RetargetTextEditorAction fQuickAssistAction = new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.QuickAssist.");
    private IContributionItem fQuickAssistMenuEntry;
    private RetargetTextEditorAction fRetargetShowInformationAction;

    public TextEditorActionContributor() {
        this.fQuickAssistAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        this.fQuickAssistMenuEntry = new ActionContributionItem((IAction)this.fQuickAssistAction);
        this.fRetargetShowInformationAction = new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ShowInformation.");
        this.fRetargetShowInformationAction.setActionDefinitionId("org.eclipse.ui.edit.text.showInformation");
    }

    private void doSetActiveEditor(IEditorPart iEditorPart) {
        ITextEditor iTextEditor = null;
        if (iEditorPart instanceof ITextEditor) {
            iTextEditor = (ITextEditor)iEditorPart;
        }
        IActionBars iActionBars = this.getActionBars();
        iActionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), this.getAction(iTextEditor, IDEActionFactory.ADD_TASK.getId()));
        iActionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(iTextEditor, IDEActionFactory.BOOKMARK.getId()));
        IAction iAction = this.getAction(iTextEditor, ITextEditorActionConstants.NEXT);
        iActionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", iAction);
        iActionBars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, iAction);
        iAction = this.getAction(iTextEditor, ITextEditorActionConstants.PREVIOUS);
        iActionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", iAction);
        iActionBars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, iAction);
        iAction = this.getAction(iTextEditor, ITextEditorActionConstants.REFRESH);
        iActionBars.setGlobalActionHandler(ITextEditorActionConstants.REFRESH, iAction);
        this.fChangeEncodingAction.setAction(this.getAction(iTextEditor, "ChangeEncoding"));
        IAction iAction2 = this.getAction(iTextEditor, "QuickAssist");
        this.fQuickAssistAction.setAction(iAction2);
        if (iTextEditor == null) {
            return;
        }
        IMenuManager iMenuManager = iTextEditor.getEditorSite().getActionBars().getMenuManager();
        IMenuManager iMenuManager2 = iMenuManager.findMenuUsingPath("edit");
        if (iMenuManager2 != null) {
            boolean bl = iAction2 != null && iAction2.isEnabled();
            this.fQuickAssistMenuEntry.setVisible(bl);
            iMenuManager2.update(true);
        }
        this.fRetargetShowInformationAction.setAction(this.getAction(iTextEditor, "ShowInformation"));
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        super.contributeToMenu(iMenuManager);
        IMenuManager iMenuManager2 = iMenuManager.findMenuUsingPath("edit");
        if (iMenuManager2 != null) {
            iMenuManager2.appendToGroup("group.assist", this.fQuickAssistMenuEntry);
            this.fQuickAssistMenuEntry.setVisible(false);
            iMenuManager2.appendToGroup("group.information", (IAction)this.fRetargetShowInformationAction);
        }
    }

    public void setActiveEditor(IEditorPart iEditorPart) {
        super.setActiveEditor(iEditorPart);
        this.doSetActiveEditor(iEditorPart);
    }

    public void dispose() {
        this.doSetActiveEditor(null);
        super.dispose();
    }

    public void init(IActionBars iActionBars) {
        super.init(iActionBars);
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        IMenuManager iMenuManager2 = iMenuManager.findMenuUsingPath("edit");
        if (iMenuManager2 != null) {
            iMenuManager2.add((IAction)this.fChangeEncodingAction);
        }
    }
}

