/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class TextEditor
extends AbstractDecoratedTextEditor {
    protected DefaultEncodingSupport fEncodingSupport;

    public TextEditor() {
        if (this.getSourceViewerConfiguration() == null) {
            this.setSourceViewerConfiguration(new TextSourceViewerConfiguration(this.getPreferenceStore()));
        }
    }

    @Override
    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId("#TextEditorContext");
        this.setRulerContextMenuId("#TextRulerContext");
        this.setHelpContextId("org.eclipse.ui.text_editor_context");
        this.configureInsertMode(SMART_INSERT, false);
        this.setInsertMode(INSERT);
    }

    @Override
    public void dispose() {
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.dispose();
            this.fEncodingSupport = null;
        }
        super.dispose();
    }

    protected void installEncodingSupport() {
        this.fEncodingSupport = new DefaultEncodingSupport();
        this.fEncodingSupport.initialize(this);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    protected void createActions() {
        this.installEncodingSupport();
        super.createActions();
    }

    protected String getStatusHeader(IStatus iStatus) {
        String string;
        if (this.fEncodingSupport != null && (string = this.fEncodingSupport.getStatusHeader(iStatus)) != null) {
            return string;
        }
        return super.getStatusHeader(iStatus);
    }

    protected String getStatusBanner(IStatus iStatus) {
        String string;
        if (this.fEncodingSupport != null && (string = this.fEncodingSupport.getStatusBanner(iStatus)) != null) {
            return string;
        }
        return super.getStatusBanner(iStatus);
    }

    protected String getStatusMessage(IStatus iStatus) {
        String string;
        if (this.fEncodingSupport != null && (string = this.fEncodingSupport.getStatusMessage(iStatus)) != null) {
            return string;
        }
        return super.getStatusMessage(iStatus);
    }

    @Override
    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        super.doSetInput(iEditorInput);
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    @Override
    public Object getAdapter(Class clazz) {
        if (IEncodingSupport.class.equals((Object)clazz)) {
            return this.fEncodingSupport;
        }
        return super.getAdapter(clazz);
    }

    protected void updatePropertyDependentActions() {
        super.updatePropertyDependentActions();
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    @Override
    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("spellingEnabled")) {
            IAction iAction;
            ISourceViewer iSourceViewer = this.getSourceViewer();
            if (!(iSourceViewer instanceof ISourceViewerExtension2)) {
                return;
            }
            ((ISourceViewerExtension2)iSourceViewer).unconfigure();
            iSourceViewer.configure(this.getSourceViewerConfiguration());
            if (Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                SpellingProblem.removeAll((ISourceViewer)this.getSourceViewer(), null);
            }
            if ((iAction = this.getAction("QuickAssist")) instanceof IUpdate) {
                ((IUpdate)iAction).update();
            }
            return;
        }
        super.handlePreferenceStoreChanged(propertyChangeEvent);
    }

    @Override
    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
        this.addAction(iMenuManager, "group.edit", "ShiftRight");
        this.addAction(iMenuManager, "group.edit", "ShiftLeft");
    }
}

