/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.DocumentReader;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.osgi.framework.Bundle;

public class StorageDocumentProvider
extends AbstractDocumentProvider
implements IStorageDocumentProvider {
    protected static final int DEFAULT_FILE_SIZE = 15360;
    private static final QualifiedName[] NO_PROPERTIES = new QualifiedName[0];

    protected void setDocumentContent(IDocument iDocument, InputStream inputStream) throws CoreException {
        this.setDocumentContent(iDocument, inputStream, null);
    }

    protected void setDocumentContent(IDocument iDocument, InputStream inputStream, String string) throws CoreException {
        Reader reader = null;
        try {
            try {
                if (string == null) {
                    string = this.getDefaultEncoding();
                }
                reader = new BufferedReader(new InputStreamReader(inputStream, string), 15360);
                StringBuffer stringBuffer = new StringBuffer(15360);
                char[] cArray = new char[2048];
                int n = reader.read(cArray);
                while (n > 0) {
                    stringBuffer.append(cArray, 0, n);
                    n = reader.read(cArray);
                }
                iDocument.set(stringBuffer.toString());
            }
            catch (IOException iOException) {
                String string2 = iOException.getMessage() != null ? iOException.getMessage() : "";
                Status status = new Status(4, "org.eclipse.ui", 0, string2, (Throwable)iOException);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            try {
                if (reader != null) {
                    reader.close();
                } else {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (reader != null) {
                reader.close();
            } else {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput) throws CoreException {
        return this.setDocumentContent(iDocument, iEditorInput, null);
    }

    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput, String string) throws CoreException {
        if (iEditorInput instanceof IStorageEditorInput) {
            IStorage iStorage = ((IStorageEditorInput)iEditorInput).getStorage();
            InputStream inputStream = iStorage.getContents();
            try {
                this.setDocumentContent(iDocument, inputStream, string);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return true;
        }
        return false;
    }

    protected IAnnotationModel createAnnotationModel(Object object) throws CoreException {
        return null;
    }

    protected IDocument createEmptyDocument() {
        return new Document();
    }

    protected IDocument createDocument(Object object) throws CoreException {
        IDocument iDocument;
        if (object instanceof IEditorInput && this.setDocumentContent(iDocument = this.createEmptyDocument(), (IEditorInput)object, this.getEncoding(object))) {
            this.setupDocument(object, iDocument);
            return iDocument;
        }
        return null;
    }

    protected void setupDocument(Object object, IDocument iDocument) {
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object object) throws CoreException {
        if (object instanceof IStorageEditorInput) {
            IDocument iDocument = null;
            IStatus iStatus = null;
            try {
                iDocument = this.createDocument(object);
            }
            catch (CoreException coreException) {
                iStatus = coreException.getStatus();
                iDocument = this.createEmptyDocument();
            }
            StorageInfo storageInfo = new StorageInfo(iDocument, this.createAnnotationModel(object));
            storageInfo.fStatus = iStatus;
            storageInfo.fEncoding = this.getPersistedEncoding(object);
            return storageInfo;
        }
        return super.createElementInfo(object);
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
    }

    protected void handleCoreException(CoreException coreException, String string) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog iLog = Platform.getLog((Bundle)bundle);
        if (string != null) {
            iLog.log((IStatus)new Status(4, "org.eclipse.ui", 0, string, (Throwable)coreException));
        } else {
            iLog.log(coreException.getStatus());
        }
    }

    protected void updateCache(IStorageEditorInput iStorageEditorInput) throws CoreException {
        StorageInfo storageInfo = (StorageInfo)this.getElementInfo(iStorageEditorInput);
        if (storageInfo != null) {
            try {
                IStorage iStorage = iStorageEditorInput.getStorage();
                if (iStorage != null) {
                    boolean bl;
                    storageInfo.fIsReadOnly = bl = iStorage.isReadOnly();
                    storageInfo.fIsModifiable = !bl;
                }
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, TextEditorMessages.StorageDocumentProvider_updateCache);
            }
            storageInfo.fUpdateCache = false;
        }
    }

    public boolean isReadOnly(Object object) {
        StorageInfo storageInfo;
        if (object instanceof IStorageEditorInput && (storageInfo = (StorageInfo)this.getElementInfo(object)) != null) {
            if (storageInfo.fUpdateCache) {
                try {
                    this.updateCache((IStorageEditorInput)object);
                }
                catch (CoreException coreException) {
                    this.handleCoreException(coreException, TextEditorMessages.StorageDocumentProvider_isReadOnly);
                }
            }
            return storageInfo.fIsReadOnly;
        }
        return super.isReadOnly(object);
    }

    public boolean isNotSynchronizedException(Object object, CoreException coreException) {
        IStatus iStatus = coreException.getStatus();
        if (iStatus == null || iStatus instanceof MultiStatus) {
            return false;
        }
        if (iStatus.getException() != null) {
            return false;
        }
        return iStatus.getCode() == 274;
    }

    public boolean isModifiable(Object object) {
        StorageInfo storageInfo;
        if (object instanceof IStorageEditorInput && (storageInfo = (StorageInfo)this.getElementInfo(object)) != null) {
            if (storageInfo.fUpdateCache) {
                try {
                    this.updateCache((IStorageEditorInput)object);
                }
                catch (CoreException coreException) {
                    this.handleCoreException(coreException, TextEditorMessages.StorageDocumentProvider_isModifiable);
                }
            }
            return storageInfo.fIsModifiable;
        }
        return super.isModifiable(object);
    }

    protected void doUpdateStateCache(Object object) throws CoreException {
        StorageInfo storageInfo;
        if (object instanceof IStorageEditorInput && (storageInfo = (StorageInfo)this.getElementInfo(object)) != null) {
            storageInfo.fUpdateCache = true;
        }
        super.doUpdateStateCache(object);
    }

    @Override
    public String getDefaultEncoding() {
        return ResourcesPlugin.getEncoding();
    }

    @Override
    public String getEncoding(Object object) {
        if (object instanceof IStorageEditorInput) {
            StorageInfo storageInfo = (StorageInfo)this.getElementInfo(object);
            if (storageInfo != null) {
                return storageInfo.fEncoding;
            }
            return this.getPersistedEncoding(object);
        }
        return null;
    }

    @Override
    public void setEncoding(Object object, String string) {
        StorageInfo storageInfo;
        if (object instanceof IStorageEditorInput && (storageInfo = (StorageInfo)this.getElementInfo(object)) != null) {
            storageInfo.fEncoding = string;
            try {
                this.persistEncoding(object, string);
            }
            catch (CoreException coreException) {
                EditorsPlugin.log(coreException.getStatus());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IContentType getContentType(Object object) throws CoreException {
        InputStream inputStream;
        Reader reader;
        block16: {
            IContentType iContentType;
            if (!(object instanceof IStorageEditorInput)) return super.getContentType(object);
            IStorage iStorage = ((IStorageEditorInput)object).getStorage();
            reader = null;
            inputStream = null;
            try {
                IContentDescription iContentDescription;
                IDocument iDocument = this.getDocument(object);
                if (iDocument != null) {
                    reader = new DocumentReader(iDocument);
                    iContentDescription = Platform.getContentTypeManager().getDescriptionFor(reader, iStorage.getName(), NO_PROPERTIES);
                } else {
                    inputStream = iStorage.getContents();
                    iContentDescription = Platform.getContentTypeManager().getDescriptionFor(inputStream, iStorage.getName(), NO_PROPERTIES);
                }
                if (iContentDescription == null || iContentDescription.getContentType() == null) break block16;
                iContentType = iContentDescription.getContentType();
            }
            catch (IOException iOException) {
                try {
                    String string2;
                    IPath iPath = iStorage.getFullPath();
                    String string = iPath != null ? iPath.toOSString() : iStorage.getName();
                    if (string != null) {
                        string2 = NLSUtility.format(TextEditorMessages.StorageDocumentProvider_getContentDescriptionFor, string);
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, string2, (Throwable)iOException));
                    }
                    string2 = TextEditorMessages.StorageDocumentProvider_getContentDescription;
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, string2, (Throwable)iOException));
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
            }
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStream == null) return iContentType;
                inputStream.close();
                return iContentType;
            }
            catch (IOException iOException) {}
            return iContentType;
        }
        try {
            if (reader != null) {
                reader.close();
            }
            if (inputStream == null) return super.getContentType(object);
            inputStream.close();
            return super.getContentType(object);
        }
        catch (IOException iOException) {}
        return super.getContentType(object);
    }

    protected String getPersistedEncoding(Object object) {
        if (object instanceof IStorageEditorInput) {
            try {
                IStorage iStorage = ((IStorageEditorInput)object).getStorage();
                if (iStorage instanceof IEncodedStorage) {
                    return ((IEncodedStorage)iStorage).getCharset();
                }
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    protected void persistEncoding(Object object, String string) throws CoreException {
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor iProgressMonitor) {
        return null;
    }

    protected class StorageInfo
    extends AbstractDocumentProvider.ElementInfo {
        public boolean fIsModifiable;
        public boolean fIsReadOnly;
        public boolean fUpdateCache;
        public String fEncoding;

        public StorageInfo(IDocument iDocument, IAnnotationModel iAnnotationModel) {
            super((AbstractDocumentProvider)StorageDocumentProvider.this, iDocument, iAnnotationModel);
            this.fIsModifiable = false;
            this.fIsReadOnly = true;
            this.fUpdateCache = true;
            this.fEncoding = null;
        }
    }
}

