/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.filebuffers.manipulation.ContainerCreator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.DocumentReader;
import org.eclipse.ui.editors.text.StorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.WorkspaceOperationRunner;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class FileDocumentProvider
extends StorageDocumentProvider {
    private static final QualifiedName ENCODING_KEY = new QualifiedName("org.eclipse.ui.editors", "encoding");
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final String CHARSET_UTF_16 = "UTF-16";
    private static final String CHARSET_UTF_16LE = "UTF-16LE";
    private WorkspaceOperationRunner fOperationRunner;
    private IResourceRuleFactory fResourceRuleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();

    @Override
    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput) throws CoreException {
        if (iEditorInput instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            InputStream inputStream = iFile.getContents(false);
            try {
                this.setDocumentContent(iDocument, inputStream);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return true;
        }
        return super.setDocumentContent(iDocument, iEditorInput);
    }

    @Override
    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput, String string) throws CoreException {
        if (iEditorInput instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            InputStream inputStream = iFile.getContents(false);
            try {
                try {
                    FileInfo fileInfo = (FileInfo)this.getElementInfo(iEditorInput);
                    boolean bl = false;
                    if (CHARSET_UTF_8.equals(string)) {
                        if (fileInfo != null) {
                            bl = fileInfo.fBOM != null;
                        } else {
                            boolean bl2 = bl = this.getBOM(iEditorInput) != null;
                        }
                    }
                    if (bl) {
                        int n;
                        int n2 = 0;
                        do {
                            if ((n = inputStream.read(new byte[IContentDescription.BOM_UTF_8.length])) != -1) continue;
                            throw new IOException();
                        } while ((n2 += n) < IContentDescription.BOM_UTF_8.length);
                    }
                    this.setDocumentContent(iDocument, inputStream, string);
                }
                catch (IOException iOException) {
                    String string2 = iOException.getMessage() != null ? iOException.getMessage() : "";
                    Status status = new Status(4, "org.eclipse.ui", 0, string2, (Throwable)iOException);
                    throw new CoreException((IStatus)status);
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return true;
        }
        return super.setDocumentContent(iDocument, iEditorInput, string);
    }

    @Override
    protected IAnnotationModel createAnnotationModel(Object object) throws CoreException {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return new ResourceMarkerAnnotationModel((IResource)iFileEditorInput.getFile());
        }
        return super.createAnnotationModel(object);
    }

    protected void checkSynchronizationState(long l, IResource iResource) throws CoreException {
        if (l != this.computeModificationStamp(iResource)) {
            Status status = new Status(4, "org.eclipse.ui", 274, TextEditorMessages.FileDocumentProvider_error_out_of_sync, null);
            throw new CoreException((IStatus)status);
        }
    }

    protected long computeModificationStamp(IResource iResource) {
        long l = iResource.getModificationStamp();
        IPath iPath = iResource.getLocation();
        if (iPath == null) {
            return l;
        }
        l = iPath.toFile().lastModified();
        return l;
    }

    public long getModificationStamp(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return this.computeModificationStamp((IResource)iFileEditorInput.getFile());
        }
        return super.getModificationStamp(object);
    }

    public long getSynchronizationStamp(Object object) {
        FileInfo fileInfo;
        if (object instanceof IFileEditorInput && (fileInfo = (FileInfo)this.getElementInfo(object)) != null) {
            return fileInfo.fModificationStamp;
        }
        return super.getSynchronizationStamp(object);
    }

    protected void doSynchronize(Object object, IProgressMonitor iProgressMonitor) throws CoreException {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            FileInfo fileInfo = (FileInfo)this.getElementInfo(object);
            if (fileInfo != null) {
                if (fileInfo.fFileSynchronizer != null) {
                    fileInfo.fFileSynchronizer.uninstall();
                    this.refreshFile(iFileEditorInput.getFile(), iProgressMonitor);
                    fileInfo.fFileSynchronizer.install();
                } else {
                    this.refreshFile(iFileEditorInput.getFile(), iProgressMonitor);
                }
                this.handleElementContentChanged((IFileEditorInput)object);
            }
            return;
        }
        super.doSynchronize(object, iProgressMonitor);
    }

    public boolean isDeleted(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            IPath iPath = iFileEditorInput.getFile().getLocation();
            if (iPath == null) {
                return true;
            }
            return !iPath.toFile().exists();
        }
        return super.isDeleted(object);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        if (object instanceof IFileEditorInput) {
            void var11_19;
            ByteArrayInputStream byteArrayInputStream;
            Object object2;
            Charset charset;
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            String string = null;
            FileInfo fileInfo = (FileInfo)this.getElementInfo(object);
            IFile iFile = iFileEditorInput.getFile();
            string = this.getCharsetForNewFile(iFile, iDocument, fileInfo);
            if (fileInfo != null && fileInfo.fBOM == IContentDescription.BOM_UTF_16LE && CHARSET_UTF_16.equals(string)) {
                string = CHARSET_UTF_16LE;
            }
            try {
                charset = Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                String string2 = NLSUtility.format(TextEditorMessages.DocumentProvider_error_unsupported_encoding_message_arg, string);
                Status status = new Status(4, "org.eclipse.ui.editors", 0, string2, (Throwable)unsupportedCharsetException);
                throw new CoreException((IStatus)status);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                String string3 = NLSUtility.format(TextEditorMessages.DocumentProvider_error_illegal_encoding_message_arg, string);
                Status status = new Status(4, "org.eclipse.ui.editors", 0, string3, (Throwable)illegalCharsetNameException);
                throw new CoreException((IStatus)status);
            }
            CharsetEncoder charsetEncoder = charset.newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            try {
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(iDocument.get()));
                if (byteBuffer.hasArray()) {
                    object2 = byteBuffer.array();
                } else {
                    object2 = new byte[byteBuffer.limit()];
                    byteBuffer.get((byte[])object2);
                }
                byteArrayInputStream = new ByteArrayInputStream((byte[])object2, 0, byteBuffer.limit());
            }
            catch (CharacterCodingException characterCodingException) {
                Assert.isTrue((boolean)(characterCodingException instanceof UnmappableCharacterException));
                String string4 = NLSUtility.format(TextEditorMessages.DocumentProvider_error_charset_mapping_failed_message_arg, string);
                Status status = new Status(4, "org.eclipse.ui.editors", 1, string4, null);
                throw new CoreException((IStatus)status);
            }
            if (fileInfo != null && fileInfo.fBOM == IContentDescription.BOM_UTF_8 && CHARSET_UTF_8.equals(string)) {
                SequenceInputStream sequenceInputStream = new SequenceInputStream(new ByteArrayInputStream(IContentDescription.BOM_UTF_8), byteArrayInputStream);
            }
            if (fileInfo != null && fileInfo.fBOM == IContentDescription.BOM_UTF_16LE && CHARSET_UTF_16LE.equals(string)) {
                void var11_17;
                SequenceInputStream sequenceInputStream = new SequenceInputStream(new ByteArrayInputStream(IContentDescription.BOM_UTF_16LE), (InputStream)var11_17);
            }
            if (iFile.exists()) {
                if (fileInfo != null && !bl) {
                    this.checkSynchronizationState(fileInfo.fModificationStamp, (IResource)iFile);
                }
                this.fireElementStateChanging(object);
                try {
                    iFile.setContents((InputStream)var11_19, bl, true, iProgressMonitor);
                }
                catch (CoreException coreException) {
                    this.fireElementStateChangeFailed(object);
                    throw coreException;
                }
                catch (RuntimeException runtimeException) {
                    this.fireElementStateChangeFailed(object);
                    throw runtimeException;
                }
                if (fileInfo == null) return;
                object2 = (Object)((ResourceMarkerAnnotationModel)fileInfo.fModel);
                if (object2 != null) {
                    ((AbstractMarkerAnnotationModel)((Object)object2)).updateMarkers(fileInfo.fDocument);
                }
                fileInfo.fModificationStamp = this.computeModificationStamp((IResource)iFile);
                return;
            }
            try {
                iProgressMonitor.beginTask(TextEditorMessages.FileDocumentProvider_task_saving, 2000);
                object2 = new ContainerCreator(iFile.getWorkspace(), iFile.getParent().getFullPath());
                object2.createContainer((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                iFile.create((InputStream)var11_19, false, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                return;
            }
            finally {
                iProgressMonitor.done();
            }
        }
        super.doSaveDocument(iProgressMonitor, object, iDocument, bl);
    }

    /*
     * Loose catch block
     */
    private String getCharsetForNewFile(IFile iFile, IDocument iDocument, FileInfo fileInfo) {
        block19: {
            DocumentReader documentReader;
            block18: {
                String string;
                try {
                    string = iFile.getCharset(false);
                }
                catch (CoreException coreException) {
                    string = null;
                }
                if (string != null) {
                    return string;
                }
                documentReader = new DocumentReader(iDocument);
                QualifiedName[] qualifiedNameArray = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                IContentDescription iContentDescription = Platform.getContentTypeManager().getDescriptionFor((Reader)documentReader, iFile.getName(), qualifiedNameArray);
                if (iContentDescription == null || (string = iContentDescription.getCharset()) == null) break block18;
                String string2 = string;
                try {
                    ((Reader)documentReader).close();
                }
                catch (IOException iOException) {}
                return string2;
                catch (IOException iOException) {
                    try {}
                    catch (Throwable throwable) {
                        try {
                            ((Reader)documentReader).close();
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                    try {
                        ((Reader)documentReader).close();
                    }
                    catch (IOException iOException3) {}
                    break block19;
                }
            }
            try {
                ((Reader)documentReader).close();
            }
            catch (IOException iOException) {}
        }
        if (fileInfo != null && fileInfo.fBOM != null) {
            return fileInfo.fEncoding;
        }
        try {
            return iFile.getParent().getDefaultCharset();
        }
        catch (CoreException coreException) {
            return ResourcesPlugin.getEncoding();
        }
    }

    @Override
    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object object) throws CoreException {
        if (object instanceof IFileEditorInput) {
            Object object2;
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            try {
                this.refreshFile(iFileEditorInput.getFile());
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, TextEditorMessages.FileDocumentProvider_createElementInfo);
            }
            IDocument iDocument = null;
            IStatus iStatus = null;
            try {
                iDocument = this.createDocument(object);
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, TextEditorMessages.FileDocumentProvider_createElementInfo);
                iStatus = coreException.getStatus();
                iDocument = this.createEmptyDocument();
            }
            if (iDocument instanceof IDocumentExtension4 && (object2 = this.getLineDelimiterPreference(iFileEditorInput.getFile())) != null) {
                ((IDocumentExtension4)iDocument).setInitialLineDelimiter((String)object2);
            }
            object2 = this.createAnnotationModel(object);
            FileSynchronizer fileSynchronizer = new FileSynchronizer(iFileEditorInput);
            fileSynchronizer.install();
            FileInfo fileInfo = new FileInfo(iDocument, (IAnnotationModel)object2, fileSynchronizer);
            fileInfo.fModificationStamp = this.computeModificationStamp((IResource)iFileEditorInput.getFile());
            fileInfo.fStatus = iStatus;
            fileInfo.fEncoding = this.getPersistedEncoding(object);
            fileInfo.fBOM = this.getBOM(object);
            this.cacheEncodingState(object);
            return fileInfo;
        }
        return super.createElementInfo(object);
    }

    private String getLineDelimiterPreference(IFile iFile) {
        IScopeContext[] iScopeContextArray;
        if (iFile != null && iFile.getProject() != null) {
            iScopeContextArray = new IScopeContext[]{new ProjectScope(iFile.getProject())};
            String string = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, iScopeContextArray);
            if (string != null) {
                return string;
            }
        }
        iScopeContextArray = new IScopeContext[]{InstanceScope.INSTANCE};
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, iScopeContextArray);
    }

    protected void disposeElementInfo(Object object, AbstractDocumentProvider.ElementInfo elementInfo) {
        if (elementInfo instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)elementInfo;
            if (fileInfo.fFileSynchronizer != null) {
                fileInfo.fFileSynchronizer.uninstall();
            }
        }
        super.disposeElementInfo(object, elementInfo);
    }

    protected void handleElementContentChanged(IFileEditorInput iFileEditorInput) {
        FileInfo fileInfo = (FileInfo)this.getElementInfo(iFileEditorInput);
        if (fileInfo == null) {
            return;
        }
        IDocument iDocument = this.createEmptyDocument();
        IStatus iStatus = null;
        try {
            try {
                this.refreshFile(iFileEditorInput.getFile());
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, "FileDocumentProvider.handleElementContentChanged");
            }
            this.cacheEncodingState(iFileEditorInput);
            this.setDocumentContent(iDocument, (IEditorInput)iFileEditorInput, fileInfo.fEncoding);
        }
        catch (CoreException coreException) {
            iStatus = coreException.getStatus();
        }
        String string = iDocument.get();
        if (!string.equals(fileInfo.fDocument.get())) {
            this.fireElementContentAboutToBeReplaced(iFileEditorInput);
            this.removeUnchangedElementListeners(iFileEditorInput, fileInfo);
            fileInfo.fDocument.removeDocumentListener((IDocumentListener)fileInfo);
            fileInfo.fDocument.set(string);
            fileInfo.fCanBeSaved = false;
            fileInfo.fModificationStamp = this.computeModificationStamp((IResource)iFileEditorInput.getFile());
            fileInfo.fStatus = iStatus;
            this.addUnchangedElementListeners(iFileEditorInput, fileInfo);
            this.fireElementContentReplaced(iFileEditorInput);
        } else {
            this.removeUnchangedElementListeners(iFileEditorInput, fileInfo);
            fileInfo.fCanBeSaved = false;
            fileInfo.fModificationStamp = this.computeModificationStamp((IResource)iFileEditorInput.getFile());
            fileInfo.fStatus = iStatus;
            this.addUnchangedElementListeners(iFileEditorInput, fileInfo);
            this.fireElementDirtyStateChanged(iFileEditorInput, false);
        }
    }

    protected void handleElementMoved(IFileEditorInput iFileEditorInput, IPath iPath) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IFile iFile = iWorkspace.getRoot().getFile(iPath);
        this.fireElementMoved(iFileEditorInput, new FileEditorInput(iFile));
    }

    protected void handleElementDeleted(IFileEditorInput iFileEditorInput) {
        this.fireElementDeleted(iFileEditorInput);
    }

    protected AbstractDocumentProvider.ElementInfo getElementInfo(Object object) {
        return super.getElementInfo(object);
    }

    protected void doValidateState(Object object, Object object2) throws CoreException {
        IFileEditorInput iFileEditorInput;
        FileInfo fileInfo;
        if (object instanceof IFileEditorInput && (fileInfo = (FileInfo)this.getElementInfo(iFileEditorInput = (IFileEditorInput)object)) != null) {
            IWorkspace iWorkspace;
            IFile iFile = iFileEditorInput.getFile();
            if (iFile.isReadOnly()) {
                iWorkspace = iFile.getWorkspace();
                fileInfo.fStatus = iWorkspace.validateEdit(new IFile[]{iFile}, object2);
            }
            if (this.isDerived((IResource)iFile)) {
                iWorkspace = new Status(2, "org.eclipse.ui.editors", 5, TextEditorMessages.FileDocumentProvider_warning_fileIsDerived, null);
                fileInfo.fStatus = fileInfo.fStatus == null || fileInfo.fStatus.isOK() ? iWorkspace : new MultiStatus("org.eclipse.ui.editors", 4, new IStatus[]{fileInfo.fStatus, iWorkspace}, TextEditorMessages.FileDocumentProvider_stateValidationFailed, null);
            }
        }
        super.doValidateState(object, object2);
    }

    private boolean isDerived(IResource iResource) {
        while (iResource != null) {
            if (iResource.isDerived()) {
                return true;
            }
            iResource = iResource.getParent();
        }
        return false;
    }

    @Override
    public boolean isModifiable(Object object) {
        if (!this.isStateValidated(object) && object instanceof IFileEditorInput) {
            return true;
        }
        return super.isModifiable(object);
    }

    protected void doResetDocument(Object object, IProgressMonitor iProgressMonitor) throws CoreException {
        IFileEditorInput iFileEditorInput;
        if (object instanceof IFileEditorInput) {
            iFileEditorInput = (IFileEditorInput)object;
            try {
                this.refreshFile(iFileEditorInput.getFile(), iProgressMonitor);
                this.cacheEncodingState(object);
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException, TextEditorMessages.FileDocumentProvider_resetDocument);
            }
        }
        super.doResetDocument(object, iProgressMonitor);
        iFileEditorInput = this.getAnnotationModel(object);
        if (iFileEditorInput instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel abstractMarkerAnnotationModel = (AbstractMarkerAnnotationModel)iFileEditorInput;
            abstractMarkerAnnotationModel.resetMarkers();
        }
    }

    protected void refreshFile(IFile iFile) throws CoreException {
        this.refreshFile(iFile, this.getProgressMonitor());
    }

    protected void refreshFile(IFile iFile, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            iFile.refreshLocal(2, iProgressMonitor);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public boolean isSynchronized(Object object) {
        if (object instanceof IFileEditorInput) {
            if (this.getElementInfo(object) != null) {
                IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
                IFile iFile = iFileEditorInput.getFile();
                return iFile.isSynchronized(0);
            }
            return false;
        }
        return super.isSynchronized(object);
    }

    @Override
    public IContentType getContentType(Object object) throws CoreException {
        IContentType iContentType = null;
        if (!this.canSaveDocument(object) && object instanceof IFileEditorInput) {
            iContentType = this.getContentType((IFileEditorInput)object);
        }
        if (iContentType == null) {
            iContentType = super.getContentType(object);
        }
        if (iContentType == null && object instanceof IFileEditorInput) {
            iContentType = this.getContentType((IFileEditorInput)object);
        }
        return iContentType;
    }

    private IContentType getContentType(IFileEditorInput iFileEditorInput) throws CoreException {
        IContentDescription iContentDescription = iFileEditorInput.getFile().getContentDescription();
        if (iContentDescription != null) {
            return iContentDescription.getContentType();
        }
        return null;
    }

    @Override
    protected String getPersistedEncoding(Object object) {
        IFileEditorInput iFileEditorInput;
        IFile iFile;
        if (object instanceof IFileEditorInput && (iFile = (iFileEditorInput = (IFileEditorInput)object).getFile()) != null) {
            String string = null;
            try {
                string = iFile.getPersistentProperty(ENCODING_KEY);
            }
            catch (CoreException coreException) {}
            if (string != null) {
                try {
                    iFile.setCharset(string, this.getProgressMonitor());
                    iFile.setPersistentProperty(ENCODING_KEY, null);
                }
                catch (CoreException coreException) {
                    this.handleCoreException(coreException, TextEditorMessages.FileDocumentProvider_getPersistedEncoding);
                }
            } else {
                try {
                    string = iFile.getCharset();
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            return string;
        }
        return super.getPersistedEncoding(object);
    }

    @Override
    protected void persistEncoding(Object object, String string) throws CoreException {
        IFileEditorInput iFileEditorInput;
        IFile iFile;
        if (object instanceof IFileEditorInput && (iFile = (iFileEditorInput = (IFileEditorInput)object).getFile()) != null) {
            iFile.setCharset(string, this.getProgressMonitor());
            StorageDocumentProvider.StorageInfo storageInfo = (StorageDocumentProvider.StorageInfo)this.getElementInfo(object);
            if (storageInfo != null) {
                if (string == null) {
                    storageInfo.fEncoding = iFile.getCharset();
                }
                if (storageInfo instanceof FileInfo) {
                    ((FileInfo)storageInfo).fBOM = this.getBOM(object);
                }
            }
        }
    }

    @Override
    protected IRunnableContext getOperationRunner(IProgressMonitor iProgressMonitor) {
        if (this.fOperationRunner == null) {
            this.fOperationRunner = new WorkspaceOperationRunner();
        }
        this.fOperationRunner.setProgressMonitor(iProgressMonitor);
        return this.fOperationRunner;
    }

    protected ISchedulingRule getResetRule(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return this.fResourceRuleFactory.refreshRule((IResource)iFileEditorInput.getFile());
        }
        return null;
    }

    protected ISchedulingRule getSaveRule(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return this.computeSchedulingRule((IResource)iFileEditorInput.getFile());
        }
        return null;
    }

    protected ISchedulingRule getSynchronizeRule(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return this.fResourceRuleFactory.refreshRule((IResource)iFileEditorInput.getFile());
        }
        return null;
    }

    protected ISchedulingRule getValidateStateRule(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return this.fResourceRuleFactory.validateEditRule(new IResource[]{iFileEditorInput.getFile()});
        }
        return null;
    }

    private byte[] getBOM(Object object) {
        IFile iFile;
        if (object instanceof IFileEditorInput && (iFile = ((IFileEditorInput)object).getFile()) != null) {
            try {
                IContentDescription iContentDescription = iFile.getContentDescription();
                if (iContentDescription != null) {
                    return (byte[])iContentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK);
                }
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    protected void readUTF8BOM(IFile iFile, String string, Object object) throws CoreException {
    }

    protected void cacheEncodingState(Object object) throws CoreException {
        IFileEditorInput iFileEditorInput;
        IFile iFile;
        if (object instanceof IFileEditorInput && (iFile = (iFileEditorInput = (IFileEditorInput)object).getFile()) != null) {
            AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(object);
            if (elementInfo instanceof StorageDocumentProvider.StorageInfo) {
                ((StorageDocumentProvider.StorageInfo)elementInfo).fEncoding = this.getPersistedEncoding(object);
            }
            if (elementInfo instanceof FileInfo) {
                ((FileInfo)elementInfo).fBOM = this.getBOM(object);
            }
        }
    }

    private ISchedulingRule computeSchedulingRule(IResource iResource) {
        if (iResource.exists()) {
            return this.fResourceRuleFactory.modifyRule(iResource);
        }
        IResource iResource2 = iResource;
        while ((iResource2 = (iResource = iResource2).getParent()) != null && !iResource2.exists()) {
        }
        return this.fResourceRuleFactory.createRule(iResource);
    }

    protected class FileInfo
    extends StorageDocumentProvider.StorageInfo {
        public FileSynchronizer fFileSynchronizer;
        public long fModificationStamp;
        private byte[] fBOM;

        public FileInfo(IDocument iDocument, IAnnotationModel iAnnotationModel, FileSynchronizer fileSynchronizer) {
            super(FileDocumentProvider.this, iDocument, iAnnotationModel);
            this.fModificationStamp = -1L;
            this.fFileSynchronizer = fileSynchronizer;
        }
    }

    protected class FileSynchronizer
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        protected IFileEditorInput fFileEditorInput;
        protected boolean fIsInstalled = false;

        public FileSynchronizer(IFileEditorInput iFileEditorInput) {
            this.fFileEditorInput = iFileEditorInput;
        }

        public FileSynchronizer(FileEditorInput fileEditorInput) {
            this.fFileEditorInput = fileEditorInput;
        }

        protected IFile getFile() {
            return this.fFileEditorInput.getFile();
        }

        public void install() {
            this.getFile().getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            this.fIsInstalled = true;
        }

        public void uninstall() {
            this.getFile().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.fIsInstalled = false;
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            try {
                if (iResourceDelta != null && this.fIsInstalled) {
                    iResourceDelta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException coreException) {
                FileDocumentProvider.this.handleCoreException(coreException, "FileDocumentProvider.resourceChanged");
            }
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            if (iResourceDelta == null) {
                return false;
            }
            if ((iResourceDelta = iResourceDelta.findMember(this.getFile().getFullPath())) == null) {
                return false;
            }
            SafeChange safeChange = null;
            switch (iResourceDelta.getKind()) {
                case 4: {
                    boolean bl;
                    FileInfo fileInfo = (FileInfo)FileDocumentProvider.this.getElementInfo(this.fFileEditorInput);
                    if (fileInfo == null || fileInfo.fCanBeSaved) break;
                    boolean bl2 = bl = FileDocumentProvider.this.computeModificationStamp((IResource)this.getFile()) == fileInfo.fModificationStamp;
                    if ((0x100000 & iResourceDelta.getFlags()) != 0 && bl) {
                        safeChange = new SafeChange(FileDocumentProvider.this, this.fFileEditorInput){

                            @Override
                            protected void execute(IFileEditorInput iFileEditorInput) throws Exception {
                                FileDocumentProvider.this.handleElementContentChanged(iFileEditorInput);
                            }
                        };
                    }
                    if (safeChange != null || (0x100 & iResourceDelta.getFlags()) == 0 || bl) break;
                    safeChange = new SafeChange(FileDocumentProvider.this, this.fFileEditorInput){

                        @Override
                        protected void execute(IFileEditorInput iFileEditorInput) throws Exception {
                            FileDocumentProvider.this.handleElementContentChanged(iFileEditorInput);
                        }
                    };
                    break;
                }
                case 2: {
                    if ((0x2000 & iResourceDelta.getFlags()) != 0) {
                        final IPath iPath = iResourceDelta.getMovedToPath();
                        safeChange = new SafeChange(FileDocumentProvider.this, this.fFileEditorInput){

                            @Override
                            protected void execute(IFileEditorInput iFileEditorInput) throws Exception {
                                FileDocumentProvider.this.handleElementMoved(iFileEditorInput, iPath);
                            }
                        };
                        break;
                    }
                    FileInfo fileInfo = (FileInfo)FileDocumentProvider.this.getElementInfo(this.fFileEditorInput);
                    if (fileInfo == null || fileInfo.fCanBeSaved) break;
                    safeChange = new SafeChange(FileDocumentProvider.this, this.fFileEditorInput){

                        @Override
                        protected void execute(IFileEditorInput iFileEditorInput) throws Exception {
                            FileDocumentProvider.this.handleElementDeleted(iFileEditorInput);
                        }
                    };
                }
            }
            if (safeChange != null) {
                this.update(safeChange);
            }
            return false;
        }

        protected void update(Runnable runnable) {
            IWorkbench iWorkbench;
            IWorkbenchWindow[] iWorkbenchWindowArray;
            if (runnable instanceof SafeChange) {
                FileDocumentProvider.this.fireElementStateChanging(this.fFileEditorInput);
            }
            if ((iWorkbenchWindowArray = (iWorkbench = PlatformUI.getWorkbench()).getWorkbenchWindows()) != null && iWorkbenchWindowArray.length > 0) {
                Display display = iWorkbenchWindowArray[0].getShell().getDisplay();
                display.asyncExec(runnable);
            } else {
                runnable.run();
            }
        }
    }

    protected class SafeChange
    implements Runnable {
        private IFileEditorInput fInput;

        public SafeChange(IFileEditorInput iFileEditorInput) {
            this.fInput = iFileEditorInput;
        }

        protected void execute(IFileEditorInput iFileEditorInput) throws Exception {
        }

        @Override
        public void run() {
            if (FileDocumentProvider.this.getElementInfo(this.fInput) == null) {
                FileDocumentProvider.this.fireElementStateChangeFailed(this.fInput);
                return;
            }
            try {
                this.execute(this.fInput);
            }
            catch (Exception exception) {
                FileDocumentProvider.this.fireElementStateChangeFailed(this.fInput);
            }
        }
    }
}

