/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.FileBufferOperationRunner;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;

public class FileBufferOperationHandler
extends AbstractHandler {
    private IFileBufferOperation fFileBufferOperation;
    private IWorkbenchWindow fWindow;
    private IResource[] fResources;
    private IPath fLocation;

    public FileBufferOperationHandler(IFileBufferOperation iFileBufferOperation) {
        this.fFileBufferOperation = iFileBufferOperation;
    }

    public void initialize(IResource[] iResourceArray, IPath iPath) {
        if (iResourceArray != null) {
            this.fResources = new IResource[iResourceArray.length];
            System.arraycopy(iResourceArray, 0, this.fResources, 0, iResourceArray.length);
        } else {
            this.fResources = null;
        }
        this.fLocation = iPath;
    }

    protected final void computeSelectedResources() {
        IWorkbenchPart iWorkbenchPart;
        IWorkbenchWindow iWorkbenchWindow;
        if (this.fResources != null || this.fLocation != null) {
            return;
        }
        ISelection iSelection = this.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            ArrayList<Object> arrayList = new ArrayList<Object>(iStructuredSelection.size());
            for (Object e : iStructuredSelection) {
                IAdaptable iAdaptable;
                Object object;
                if (e instanceof IResource) {
                    arrayList.add(e);
                    continue;
                }
                if (!(e instanceof IAdaptable) || !((object = (iAdaptable = (IAdaptable)e).getAdapter(IResource.class)) instanceof IResource)) continue;
                arrayList.add(object);
            }
            if (!arrayList.isEmpty()) {
                this.fResources = arrayList.toArray(new IResource[arrayList.size()]);
            }
        } else if (iSelection instanceof ITextSelection && (iWorkbenchWindow = this.getWorkbenchWindow()) != null && (iWorkbenchPart = iWorkbenchWindow.getPartService().getActivePart()) instanceof IEditorPart) {
            IEditorPart iEditorPart = (IEditorPart)iWorkbenchPart;
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            Object object = iEditorInput.getAdapter(IResource.class);
            if (object instanceof IResource) {
                this.fResources = new IResource[]{(IResource)object};
            } else {
                object = iEditorInput.getAdapter(ILocationProvider.class);
                if (object instanceof ILocationProvider) {
                    ILocationProvider iLocationProvider = (ILocationProvider)object;
                    this.fLocation = iLocationProvider.getPath(iEditorInput);
                }
            }
        }
    }

    protected final ISelection getSelection() {
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getSelectionService().getSelection();
        }
        return null;
    }

    protected final IWorkbenchWindow getWorkbenchWindow() {
        if (this.fWindow == null) {
            this.fWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        return this.fWindow;
    }

    protected IFile[] collectFiles(IResource[] iResourceArray) {
        HashSet<IResource> hashSet = new HashSet<IResource>();
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if ((1 & iResource.getType()) > 0) {
                hashSet.add(iResource);
            }
            ++n;
        }
        return hashSet.toArray(new IFile[hashSet.size()]);
    }

    protected final void doRun(final IFile[] iFileArray, final IPath iPath, final IFileBufferOperation iFileBufferOperation) {
        Job job = new Job(iFileBufferOperation.getOperationName()){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                Status status;
                try {
                    int n = 100;
                    iProgressMonitor.beginTask(FileBufferOperationHandler.this.fFileBufferOperation.getOperationName(), n);
                    try {
                        IPath[] iPathArray;
                        if (iFileArray != null) {
                            n -= 30;
                            iPathArray = FileBufferOperationHandler.this.generateLocations(iFileArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 30));
                        } else {
                            iPathArray = new IPath[]{iPath};
                        }
                        if (iPathArray != null && iPathArray.length > 0) {
                            FileBufferOperationRunner fileBufferOperationRunner = new FileBufferOperationRunner((IFileBufferManager)FileBuffers.getTextFileBufferManager(), (Object)FileBufferOperationHandler.this.getShell());
                            fileBufferOperationRunner.execute(iPathArray, iFileBufferOperation, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n));
                        }
                        status = Status.OK_STATUS;
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    status = new Status(8, "org.eclipse.ui.editors", 0, "", null);
                }
                catch (CoreException coreException) {
                    status = new Status(4, "org.eclipse.ui.editors", 0, "", (Throwable)coreException);
                }
                return status;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected final Shell getShell() {
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbenchWindow();
        return iWorkbenchWindow == null ? null : iWorkbenchWindow.getShell();
    }

    protected final IPath[] generateLocations(IFile[] iFileArray, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask(TextEditorMessages.FileBufferOperationHandler_collectionFiles_label, iFileArray.length);
        try {
            HashSet<IPath> hashSet = new HashSet<IPath>();
            int n = 0;
            while (n < iFileArray.length) {
                IPath iPath = iFileArray[n].getFullPath();
                if (this.isAcceptableLocation(iPath)) {
                    hashSet.add(iPath);
                }
                iProgressMonitor.worked(1);
                ++n;
            }
            IPath[] iPathArray = hashSet.toArray(new IPath[hashSet.size()]);
            return iPathArray;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected boolean isAcceptableLocation(IPath iPath) {
        return true;
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        this.computeSelectedResources();
        try {
            if (this.fResources != null && this.fResources.length > 0) {
                IFile[] iFileArray = this.collectFiles(this.fResources);
                if (iFileArray != null && iFileArray.length > 0) {
                    this.doRun(iFileArray, null, this.fFileBufferOperation);
                }
            } else if (this.isAcceptableLocation(this.fLocation)) {
                this.doRun(null, this.fLocation, this.fFileBufferOperation);
            }
            return null;
        }
        finally {
            this.fResources = null;
            this.fLocation = null;
        }
    }
}

