/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBufferManager;
import org.eclipse.core.filebuffers.manipulation.FileBufferOperationRunner;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;

public class FileBufferOperationAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private Set fResources;
    private IPath fLocation;
    private IWorkbenchWindow fWindow;
    protected IFileBufferOperation fFileBufferOperation;

    protected FileBufferOperationAction(IFileBufferOperation iFileBufferOperation) {
        Assert.isNotNull((Object)iFileBufferOperation);
        this.fFileBufferOperation = iFileBufferOperation;
    }

    public void dispose() {
        this.fResources = null;
        this.fWindow = null;
        this.fFileBufferOperation = null;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        IEditorInput iEditorInput;
        Object object;
        Object object2;
        Iterator iterator;
        IStructuredSelection iStructuredSelection;
        this.fResources = new HashSet();
        this.fLocation = null;
        if (iSelection instanceof IStructuredSelection) {
            iStructuredSelection = (IStructuredSelection)iSelection;
            iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (object2 instanceof IResource) {
                    this.fResources.add(object2);
                    continue;
                }
                if (!(object2 instanceof IAdaptable) || !((object = (iEditorInput = (IAdaptable)object2).getAdapter(IResource.class)) instanceof IResource)) continue;
                this.fResources.add(object);
            }
        }
        if (iSelection instanceof ITextSelection && (iStructuredSelection = this.getWorkbenchWindow()) != null && (iterator = iStructuredSelection.getPartService().getActivePart()) instanceof IEditorPart) {
            object2 = (IEditorPart)iterator;
            iEditorInput = object2.getEditorInput();
            object = iEditorInput.getAdapter(IResource.class);
            if (object instanceof IResource) {
                this.fResources.add(object);
            } else {
                object = iEditorInput.getAdapter(ILocationProvider.class);
                if (object instanceof ILocationProvider) {
                    ILocationProvider iLocationProvider = (ILocationProvider)object;
                    this.fLocation = iLocationProvider.getPath(iEditorInput);
                }
            }
        }
        iAction.setText(this.getText());
        iAction.setEnabled(!this.fResources.isEmpty() || this.fLocation != null);
    }

    protected final IWorkbenchWindow getWorkbenchWindow() {
        if (this.fWindow == null) {
            this.fWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        return this.fWindow;
    }

    protected final Shell getShell() {
        IWorkbenchWindow iWorkbenchWindow = this.getWorkbenchWindow();
        return iWorkbenchWindow == null ? null : iWorkbenchWindow.getShell();
    }

    public void run(IAction iAction) {
        if (this.fResources != null && !this.fResources.isEmpty()) {
            IFile[] iFileArray = this.collectFiles(this.fResources.toArray(new IResource[this.fResources.size()]));
            if (iFileArray != null && iFileArray.length > 0) {
                this.doRun(iFileArray, null, this.fFileBufferOperation);
            }
        } else if (this.isAcceptableLocation(this.fLocation)) {
            this.doRun(null, this.fLocation, this.fFileBufferOperation);
        }
    }

    protected IFile[] collectFiles(IResource[] iResourceArray) {
        HashSet<IResource> hashSet = new HashSet<IResource>();
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if ((1 & iResource.getType()) > 0) {
                hashSet.add(iResource);
            }
            ++n;
        }
        return hashSet.toArray(new IFile[hashSet.size()]);
    }

    protected final void doRun(final IFile[] iFileArray, final IPath iPath, final IFileBufferOperation iFileBufferOperation) {
        Job job = new Job(iFileBufferOperation.getOperationName()){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                Status status;
                try {
                    int n = 100;
                    iProgressMonitor.beginTask(FileBufferOperationAction.this.fFileBufferOperation.getOperationName(), n);
                    try {
                        IPath[] iPathArray;
                        if (iFileArray != null) {
                            n -= 30;
                            iPathArray = FileBufferOperationAction.this.generateLocations(iFileArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 30));
                        } else {
                            iPathArray = new IPath[]{iPath};
                        }
                        if (iPathArray != null && iPathArray.length > 0) {
                            FileBufferOperationRunner fileBufferOperationRunner = new FileBufferOperationRunner((IFileBufferManager)FileBuffers.getTextFileBufferManager(), (Object)FileBufferOperationAction.this.getShell());
                            fileBufferOperationRunner.execute(iPathArray, iFileBufferOperation, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, n));
                        }
                        status = Status.OK_STATUS;
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    status = new Status(8, "org.eclipse.ui.editors", 0, "", null);
                }
                catch (CoreException coreException) {
                    status = new Status(4, "org.eclipse.ui.editors", 0, "", (Throwable)coreException);
                }
                return status;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected final IPath[] generateLocations(IFile[] iFileArray, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask(TextEditorMessages.FileBufferOperationAction_collectionFiles_label, iFileArray.length);
        try {
            HashSet<IPath> hashSet = new HashSet<IPath>();
            int n = 0;
            while (n < iFileArray.length) {
                IPath iPath = iFileArray[n].getFullPath();
                if (this.isAcceptableLocation(iPath)) {
                    hashSet.add(iPath);
                }
                iProgressMonitor.worked(1);
                ++n;
            }
            IPath[] iPathArray = hashSet.toArray(new IPath[hashSet.size()]);
            return iPathArray;
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected boolean isAcceptableLocation(IPath iPath) {
        return true;
    }
}

