/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EncodingActionGroup
extends ActionGroup {
    private static final String FILE_CONTENT_ENCODING_FORMAT = TextEditorMessages.ResourceInfo_fileContentEncodingFormat;
    private static final String FILE_CONTAINER_ENCODING_FORMAT = TextEditorMessages.ResourceInfo_fileContainerEncodingFormat;
    private static final String[][] ENCODINGS;
    private static final String SYSTEM_ENCODING;
    private List fRetargetActions = new ArrayList();
    private ITextEditor fTextEditor;

    static {
        String[][] stringArrayArray = new String[][]{{"default", "org.eclipse.ui.default_action_context", "org.eclipse.ui.edit.text.encoding.default"}, {"US-ASCII", "org.eclipse.ui.US-ASCII_action_context", "org.eclipse.ui.edit.text.encoding.us-ascii"}, {"ISO-8859-1", "org.eclipse.ui.ISO-8859-1_action_context", "org.eclipse.ui.edit.text.encoding.iso-8859-1"}, {"UTF-8", "org.eclipse.ui.UTF-8_action_context", "org.eclipse.ui.edit.text.encoding.utf-8"}, {"UTF-16BE", "org.eclipse.ui.UTF-16BE_action_context", "org.eclipse.ui.edit.text.encoding.utf-16be"}, {"UTF-16LE", "org.eclipse.ui.UTF-16LE_action_context", "org.eclipse.ui.edit.text.encoding.utf-16le"}, {"UTF-16", "org.eclipse.ui.UTF-16_action_context", "org.eclipse.ui.edit.text.encoding.utf-16"}};
        String string = System.getProperty("file.encoding");
        if (string != null) {
            int n = 0;
            while (n < stringArrayArray.length) {
                if (stringArrayArray[n][0].equals(string)) break;
                ++n;
            }
            if (n != stringArrayArray.length) {
                String[] stringArray = stringArrayArray[n];
                stringArrayArray[n] = stringArrayArray[1];
                stringArrayArray[1] = stringArray;
                string = null;
            }
        }
        SYSTEM_ENCODING = string;
        ENCODINGS = stringArrayArray;
    }

    private static String getDefaultEncodingText(ITextEditor iTextEditor, String string) {
        String string2;
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        if (!(iEditorInput instanceof IFileEditorInput)) {
            return string;
        }
        IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
        String string3 = FILE_CONTENT_ENCODING_FORMAT;
        try {
            string2 = EncodingActionGroup.getEncodingFromContent(iFile);
            if (string2 == null) {
                string3 = FILE_CONTAINER_ENCODING_FORMAT;
                string2 = iFile.getParent().getDefaultCharset();
            }
        }
        catch (CoreException coreException) {
            return string;
        }
        return NLSUtility.format(string3, string2);
    }

    private static String getEncodingFromContent(IFile iFile) throws CoreException {
        IContentDescription iContentDescription = iFile.getContentDescription();
        if (iContentDescription != null) {
            byte[] byArray = (byte[])iContentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK);
            if (byArray == null) {
                return (String)iContentDescription.getProperty(IContentDescription.CHARSET);
            }
            if (byArray == IContentDescription.BOM_UTF_8) {
                return TextEditorMessages.WorkbenchPreference_encoding_BOM_UTF_8;
            }
            if (byArray == IContentDescription.BOM_UTF_16BE) {
                return TextEditorMessages.WorkbenchPreference_encoding_BOM_UTF_16BE;
            }
            if (byArray == IContentDescription.BOM_UTF_16LE) {
                return TextEditorMessages.WorkbenchPreference_encoding_BOM_UTF_16LE;
            }
        }
        return null;
    }

    public EncodingActionGroup() {
        this.fRetargetActions.add(new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ConvertEncoding." + ENCODINGS[0][0] + ".", ENCODINGS[0][0], 8));
        if (SYSTEM_ENCODING != null) {
            this.fRetargetActions.add(new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ConvertEncoding.System.", "System", 8));
        }
        int n = 1;
        while (n < ENCODINGS.length) {
            this.fRetargetActions.add(new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ConvertEncoding." + ENCODINGS[n][0] + ".", ENCODINGS[n][0], 8));
            ++n;
        }
        this.fRetargetActions.add(new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ConvertEncoding.Custom.", "Custom", 1));
    }

    public void fillActionBars(IActionBars iActionBars) {
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        IMenuManager iMenuManager2 = iMenuManager.findMenuUsingPath("edit");
        if (iMenuManager2 != null && this.fRetargetActions.size() > 0) {
            MenuManager menuManager = new MenuManager(TextEditorMessages.Editor_ConvertEncoding_submenu_label);
            menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager iMenuManager) {
                    EncodingActionGroup.this.update();
                }
            });
            Iterator iterator = this.fRetargetActions.iterator();
            menuManager.add((IAction)iterator.next());
            menuManager.add((IContributionItem)new Separator());
            while (iterator.hasNext()) {
                menuManager.add((IAction)iterator.next());
            }
            iMenuManager2.add((IContributionItem)menuManager);
        }
    }

    public void retarget(ITextEditor iTextEditor) {
        this.fTextEditor = iTextEditor;
        for (RetargetTextEditorAction retargetTextEditorAction : this.fRetargetActions) {
            retargetTextEditorAction.setAction(iTextEditor == null ? null : iTextEditor.getAction(retargetTextEditorAction.getId()));
        }
    }

    public EncodingActionGroup(ITextEditor iTextEditor) {
        TextEditorAction textEditorAction;
        this.fTextEditor = iTextEditor;
        if (SYSTEM_ENCODING != null) {
            textEditorAction = new PredefinedEncodingAction(TextEditorMessages.getBundleForConstructedKeys(), SYSTEM_ENCODING, iTextEditor);
            textEditorAction.setHelpContextId("org.eclipse.ui.System_action_context");
            textEditorAction.setActionDefinitionId("org.eclipse.ui.edit.text.encoding.system");
            iTextEditor.setAction("System", (IAction)textEditorAction);
        }
        int n = 0;
        while (n < ENCODINGS.length) {
            textEditorAction = new PredefinedEncodingAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ConvertEncoding." + ENCODINGS[n][0] + ".", ENCODINGS[n][0], iTextEditor);
            textEditorAction.setHelpContextId(ENCODINGS[n][1]);
            textEditorAction.setActionDefinitionId(ENCODINGS[n][2]);
            iTextEditor.setAction(ENCODINGS[n][0], (IAction)textEditorAction);
            ++n;
        }
        textEditorAction = new CustomEncodingAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ConvertEncoding.Custom.", iTextEditor);
        textEditorAction.setHelpContextId("org.eclipse.ui.Custom_action_context");
        textEditorAction.setActionDefinitionId("org.eclipse.ui.edit.text.encoding.custom");
        iTextEditor.setAction("Custom", (IAction)textEditorAction);
    }

    public void update() {
        if (this.fTextEditor == null) {
            return;
        }
        IAction iAction = this.fTextEditor.getAction("System");
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
        int n = 0;
        while (n < ENCODINGS.length) {
            iAction = this.fTextEditor.getAction(ENCODINGS[n][0]);
            if (iAction instanceof IUpdate) {
                ((IUpdate)iAction).update();
            }
            ++n;
        }
        iAction = this.fTextEditor.getAction("Custom");
        if (iAction instanceof IUpdate) {
            ((IUpdate)iAction).update();
        }
    }

    public void dispose() {
        if (this.fTextEditor != null) {
            this.fTextEditor.setAction("System", null);
            int n = 0;
            while (n < ENCODINGS.length) {
                this.fTextEditor.setAction(ENCODINGS[n][0], null);
                ++n;
            }
            this.fTextEditor.setAction("Custom", null);
            this.fTextEditor = null;
        }
    }

    static class CustomEncodingAction
    extends TextEditorAction {
        protected CustomEncodingAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor) {
            super(resourceBundle, string, iTextEditor);
        }

        public void update() {
            ITextEditor iTextEditor = this.getTextEditor();
            this.setEnabled(iTextEditor != null && !iTextEditor.isDirty());
        }

        public void run() {
            InputDialog inputDialog;
            ITextEditor iTextEditor = this.getTextEditor();
            if (iTextEditor == null) {
                return;
            }
            IEncodingSupport iEncodingSupport = (IEncodingSupport)iTextEditor.getAdapter(IEncodingSupport.class);
            if (iEncodingSupport == null) {
                return;
            }
            String string = TextEditorMessages.Editor_ConvertEncoding_Custom_dialog_title;
            String string2 = TextEditorMessages.Editor_ConvertEncoding_Custom_dialog_message;
            IInputValidator iInputValidator = new IInputValidator(){

                public String isValid(String string) {
                    return string == null || string.length() == 0 ? " " : null;
                }
            };
            String string3 = iEncodingSupport.getEncoding();
            if (string3 == null) {
                string3 = iEncodingSupport.getDefaultEncoding();
            }
            if (string3 == null) {
                string3 = "";
            }
            if ((inputDialog = new InputDialog(iTextEditor.getSite().getShell(), string, string2, string3, iInputValidator)).open() == 0) {
                iEncodingSupport.setEncoding(inputDialog.getValue());
            }
        }
    }

    static class PredefinedEncodingAction
    extends TextEditorAction {
        private String fEncoding;
        private String fLabel;
        private boolean fIsDefault;

        public PredefinedEncodingAction(ResourceBundle resourceBundle, String string, String string2, ITextEditor iTextEditor) {
            super(resourceBundle, string, iTextEditor);
            this.fEncoding = string2;
            if (string == null) {
                this.setText(string2);
            }
            this.fLabel = this.getText();
        }

        public PredefinedEncodingAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor) {
            super(resourceBundle, null, iTextEditor);
            this.fEncoding = string;
            this.setText(string);
            this.fLabel = this.getText();
        }

        private IEncodingSupport getEncodingSupport() {
            ITextEditor iTextEditor = this.getTextEditor();
            if (iTextEditor != null) {
                return (IEncodingSupport)iTextEditor.getAdapter(IEncodingSupport.class);
            }
            return null;
        }

        public void run() {
            IEncodingSupport iEncodingSupport = this.getEncodingSupport();
            if (iEncodingSupport != null) {
                iEncodingSupport.setEncoding(this.fIsDefault ? null : this.fEncoding);
            }
        }

        private String getEncoding(ITextEditor iTextEditor) {
            IEncodingSupport iEncodingSupport;
            IEditorInput iEditorInput = iTextEditor.getEditorInput();
            if (iEditorInput instanceof IFileEditorInput) {
                iEncodingSupport = ((IFileEditorInput)iEditorInput).getFile();
                try {
                    String string = iEncodingSupport.getCharset(false);
                    if (string == null) {
                        return null;
                    }
                }
                catch (CoreException coreException) {}
            }
            if ((iEncodingSupport = this.getEncodingSupport()) != null) {
                return iEncodingSupport.getEncoding();
            }
            return null;
        }

        public void update() {
            if (this.fEncoding == null) {
                this.setEnabled(false);
                return;
            }
            ITextEditor iTextEditor = this.getTextEditor();
            if (iTextEditor == null) {
                this.setEnabled(false);
                return;
            }
            this.fIsDefault = "default".equals(this.fEncoding);
            if (this.fIsDefault) {
                this.setText(EncodingActionGroup.getDefaultEncodingText(iTextEditor, this.fLabel));
            } else {
                this.setText(this.fLabel);
            }
            if (iTextEditor.isDirty()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            String string = this.getEncoding(iTextEditor);
            if (this.fIsDefault) {
                this.setChecked(string == null);
            } else {
                this.setChecked(this.fEncoding.equals(string));
            }
        }
    }
}

