/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.editors.text.TextEditorMessages;

class DocumentReader
extends Reader {
    private volatile CharSequence fCharSequence;
    private int fLength;
    private int fOffset = 0;
    private IDocument fDocument;
    private IDocumentListener fDocumentListener = new InternalDocumentListener();

    public DocumentReader(IDocument iDocument) {
        Assert.isNotNull((Object)iDocument);
        this.fDocument = iDocument;
        this.fCharSequence = new DocumentCharSequence(this.fDocument);
        this.fDocument.addDocumentListener(this.fDocumentListener);
        this.fLength = this.fCharSequence.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        DocumentReader documentReader = this;
        synchronized (documentReader) {
            this.fCharSequence = null;
        }
        this.releaseDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDocumentAboutToBeChanged() {
        IDocument iDocument = this.fDocument;
        if (this.fCharSequence == null || iDocument == null) {
            return;
        }
        String string = iDocument.get();
        DocumentReader documentReader = this;
        synchronized (documentReader) {
            if (this.fCharSequence == null) {
                return;
            }
            this.fCharSequence = string;
        }
        this.releaseDocument();
    }

    private synchronized void releaseDocument() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentListener);
        }
        this.fDocument = null;
        this.fDocumentListener = null;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        try {
            while (n3 < n2 && this.fOffset < this.fLength) {
                cArray[n + n3] = this.fCharSequence.charAt(this.fOffset++);
                ++n3;
            }
            if (n3 > 0) {
                return n3;
            }
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(TextEditorMessages.DocumentInputStream_error_streamClosed);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return n3 - 1;
        }
    }

    private static class DocumentCharSequence
    implements CharSequence {
        private IDocument fDocument;

        public DocumentCharSequence(IDocument iDocument) {
            this.fDocument = iDocument;
        }

        @Override
        public int length() {
            return this.fDocument.getLength();
        }

        @Override
        public char charAt(int n) {
            try {
                return this.fDocument.getChar(n);
            }
            catch (BadLocationException badLocationException) {
                throw new IndexOutOfBoundsException(badLocationException.getLocalizedMessage());
            }
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            try {
                return this.fDocument.get(n, n2 - n);
            }
            catch (BadLocationException badLocationException) {
                throw new IndexOutOfBoundsException(badLocationException.getLocalizedMessage());
            }
        }
    }

    private class InternalDocumentListener
    implements IDocumentListener {
        private InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            DocumentReader.this.handleDocumentAboutToBeChanged();
        }

        public void documentChanged(DocumentEvent documentEvent) {
        }
    }
}

