/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class DefaultEncodingSupport
implements IEncodingSupport {
    private IEclipsePreferences.IPreferenceChangeListener fPreferenceChangeListener;
    private StatusTextEditor fTextEditor;

    public void initialize(StatusTextEditor statusTextEditor) {
        this.fTextEditor = statusTextEditor;
        IEclipsePreferences iEclipsePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        this.fPreferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
                if ("encoding".equals(preferenceChangeEvent.getKey())) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            DefaultEncodingSupport.this.setEncoding(null, false);
                        }
                    };
                    if (Display.getCurrent() != null) {
                        runnable.run();
                    } else {
                        Shell shell = DefaultEncodingSupport.this.fTextEditor != null ? DefaultEncodingSupport.this.fTextEditor.getSite().getShell() : DefaultEncodingSupport.getActiveWorkbenchShell();
                        Display display = shell != null ? shell.getDisplay() : Display.getDefault();
                        display.asyncExec(runnable);
                    }
                }
            }
        };
        iEclipsePreferences.addPreferenceChangeListener(this.fPreferenceChangeListener);
    }

    public void dispose() {
        IEclipsePreferences iEclipsePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        iEclipsePreferences.removePreferenceChangeListener(this.fPreferenceChangeListener);
        this.fTextEditor = null;
    }

    public void reset() {
    }

    protected void setEncoding(String string, boolean bl) {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        if (iDocumentProvider instanceof IStorageDocumentProvider) {
            IEditorInput iEditorInput = this.fTextEditor.getEditorInput();
            IStorageDocumentProvider iStorageDocumentProvider = (IStorageDocumentProvider)iDocumentProvider;
            String string2 = iStorageDocumentProvider.getEncoding(iEditorInput);
            if (!this.fTextEditor.isDirty()) {
                boolean bl2;
                String string3 = string == null ? "" : string;
                boolean bl3 = bl2 = (bl || string2 == null) && !string3.equals(string2);
                if (bl2) {
                    iStorageDocumentProvider.setEncoding(iEditorInput, string);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            DefaultEncodingSupport.this.fTextEditor.doRevertToSaved();
                        }
                    };
                    Display display = this.fTextEditor.getSite().getShell().getDisplay();
                    if (display != null && !display.isDisposed()) {
                        BusyIndicator.showWhile((Display)display, (Runnable)runnable);
                    } else {
                        runnable.run();
                    }
                }
            }
        }
    }

    @Override
    public void setEncoding(String string) {
        this.setEncoding(string, true);
    }

    @Override
    public String getEncoding() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        if (iDocumentProvider instanceof IStorageDocumentProvider) {
            IStorageDocumentProvider iStorageDocumentProvider = (IStorageDocumentProvider)iDocumentProvider;
            return iStorageDocumentProvider.getEncoding(this.fTextEditor.getEditorInput());
        }
        return null;
    }

    @Override
    public String getDefaultEncoding() {
        IDocumentProvider iDocumentProvider = this.fTextEditor.getDocumentProvider();
        if (iDocumentProvider instanceof IStorageDocumentProvider) {
            IStorageDocumentProvider iStorageDocumentProvider = (IStorageDocumentProvider)iDocumentProvider;
            return iStorageDocumentProvider.getDefaultEncoding();
        }
        return null;
    }

    public String getStatusHeader(IStatus iStatus) {
        Throwable throwable = iStatus.getException();
        if (throwable instanceof CharConversionException) {
            return TextEditorMessages.Editor_error_unreadable_encoding_header;
        }
        if (throwable instanceof UnsupportedEncodingException) {
            return TextEditorMessages.Editor_error_unsupported_encoding_header;
        }
        return null;
    }

    public String getStatusBanner(IStatus iStatus) {
        Throwable throwable = iStatus.getException();
        if (throwable instanceof CharConversionException) {
            return TextEditorMessages.Editor_error_unreadable_encoding_banner;
        }
        if (throwable instanceof UnsupportedEncodingException) {
            return TextEditorMessages.Editor_error_unsupported_encoding_banner;
        }
        return null;
    }

    public String getStatusMessage(IStatus iStatus) {
        Throwable throwable = iStatus.getException();
        if (throwable instanceof CharConversionException || throwable instanceof UnsupportedEncodingException) {
            String string = this.getEncoding();
            if (string == null) {
                string = this.getDefaultEncoding();
            }
            if (throwable instanceof CharConversionException) {
                if (string != null) {
                    return NLSUtility.format(TextEditorMessages.Editor_error_unreadable_encoding_message_arg, string);
                }
                return TextEditorMessages.Editor_error_unreadable_encoding_message;
            }
            if (throwable instanceof UnsupportedEncodingException) {
                if (string != null) {
                    return NLSUtility.format(TextEditorMessages.Editor_error_unsupported_encoding_message_arg, string);
                }
                return TextEditorMessages.Editor_error_unsupported_encoding_message;
            }
        }
        return null;
    }

    public boolean isEncodingError(IStatus iStatus) {
        if (iStatus == null || iStatus.getSeverity() != 4) {
            return false;
        }
        Throwable throwable = iStatus.getException();
        return throwable instanceof CharConversionException || throwable instanceof UnsupportedEncodingException;
    }

    public void createStatusEncodingChangeControl(Composite composite, IStatus iStatus) {
        final IAction iAction = this.fTextEditor.getAction("ChangeEncoding");
        if (iAction instanceof TextEditorAction) {
            ((TextEditorAction)iAction).update();
        }
        if (iAction == null || !iAction.isEnabled()) {
            return;
        }
        Shell shell = composite.getShell();
        Display display = shell.getDisplay();
        Color color = display.getSystemColor(25);
        Button button = new Button(composite, 0x800008);
        button.setText(iAction.getText());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                iAction.run();
            }
        });
        button.setFocus();
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1808));
        label.setBackground(color);
    }

    private static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }
}

