/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lzma;

import org.tukaani.xz.lz.LZEncoder;
import org.tukaani.xz.lz.Matches;
import org.tukaani.xz.lzma.LZMAEncoder;
import org.tukaani.xz.lzma.Optimum;
import org.tukaani.xz.lzma.State;
import org.tukaani.xz.rangecoder.RangeEncoder;

final class LZMAEncoderNormal
extends LZMAEncoder {
    private static final int OPTS = 4096;
    private static int EXTRA_SIZE_BEFORE = 4096;
    private static int EXTRA_SIZE_AFTER = 4096;
    private final Optimum[] opts = new Optimum[4096];
    private int optCur = 0;
    private int optEnd = 0;
    private Matches matches;

    static int getMemoryUsage(int n, int n2, int n3) {
        return LZEncoder.getMemoryUsage(n, Math.max(n2, EXTRA_SIZE_BEFORE), EXTRA_SIZE_AFTER, 273, n3) + 256;
    }

    LZMAEncoderNormal(RangeEncoder rangeEncoder, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(rangeEncoder, LZEncoder.getInstance(n4, Math.max(n5, EXTRA_SIZE_BEFORE), EXTRA_SIZE_AFTER, n6, 273, n7, n8), n, n2, n3, n4, n6);
        int n9 = 0;
        while (n9 < 4096) {
            this.opts[n9] = new Optimum();
            ++n9;
        }
    }

    @Override
    public void reset() {
        this.optCur = 0;
        this.optEnd = 0;
        super.reset();
    }

    private int convertOpts() {
        this.optEnd = this.optCur;
        int n = this.opts[this.optCur].optPrev;
        do {
            Optimum optimum = this.opts[this.optCur];
            if (optimum.prev1IsLiteral) {
                this.opts[n].optPrev = this.optCur;
                this.opts[n].backPrev = -1;
                this.optCur = n--;
                if (optimum.hasPrev2) {
                    this.opts[n].optPrev = n + 1;
                    this.opts[n].backPrev = optimum.backPrev2;
                    this.optCur = n;
                    n = optimum.optPrev2;
                }
            }
            int n2 = this.opts[n].optPrev;
            this.opts[n].optPrev = this.optCur;
            this.optCur = n;
            n = n2;
        } while (this.optCur > 0);
        this.optCur = this.opts[0].optPrev;
        this.back = this.opts[this.optCur].backPrev;
        return this.optCur;
    }

    @Override
    int getNextSymbol() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.optCur < this.optEnd) {
            int n6 = this.opts[this.optCur].optPrev - this.optCur;
            this.optCur = this.opts[this.optCur].optPrev;
            this.back = this.opts[this.optCur].backPrev;
            return n6;
        }
        assert (this.optCur == this.optEnd);
        this.optCur = 0;
        this.optEnd = 0;
        this.back = -1;
        if (this.readAhead == -1) {
            this.matches = this.getMatches();
        }
        if ((n5 = Math.min(this.lz.getAvail(), 273)) < 2) {
            return 1;
        }
        int[] nArray = new int[4];
        int n7 = 0;
        int n8 = 0;
        while (n8 < 4) {
            nArray[n8] = this.lz.getMatchLen(this.reps[n8], n5);
            if (nArray[n8] < 2) {
                nArray[n8] = 0;
            } else if (nArray[n8] > nArray[n7]) {
                n7 = n8;
            }
            ++n8;
        }
        if (nArray[n7] >= this.niceLen) {
            this.back = n7;
            this.skip(nArray[n7] - 1);
            return nArray[n7];
        }
        n8 = 0;
        int n9 = 0;
        if (this.matches.count > 0) {
            n8 = this.matches.len[this.matches.count - 1];
            n9 = this.matches.dist[this.matches.count - 1];
            if (n8 >= this.niceLen) {
                this.back = n9 + 4;
                this.skip(n8 - 1);
                return n8;
            }
        }
        int n10 = this.lz.getByte(0);
        int n11 = this.lz.getByte(this.reps[0] + 1);
        if (n8 < 2 && n10 != n11 && nArray[n7] < 2) {
            return 1;
        }
        int n12 = this.lz.getPos();
        int n13 = n12 & this.posMask;
        int n14 = this.lz.getByte(1);
        int n15 = this.literalEncoder.getPrice(n10, n11, n14, n12, this.state);
        this.opts[1].set1(n15, 0, -1);
        n14 = this.getAnyMatchPrice(this.state, n13);
        n15 = this.getAnyRepPrice(n14, this.state);
        if (n11 == n10 && (n4 = this.getShortRepPrice(n15, this.state, n13)) < this.opts[1].price) {
            this.opts[1].set1(n4, 0, 0);
        }
        this.optEnd = Math.max(n8, nArray[n7]);
        if (this.optEnd < 2) {
            assert (this.optEnd == 0) : this.optEnd;
            this.back = this.opts[1].backPrev;
            return 1;
        }
        this.updatePrices();
        this.opts[0].state.set(this.state);
        System.arraycopy(this.reps, 0, this.opts[0].reps, 0, 4);
        n4 = this.optEnd;
        while (n4 >= 2) {
            this.opts[n4].reset();
            --n4;
        }
        n4 = 0;
        while (n4 < 4) {
            n3 = nArray[n4];
            if (n3 >= 2) {
                n2 = this.getLongRepPrice(n15, n4, this.state, n13);
                do {
                    if ((n = n2 + this.repLenEncoder.getPrice(n3, n13)) >= this.opts[n3].price) continue;
                    this.opts[n3].set1(n, 0, n4);
                } while (--n3 >= 2);
            }
            ++n4;
        }
        n4 = Math.max(nArray[0] + 1, 2);
        if (n4 <= n8) {
            n3 = this.getNormalMatchPrice(n14, this.state);
            n2 = 0;
            while (n4 > this.matches.len[n2]) {
                ++n2;
            }
            while (true) {
                int n16;
                if ((n16 = this.getMatchAndLenPrice(n3, n = this.matches.dist[n2], n4, n13)) < this.opts[n4].price) {
                    this.opts[n4].set1(n16, 0, n + 4);
                }
                if (n4 == this.matches.len[n2] && ++n2 == this.matches.count) break;
                ++n4;
            }
        }
        n5 = Math.min(this.lz.getAvail(), 4095);
        while (++this.optCur < this.optEnd) {
            this.matches = this.getMatches();
            if (this.matches.count > 0 && this.matches.len[this.matches.count - 1] >= this.niceLen) break;
            n13 = ++n12 & this.posMask;
            this.updateOptStateAndReps();
            n14 = this.opts[this.optCur].price + this.getAnyMatchPrice(this.opts[this.optCur].state, n13);
            n15 = this.getAnyRepPrice(n14, this.opts[this.optCur].state);
            this.calc1BytePrices(n12, n13, --n5, n15);
            if (n5 < 2) continue;
            n4 = this.calcLongRepPrices(n12, n13, n5, n15);
            if (this.matches.count <= 0) continue;
            this.calcNormalMatchPrices(n12, n13, n5, n14, n4);
        }
        return this.convertOpts();
    }

    private void updateOptStateAndReps() {
        int n = this.opts[this.optCur].optPrev;
        assert (n < this.optCur);
        if (this.opts[this.optCur].prev1IsLiteral) {
            --n;
            if (this.opts[this.optCur].hasPrev2) {
                this.opts[this.optCur].state.set(this.opts[this.opts[this.optCur].optPrev2].state);
                if (this.opts[this.optCur].backPrev2 < 4) {
                    this.opts[this.optCur].state.updateLongRep();
                } else {
                    this.opts[this.optCur].state.updateMatch();
                }
            } else {
                this.opts[this.optCur].state.set(this.opts[n].state);
            }
            this.opts[this.optCur].state.updateLiteral();
        } else {
            this.opts[this.optCur].state.set(this.opts[n].state);
        }
        if (n == this.optCur - 1) {
            assert (this.opts[this.optCur].backPrev == 0 || this.opts[this.optCur].backPrev == -1);
            if (this.opts[this.optCur].backPrev == 0) {
                this.opts[this.optCur].state.updateShortRep();
            } else {
                this.opts[this.optCur].state.updateLiteral();
            }
            System.arraycopy(this.opts[n].reps, 0, this.opts[this.optCur].reps, 0, 4);
        } else {
            int n2;
            if (this.opts[this.optCur].prev1IsLiteral && this.opts[this.optCur].hasPrev2) {
                n = this.opts[this.optCur].optPrev2;
                n2 = this.opts[this.optCur].backPrev2;
                this.opts[this.optCur].state.updateLongRep();
            } else {
                n2 = this.opts[this.optCur].backPrev;
                if (n2 < 4) {
                    this.opts[this.optCur].state.updateLongRep();
                } else {
                    this.opts[this.optCur].state.updateMatch();
                }
            }
            if (n2 < 4) {
                this.opts[this.optCur].reps[0] = this.opts[n].reps[n2];
                int n3 = 1;
                while (n3 <= n2) {
                    this.opts[this.optCur].reps[n3] = this.opts[n].reps[n3 - 1];
                    ++n3;
                }
                while (n3 < 4) {
                    this.opts[this.optCur].reps[n3] = this.opts[n].reps[n3];
                    ++n3;
                }
            } else {
                this.opts[this.optCur].reps[0] = n2 - 4;
                System.arraycopy(this.opts[n].reps, 0, this.opts[this.optCur].reps, 1, 3);
            }
        }
    }

    private void calc1BytePrices(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        boolean bl = false;
        int n8 = this.lz.getByte(0);
        int n9 = this.opts[this.optCur].price + this.literalEncoder.getPrice(n8, n7 = this.lz.getByte(this.opts[this.optCur].reps[0] + 1), this.lz.getByte(1), n, this.opts[this.optCur].state);
        if (n9 < this.opts[this.optCur + 1].price) {
            this.opts[this.optCur + 1].set1(n9, this.optCur, -1);
            bl = true;
        }
        if (n7 == n8 && (this.opts[this.optCur + 1].optPrev == this.optCur || this.opts[this.optCur + 1].backPrev != 0) && (n6 = this.getShortRepPrice(n4, this.opts[this.optCur].state, n2)) <= this.opts[this.optCur + 1].price) {
            this.opts[this.optCur + 1].set1(n6, this.optCur, 0);
            bl = true;
        }
        if (!bl && n7 != n8 && n3 > 2 && (n5 = this.lz.getMatchLen(1, this.opts[this.optCur].reps[0], n6 = Math.min(this.niceLen, n3 - 1))) >= 2) {
            State state = new State(this.opts[this.optCur].state);
            state.updateLiteral();
            int n10 = n + 1 & this.posMask;
            int n11 = n9 + this.getLongRepAndLenPrice(0, n5, state, n10);
            int n12 = this.optCur + 1 + n5;
            while (this.optEnd < n12) {
                this.opts[++this.optEnd].reset();
            }
            if (n11 < this.opts[n12].price) {
                this.opts[n12].set2(n11, this.optCur, 0);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int calcLongRepPrices(int var1_1, int var2_2, int var3_3, int var4_4) {
        var5_5 = 2;
        var6_6 = Math.min(var3_3, this.niceLen);
        var7_7 = 0;
        while (var7_7 < 4) {
            block8: {
                var8_8 = this.lz.getMatchLen(this.opts[this.optCur].reps[var7_7], var6_6);
                if (var8_8 >= 2) ** GOTO lbl9
                break block8;
lbl-1000:
                // 1 sources

                {
                    this.opts[++this.optEnd].reset();
lbl9:
                    // 2 sources

                    ** while (this.optEnd < this.optCur + var8_8)
                }
lbl10:
                // 1 sources

                var9_9 = this.getLongRepPrice(var4_4, var7_7, this.opts[this.optCur].state, var2_2);
                var10_10 = var8_8;
                while (var10_10 >= 2) {
                    var11_11 = var9_9 + this.repLenEncoder.getPrice(var10_10, var2_2);
                    if (var11_11 < this.opts[this.optCur + var10_10].price) {
                        this.opts[this.optCur + var10_10].set1(var11_11, this.optCur, var7_7);
                    }
                    --var10_10;
                }
                if (var7_7 == 0) {
                    var5_5 = var8_8 + 1;
                }
                if ((var11_11 = this.lz.getMatchLen(var8_8 + 1, this.opts[this.optCur].reps[var7_7], var10_10 = Math.min(this.niceLen, var3_3 - var8_8 - 1))) >= 2) {
                    var12_12 = var9_9 + this.repLenEncoder.getPrice(var8_8, var2_2);
                    var13_13 = new State(this.opts[this.optCur].state);
                    var13_13.updateLongRep();
                    var14_14 = this.lz.getByte(var8_8, 0);
                    var15_15 = this.lz.getByte(0);
                    var16_16 = this.lz.getByte(var8_8, 1);
                    var12_12 += this.literalEncoder.getPrice(var14_14, var15_15, var16_16, var1_1 + var8_8, var13_13);
                    var13_13.updateLiteral();
                    var17_17 = var1_1 + var8_8 + 1 & this.posMask;
                    var12_12 += this.getLongRepAndLenPrice(0, var11_11, var13_13, var17_17);
                    var18_18 = this.optCur + var8_8 + 1 + var11_11;
                    while (this.optEnd < var18_18) {
                        this.opts[++this.optEnd].reset();
                    }
                    if (var12_12 < this.opts[var18_18].price) {
                        this.opts[var18_18].set3(var12_12, this.optCur, var7_7, var8_8, 0);
                    }
                }
            }
            ++var7_7;
        }
        return var5_5;
    }

    /*
     * Unable to fully structure code
     */
    private void calcNormalMatchPrices(int var1_1, int var2_2, int var3_3, int var4_4, int var5_5) {
        if (this.matches.len[this.matches.count - 1] > var3_3) {
            this.matches.count = 0;
            while (this.matches.len[this.matches.count] < var3_3) {
                ++this.matches.count;
            }
            this.matches.len[this.matches.count++] = var3_3;
        }
        if (this.matches.len[this.matches.count - 1] >= var5_5) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            this.opts[++this.optEnd].reset();
lbl10:
            // 2 sources

            ** while (this.optEnd < this.optCur + this.matches.len[this.matches.count - 1])
        }
lbl11:
        // 1 sources

        var6_6 = this.getNormalMatchPrice(var4_4, this.opts[this.optCur].state);
        var7_7 = 0;
        while (var5_5 > this.matches.len[var7_7]) {
            ++var7_7;
        }
        var8_8 = var5_5;
        while (true) {
            if ((var10_10 = this.getMatchAndLenPrice(var6_6, var9_9 = this.matches.dist[var7_7], var8_8, var2_2)) < this.opts[this.optCur + var8_8].price) {
                this.opts[this.optCur + var8_8].set1(var10_10, this.optCur, var9_9 + 4);
            }
            if (var8_8 == this.matches.len[var7_7]) {
                var11_11 = Math.min(this.niceLen, var3_3 - var8_8 - 1);
                var12_12 = this.lz.getMatchLen(var8_8 + 1, var9_9, var11_11);
                if (var12_12 >= 2) {
                    var13_13 = new State(this.opts[this.optCur].state);
                    var13_13.updateMatch();
                    var14_14 = this.lz.getByte(var8_8, 0);
                    var15_15 = this.lz.getByte(0);
                    var16_16 = this.lz.getByte(var8_8, 1);
                    var17_17 = var10_10 + this.literalEncoder.getPrice(var14_14, var15_15, var16_16, var1_1 + var8_8, var13_13);
                    var13_13.updateLiteral();
                    var18_18 = var1_1 + var8_8 + 1 & this.posMask;
                    var17_17 += this.getLongRepAndLenPrice(0, var12_12, var13_13, var18_18);
                    var19_19 = this.optCur + var8_8 + 1 + var12_12;
                    while (this.optEnd < var19_19) {
                        this.opts[++this.optEnd].reset();
                    }
                    if (var17_17 < this.opts[var19_19].price) {
                        this.opts[var19_19].set3(var17_17, this.optCur, var9_9 + 4, var8_8, 0);
                    }
                }
                if (++var7_7 == this.matches.count) break;
            }
            ++var8_8;
        }
    }
}

