/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lzma;

import org.tukaani.xz.lz.LZEncoder;
import org.tukaani.xz.lz.Matches;
import org.tukaani.xz.lzma.LZMACoder;
import org.tukaani.xz.lzma.LZMAEncoderFast;
import org.tukaani.xz.lzma.LZMAEncoderNormal;
import org.tukaani.xz.lzma.State;
import org.tukaani.xz.rangecoder.RangeEncoder;

public abstract class LZMAEncoder
extends LZMACoder {
    public static final int MODE_FAST = 1;
    public static final int MODE_NORMAL = 2;
    private static final int LZMA2_UNCOMPRESSED_LIMIT = 0x1FFEEF;
    private static final int LZMA2_COMPRESSED_LIMIT = 65510;
    private static final int DIST_PRICE_UPDATE_INTERVAL = 128;
    private static final int ALIGN_PRICE_UPDATE_INTERVAL = 16;
    private final RangeEncoder rc;
    final LZEncoder lz;
    final LiteralEncoder literalEncoder;
    final LengthEncoder matchLenEncoder;
    final LengthEncoder repLenEncoder;
    final int niceLen;
    private int distPriceCount = 0;
    private int alignPriceCount = 0;
    private final int distSlotPricesSize;
    private final int[][] distSlotPrices;
    private final int[][] fullDistPrices = new int[4][128];
    private final int[] alignPrices = new int[16];
    int back = 0;
    int readAhead = -1;
    private int uncompressedSize = 0;

    public static int getMemoryUsage(int n, int n2, int n3, int n4) {
        int n5 = 80;
        switch (n) {
            case 1: {
                n5 += LZMAEncoderFast.getMemoryUsage(n2, n3, n4);
                break;
            }
            case 2: {
                n5 += LZMAEncoderNormal.getMemoryUsage(n2, n3, n4);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n5;
    }

    public static LZMAEncoder getInstance(RangeEncoder rangeEncoder, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        switch (n4) {
            case 1: {
                return new LZMAEncoderFast(rangeEncoder, n, n2, n3, n5, n6, n7, n8, n9);
            }
            case 2: {
                return new LZMAEncoderNormal(rangeEncoder, n, n2, n3, n5, n6, n7, n8, n9);
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getDistSlot(int n) {
        if (n <= 4) {
            return n;
        }
        int n2 = n;
        int n3 = 31;
        if ((n2 & 0xFFFF0000) == 0) {
            n2 <<= 16;
            n3 = 15;
        }
        if ((n2 & 0xFF000000) == 0) {
            n2 <<= 8;
            n3 -= 8;
        }
        if ((n2 & 0xF0000000) == 0) {
            n2 <<= 4;
            n3 -= 4;
        }
        if ((n2 & 0xC0000000) == 0) {
            n2 <<= 2;
            n3 -= 2;
        }
        if ((n2 & Integer.MIN_VALUE) == 0) {
            --n3;
        }
        return (n3 << 1) + (n >>> n3 - 1 & 1);
    }

    abstract int getNextSymbol();

    LZMAEncoder(RangeEncoder rangeEncoder, LZEncoder lZEncoder, int n, int n2, int n3, int n4, int n5) {
        super(n3);
        this.rc = rangeEncoder;
        this.lz = lZEncoder;
        this.niceLen = n5;
        this.literalEncoder = new LiteralEncoder(n, n2);
        this.matchLenEncoder = new LengthEncoder(n3, n5);
        this.repLenEncoder = new LengthEncoder(n3, n5);
        this.distSlotPricesSize = LZMAEncoder.getDistSlot(n4 - 1) + 1;
        this.distSlotPrices = new int[4][this.distSlotPricesSize];
        this.reset();
    }

    public LZEncoder getLZEncoder() {
        return this.lz;
    }

    @Override
    public void reset() {
        super.reset();
        this.literalEncoder.reset();
        this.matchLenEncoder.reset();
        this.repLenEncoder.reset();
        this.distPriceCount = 0;
        this.alignPriceCount = 0;
        this.uncompressedSize += this.readAhead + 1;
        this.readAhead = -1;
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public void resetUncompressedSize() {
        this.uncompressedSize = 0;
    }

    /*
     * Unable to fully structure code
     */
    public boolean encodeForLZMA2() {
        if (this.lz.isStarted() || this.encodeInit()) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.encodeSymbol()) continue;
            return false;
lbl5:
            // 2 sources

            ** while (this.uncompressedSize <= 0x1FFEEF && this.rc.getPendingSize() <= 65510)
        }
lbl6:
        // 1 sources

        return true;
    }

    private boolean encodeInit() {
        assert (this.readAhead == -1);
        if (!this.lz.hasEnoughData(0)) {
            return false;
        }
        this.skip(1);
        this.rc.encodeBit(this.isMatch[this.state.get()], 0, 0);
        this.literalEncoder.encodeInit();
        --this.readAhead;
        assert (this.readAhead == -1);
        ++this.uncompressedSize;
        assert (this.uncompressedSize == 1);
        return true;
    }

    private boolean encodeSymbol() {
        if (!this.lz.hasEnoughData(this.readAhead + 1)) {
            return false;
        }
        int n = this.getNextSymbol();
        assert (this.readAhead >= 0);
        int n2 = this.lz.getPos() - this.readAhead & this.posMask;
        if (this.back == -1) {
            assert (n == 1);
            this.rc.encodeBit(this.isMatch[this.state.get()], n2, 0);
            this.literalEncoder.encode();
        } else {
            this.rc.encodeBit(this.isMatch[this.state.get()], n2, 1);
            if (this.back < 4) {
                assert (this.lz.getMatchLen(-this.readAhead, this.reps[this.back], n) == n);
                this.rc.encodeBit(this.isRep, this.state.get(), 1);
                this.encodeRepMatch(this.back, n, n2);
            } else {
                assert (this.lz.getMatchLen(-this.readAhead, this.back - 4, n) == n);
                this.rc.encodeBit(this.isRep, this.state.get(), 0);
                this.encodeMatch(this.back - 4, n, n2);
            }
        }
        this.readAhead -= n;
        this.uncompressedSize += n;
        return true;
    }

    private void encodeMatch(int n, int n2, int n3) {
        this.state.updateMatch();
        this.matchLenEncoder.encode(n2, n3);
        int n4 = LZMAEncoder.getDistSlot(n);
        this.rc.encodeBitTree(this.distSlots[LZMAEncoder.getDistState(n2)], n4);
        if (n4 >= 4) {
            int n5 = (n4 >>> 1) - 1;
            int n6 = (2 | n4 & 1) << n5;
            int n7 = n - n6;
            if (n4 < 14) {
                this.rc.encodeReverseBitTree(this.distSpecial[n4 - 4], n7);
            } else {
                this.rc.encodeDirectBits(n7 >>> 4, n5 - 4);
                this.rc.encodeReverseBitTree(this.distAlign, n7 & 0xF);
                --this.alignPriceCount;
            }
        }
        this.reps[3] = this.reps[2];
        this.reps[2] = this.reps[1];
        this.reps[1] = this.reps[0];
        this.reps[0] = n;
        --this.distPriceCount;
    }

    private void encodeRepMatch(int n, int n2, int n3) {
        if (n == 0) {
            this.rc.encodeBit(this.isRep0, this.state.get(), 0);
            this.rc.encodeBit(this.isRep0Long[this.state.get()], n3, n2 == 1 ? 0 : 1);
        } else {
            int n4 = this.reps[n];
            this.rc.encodeBit(this.isRep0, this.state.get(), 1);
            if (n == 1) {
                this.rc.encodeBit(this.isRep1, this.state.get(), 0);
            } else {
                this.rc.encodeBit(this.isRep1, this.state.get(), 1);
                this.rc.encodeBit(this.isRep2, this.state.get(), n - 2);
                if (n == 3) {
                    this.reps[3] = this.reps[2];
                }
                this.reps[2] = this.reps[1];
            }
            this.reps[1] = this.reps[0];
            this.reps[0] = n4;
        }
        if (n2 == 1) {
            this.state.updateShortRep();
        } else {
            this.repLenEncoder.encode(n2, n3);
            this.state.updateLongRep();
        }
    }

    Matches getMatches() {
        ++this.readAhead;
        Matches matches = this.lz.getMatches();
        assert (this.lz.verifyMatches(matches));
        return matches;
    }

    void skip(int n) {
        this.readAhead += n;
        this.lz.skip(n);
    }

    int getAnyMatchPrice(State state, int n) {
        return RangeEncoder.getBitPrice(this.isMatch[state.get()][n], 1);
    }

    int getNormalMatchPrice(int n, State state) {
        return n + RangeEncoder.getBitPrice(this.isRep[state.get()], 0);
    }

    int getAnyRepPrice(int n, State state) {
        return n + RangeEncoder.getBitPrice(this.isRep[state.get()], 1);
    }

    int getShortRepPrice(int n, State state, int n2) {
        return n + RangeEncoder.getBitPrice(this.isRep0[state.get()], 0) + RangeEncoder.getBitPrice(this.isRep0Long[state.get()][n2], 0);
    }

    int getLongRepPrice(int n, int n2, State state, int n3) {
        int n4 = n;
        if (n2 == 0) {
            n4 += RangeEncoder.getBitPrice(this.isRep0[state.get()], 0) + RangeEncoder.getBitPrice(this.isRep0Long[state.get()][n3], 1);
        } else {
            n4 += RangeEncoder.getBitPrice(this.isRep0[state.get()], 1);
            n4 = n2 == 1 ? (n4 += RangeEncoder.getBitPrice(this.isRep1[state.get()], 0)) : (n4 += RangeEncoder.getBitPrice(this.isRep1[state.get()], 1) + RangeEncoder.getBitPrice(this.isRep2[state.get()], n2 - 2));
        }
        return n4;
    }

    int getLongRepAndLenPrice(int n, int n2, State state, int n3) {
        int n4 = this.getAnyMatchPrice(state, n3);
        int n5 = this.getAnyRepPrice(n4, state);
        int n6 = this.getLongRepPrice(n5, n, state, n3);
        return n6 + this.repLenEncoder.getPrice(n2, n3);
    }

    int getMatchAndLenPrice(int n, int n2, int n3, int n4) {
        int n5 = n + this.matchLenEncoder.getPrice(n3, n4);
        int n6 = LZMAEncoder.getDistState(n3);
        if (n2 < 128) {
            n5 += this.fullDistPrices[n6][n2];
        } else {
            int n7 = LZMAEncoder.getDistSlot(n2);
            n5 += this.distSlotPrices[n6][n7] + this.alignPrices[n2 & 0xF];
        }
        return n5;
    }

    private void updateDistPrices() {
        int n;
        int n2;
        this.distPriceCount = 128;
        int n3 = 0;
        while (n3 < 4) {
            n2 = 0;
            while (n2 < this.distSlotPricesSize) {
                this.distSlotPrices[n3][n2] = RangeEncoder.getBitTreePrice(this.distSlots[n3], n2);
                ++n2;
            }
            n2 = 14;
            while (n2 < this.distSlotPricesSize) {
                n = (n2 >>> 1) - 1 - 4;
                int[] nArray = this.distSlotPrices[n3];
                int n4 = n2++;
                nArray[n4] = nArray[n4] + RangeEncoder.getDirectBitsPrice(n);
            }
            n2 = 0;
            while (n2 < 4) {
                this.fullDistPrices[n3][n2] = this.distSlotPrices[n3][n2];
                ++n2;
            }
            ++n3;
        }
        n3 = 4;
        n2 = 4;
        while (n2 < 14) {
            n = (n2 >>> 1) - 1;
            int n5 = (2 | n2 & 1) << n;
            int n6 = this.distSpecial[n2 - 4].length;
            int n7 = 0;
            while (n7 < n6) {
                int n8 = n3 - n5;
                int n9 = RangeEncoder.getReverseBitTreePrice(this.distSpecial[n2 - 4], n8);
                int n10 = 0;
                while (n10 < 4) {
                    this.fullDistPrices[n10][n3] = this.distSlotPrices[n10][n2] + n9;
                    ++n10;
                }
                ++n3;
                ++n7;
            }
            ++n2;
        }
        assert (n3 == 128);
    }

    private void updateAlignPrices() {
        this.alignPriceCount = 16;
        int n = 0;
        while (n < 16) {
            this.alignPrices[n] = RangeEncoder.getReverseBitTreePrice(this.distAlign, n);
            ++n;
        }
    }

    void updatePrices() {
        if (this.distPriceCount <= 0) {
            this.updateDistPrices();
        }
        if (this.alignPriceCount <= 0) {
            this.updateAlignPrices();
        }
        this.matchLenEncoder.updatePrices();
        this.repLenEncoder.updatePrices();
    }

    class LengthEncoder
    extends LZMACoder.LengthCoder {
        private static final int PRICE_UPDATE_INTERVAL = 32;
        private final int[] counters;
        private final int[][] prices;

        LengthEncoder(int n, int n2) {
            int n3 = 1 << n;
            this.counters = new int[n3];
            int n4 = Math.max(n2 - 2 + 1, 16);
            this.prices = new int[n3][n4];
        }

        @Override
        void reset() {
            super.reset();
            int n = 0;
            while (n < this.counters.length) {
                this.counters[n] = 0;
                ++n;
            }
        }

        void encode(int n, int n2) {
            if ((n -= 2) < 8) {
                LZMAEncoder.this.rc.encodeBit(this.choice, 0, 0);
                LZMAEncoder.this.rc.encodeBitTree(this.low[n2], n);
            } else {
                LZMAEncoder.this.rc.encodeBit(this.choice, 0, 1);
                if ((n -= 8) < 8) {
                    LZMAEncoder.this.rc.encodeBit(this.choice, 1, 0);
                    LZMAEncoder.this.rc.encodeBitTree(this.mid[n2], n);
                } else {
                    LZMAEncoder.this.rc.encodeBit(this.choice, 1, 1);
                    LZMAEncoder.this.rc.encodeBitTree(this.high, n - 8);
                }
            }
            int n3 = n2;
            this.counters[n3] = this.counters[n3] - 1;
        }

        int getPrice(int n, int n2) {
            return this.prices[n2][n - 2];
        }

        void updatePrices() {
            int n = 0;
            while (n < this.counters.length) {
                if (this.counters[n] <= 0) {
                    this.counters[n] = 32;
                    this.updatePrices(n);
                }
                ++n;
            }
        }

        private void updatePrices(int n) {
            int n2 = RangeEncoder.getBitPrice(this.choice[0], 0);
            int n3 = 0;
            while (n3 < 8) {
                this.prices[n][n3] = n2 + RangeEncoder.getBitTreePrice(this.low[n], n3);
                ++n3;
            }
            n2 = RangeEncoder.getBitPrice(this.choice[0], 1);
            int n4 = RangeEncoder.getBitPrice(this.choice[1], 0);
            while (n3 < 16) {
                this.prices[n][n3] = n2 + n4 + RangeEncoder.getBitTreePrice(this.mid[n], n3 - 8);
                ++n3;
            }
            n4 = RangeEncoder.getBitPrice(this.choice[1], 1);
            while (n3 < this.prices[n].length) {
                this.prices[n][n3] = n2 + n4 + RangeEncoder.getBitTreePrice(this.high, n3 - 8 - 8);
                ++n3;
            }
        }
    }

    class LiteralEncoder
    extends LZMACoder.LiteralCoder {
        LiteralSubencoder[] subencoders;

        LiteralEncoder(int n, int n2) {
            super(n, n2);
            this.subencoders = new LiteralSubencoder[1 << n + n2];
            int n3 = 0;
            while (n3 < this.subencoders.length) {
                this.subencoders[n3] = new LiteralSubencoder();
                ++n3;
            }
        }

        void reset() {
            int n = 0;
            while (n < this.subencoders.length) {
                this.subencoders[n].reset();
                ++n;
            }
        }

        void encodeInit() {
            assert (LZMAEncoder.this.readAhead >= 0);
            this.subencoders[0].encode();
        }

        void encode() {
            assert (LZMAEncoder.this.readAhead >= 0);
            int n = this.getSubcoderIndex(LZMAEncoder.this.lz.getByte(1 + LZMAEncoder.this.readAhead), LZMAEncoder.this.lz.getPos() - LZMAEncoder.this.readAhead);
            this.subencoders[n].encode();
        }

        int getPrice(int n, int n2, int n3, int n4, State state) {
            int n5 = RangeEncoder.getBitPrice(LZMAEncoder.this.isMatch[state.get()][n4 & LZMAEncoder.this.posMask], 0);
            int n6 = this.getSubcoderIndex(n3, n4);
            return n5 += state.isLiteral() ? this.subencoders[n6].getNormalPrice(n) : this.subencoders[n6].getMatchedPrice(n, n2);
        }

        private class LiteralSubencoder
        extends LZMACoder.LiteralCoder.LiteralSubcoder {
            private LiteralSubencoder() {
            }

            void encode() {
                int n = ((LiteralEncoder)LiteralEncoder.this).LZMAEncoder.this.lz.getByte(((LiteralEncoder)LiteralEncoder.this).LZMAEncoder.this.readAhead) | 0x100;
                if (((LiteralEncoder)LiteralEncoder.this).LZMAEncoder.this.state.isLiteral()) {
                    do {
                        int n2 = n >>> 8;
                        int n3 = n >>> 7 & 1;
                        LZMAEncoder.this.rc.encodeBit(this.probs, n2, n3);
                    } while ((n <<= 1) < 65536);
                } else {
                    int n4 = ((LiteralEncoder)LiteralEncoder.this).LZMAEncoder.this.lz.getByte(((LiteralEncoder)LiteralEncoder.this).LZMAEncoder.this.reps[0] + 1 + ((LiteralEncoder)LiteralEncoder.this).LZMAEncoder.this.readAhead);
                    int n5 = 256;
                    do {
                        int n6 = (n4 <<= 1) & n5;
                        int n7 = n5 + n6 + (n >>> 8);
                        int n8 = n >>> 7 & 1;
                        LZMAEncoder.this.rc.encodeBit(this.probs, n7, n8);
                        n5 &= ~(n4 ^ (n <<= 1));
                    } while (n < 65536);
                }
                ((LiteralEncoder)LiteralEncoder.this).LZMAEncoder.this.state.updateLiteral();
            }

            int getNormalPrice(int n) {
                int n2 = 0;
                n |= 0x100;
                do {
                    int n3 = n >>> 8;
                    int n4 = n >>> 7 & 1;
                    n2 += RangeEncoder.getBitPrice(this.probs[n3], n4);
                } while ((n <<= 1) < 65536);
                return n2;
            }

            int getMatchedPrice(int n, int n2) {
                int n3 = 0;
                int n4 = 256;
                n |= 0x100;
                do {
                    int n5 = (n2 <<= 1) & n4;
                    int n6 = n4 + n5 + (n >>> 8);
                    int n7 = n >>> 7 & 1;
                    n3 += RangeEncoder.getBitPrice(this.probs[n6], n7);
                    n4 &= ~(n2 ^ (n <<= 1));
                } while (n < 65536);
                return n3;
            }
        }
    }
}

