/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.index;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.zip.CheckedInputStream;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.check.CRC32;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.check.SHA256;
import org.tukaani.xz.common.DecoderUtil;
import org.tukaani.xz.index.IndexBase;

public class IndexHash
extends IndexBase {
    private Check hash;

    public IndexHash() {
        super(new CorruptedInputException());
        try {
            this.hash = new SHA256();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.hash = new CRC32();
        }
    }

    @Override
    public void add(long l, long l2) throws XZIOException {
        super.add(l, l2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(l);
        byteBuffer.putLong(l2);
        this.hash.update(byteBuffer.array());
    }

    public void validate(InputStream inputStream) throws IOException {
        java.util.zip.CRC32 cRC32 = new java.util.zip.CRC32();
        cRC32.update(0);
        CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, cRC32);
        long l = DecoderUtil.decodeVLI(checkedInputStream);
        if (l != this.recordCount) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        IndexHash indexHash = new IndexHash();
        long l2 = 0L;
        while (l2 < this.recordCount) {
            long l3 = DecoderUtil.decodeVLI(checkedInputStream);
            long l4 = DecoderUtil.decodeVLI(checkedInputStream);
            try {
                indexHash.add(l3, l4);
            }
            catch (XZIOException xZIOException) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            if (indexHash.blocksSum > this.blocksSum || indexHash.uncompressedSum > this.uncompressedSum || indexHash.indexListSize > this.indexListSize) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            ++l2;
        }
        if (indexHash.blocksSum != this.blocksSum || indexHash.uncompressedSum != this.uncompressedSum || indexHash.indexListSize != this.indexListSize || !Arrays.equals(indexHash.hash.finish(), this.hash.finish())) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        DataInputStream dataInputStream = new DataInputStream(checkedInputStream);
        int n = this.getIndexPaddingSize();
        while (n > 0) {
            if (dataInputStream.readUnsignedByte() != 0) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            --n;
        }
        long l5 = cRC32.getValue();
        int n2 = 0;
        while (n2 < 4) {
            if ((l5 >>> n2 * 8 & 0xFFL) != (long)dataInputStream.readUnsignedByte()) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            ++n2;
        }
    }
}

