/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.index;

import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.MemoryLimitException;
import org.tukaani.xz.SeekableInputStream;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.common.DecoderUtil;
import org.tukaani.xz.common.StreamFlags;
import org.tukaani.xz.index.BlockInfo;
import org.tukaani.xz.index.IndexBase;

public class IndexDecoder
extends IndexBase {
    private final BlockInfo info = new BlockInfo();
    private final long streamPadding;
    private final int memoryUsage;
    private final long[] unpadded;
    private final long[] uncompressed;
    private long largestBlockSize = 0L;
    private int pos = -1;

    /*
     * Unable to fully structure code
     */
    public IndexDecoder(SeekableInputStream var1_1, StreamFlags var2_2, long var3_3, int var5_4) throws IOException {
        super(new CorruptedInputException("XZ Index is corrupt"));
        this.info.streamFlags = var2_2;
        this.streamPadding = var3_3;
        var6_5 = var1_1.position() + var2_2.backwardSize - 4L;
        var8_6 = new CRC32();
        var9_7 = new CheckedInputStream(var1_1, var8_6);
        if (var9_7.read() != 0) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        try {
            var10_8 = DecoderUtil.decodeVLI(var9_7);
            if (var10_8 >= var2_2.backwardSize / 2L) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            if (var10_8 > 0x7FFFFFFFL) {
                throw new UnsupportedOptionsException("XZ Index has over 2147483647 Records");
            }
            this.memoryUsage = 1 + (int)((16L * var10_8 + 1023L) / 1024L);
            if (var5_4 >= 0 && this.memoryUsage > var5_4) {
                throw new MemoryLimitException(this.memoryUsage, var5_4);
            }
            this.unpadded = new long[(int)var10_8];
            this.uncompressed = new long[(int)var10_8];
            var12_10 = 0;
            var13_11 = (int)var10_8;
            while (var13_11 > 0) {
                var14_12 = DecoderUtil.decodeVLI(var9_7);
                var16_13 = DecoderUtil.decodeVLI(var9_7);
                if (var1_1.position() > var6_5) {
                    throw new CorruptedInputException("XZ Index is corrupt");
                }
                this.unpadded[var12_10] = this.blocksSum + var14_12;
                this.uncompressed[var12_10] = this.uncompressedSum + var16_13;
                super.add(var14_12, var16_13);
                if (!IndexDecoder.$assertionsDisabled && (long)(++var12_10) != this.recordCount) {
                    throw new AssertionError();
                }
                if (this.largestBlockSize < var16_13) {
                    this.largestBlockSize = var16_13;
                }
                --var13_11;
            }
        }
        catch (EOFException v0) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        var10_9 = this.getIndexPaddingSize();
        if (var1_1.position() + (long)var10_9 == var6_5) ** GOTO lbl47
        throw new CorruptedInputException("XZ Index is corrupt");
lbl-1000:
        // 1 sources

        {
            if (var9_7.read() == 0) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
lbl47:
            // 2 sources

            ** while (var10_9-- > 0)
        }
lbl48:
        // 1 sources

        var11_14 = var8_6.getValue();
        var13_11 = 0;
        while (var13_11 < 4) {
            if ((var11_14 >>> var13_11 * 8 & 255L) != (long)var1_1.read()) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            ++var13_11;
        }
    }

    public BlockInfo locate(long l) {
        assert (l < this.uncompressedSum);
        int n = 0;
        int n2 = this.unpadded.length - 1;
        while (n < n2) {
            int n3 = n + (n2 - n) / 2;
            if (this.uncompressed[n3] <= l) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        this.pos = n;
        return this.getInfo();
    }

    public int getMemoryUsage() {
        return this.memoryUsage;
    }

    public long getStreamAndPaddingSize() {
        return this.getStreamSize() + this.streamPadding;
    }

    public long getUncompressedSize() {
        return this.uncompressedSum;
    }

    public long getLargestBlockSize() {
        return this.largestBlockSize;
    }

    public boolean hasNext() {
        return (long)(this.pos + 1) < this.recordCount;
    }

    public BlockInfo getNext() {
        ++this.pos;
        return this.getInfo();
    }

    private BlockInfo getInfo() {
        if (this.pos == 0) {
            this.info.compressedOffset = 0L;
            this.info.uncompressedOffset = 0L;
        } else {
            this.info.compressedOffset = this.unpadded[this.pos - 1] + 3L & 0xFFFFFFFFFFFFFFFCL;
            this.info.uncompressedOffset = this.uncompressed[this.pos - 1];
        }
        this.info.unpaddedSize = this.unpadded[this.pos] - this.info.compressedOffset;
        this.info.uncompressedSize = this.uncompressed[this.pos] - this.info.uncompressedOffset;
        this.info.compressedOffset += 12L;
        return this.info;
    }
}

