/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.common;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZ;
import org.tukaani.xz.XZFormatException;
import org.tukaani.xz.common.StreamFlags;
import org.tukaani.xz.common.Util;

public class DecoderUtil
extends Util {
    public static boolean isCRC32Valid(byte[] byArray, int n, int n2, int n3) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, n, n2);
        long l = cRC32.getValue();
        int n4 = 0;
        while (n4 < 4) {
            if ((byte)(l >>> n4 * 8) != byArray[n3 + n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static StreamFlags decodeStreamHeader(byte[] byArray) throws IOException {
        int n = 0;
        while (n < XZ.HEADER_MAGIC.length) {
            if (byArray[n] != XZ.HEADER_MAGIC[n]) {
                throw new XZFormatException();
            }
            ++n;
        }
        if (!DecoderUtil.isCRC32Valid(byArray, XZ.HEADER_MAGIC.length, 2, XZ.HEADER_MAGIC.length + 2)) {
            throw new CorruptedInputException("XZ Stream Header is corrupt");
        }
        try {
            return DecoderUtil.decodeStreamFlags(byArray, XZ.HEADER_MAGIC.length);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Stream Header");
        }
    }

    public static StreamFlags decodeStreamFooter(byte[] byArray) throws IOException {
        StreamFlags streamFlags;
        if (byArray[10] != XZ.FOOTER_MAGIC[0] || byArray[11] != XZ.FOOTER_MAGIC[1]) {
            throw new CorruptedInputException("XZ Stream Footer is corrupt");
        }
        if (!DecoderUtil.isCRC32Valid(byArray, 4, 6, 0)) {
            throw new CorruptedInputException("XZ Stream Footer is corrupt");
        }
        try {
            streamFlags = DecoderUtil.decodeStreamFlags(byArray, 8);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Stream Footer");
        }
        streamFlags.backwardSize = 0L;
        int n = 0;
        while (n < 4) {
            streamFlags.backwardSize |= (long)((byArray[n + 4] & 0xFF) << n * 8);
            ++n;
        }
        streamFlags.backwardSize = (streamFlags.backwardSize + 1L) * 4L;
        return streamFlags;
    }

    private static StreamFlags decodeStreamFlags(byte[] byArray, int n) throws UnsupportedOptionsException {
        if (byArray[n] != 0 || (byArray[n + 1] & 0xFF) >= 16) {
            throw new UnsupportedOptionsException();
        }
        StreamFlags streamFlags = new StreamFlags();
        streamFlags.checkType = byArray[n + 1];
        return streamFlags;
    }

    public static boolean areStreamFlagsEqual(StreamFlags streamFlags, StreamFlags streamFlags2) {
        return streamFlags.checkType == streamFlags2.checkType;
    }

    public static long decodeVLI(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        long l = n & 0x7F;
        int n2 = 0;
        while ((n & 0x80) != 0) {
            if (++n2 >= 9) {
                throw new CorruptedInputException();
            }
            n = inputStream.read();
            if (n == -1) {
                throw new EOFException();
            }
            if (n == 0) {
                throw new CorruptedInputException();
            }
            l |= (long)(n & 0x7F) << n2 * 7;
        }
        return l;
    }
}

