/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.check;

import org.tukaani.xz.check.Check;

public class CRC64
extends Check {
    private static final long poly = -3932672073523589310L;
    private static final long[] crcTable = new long[256];
    private long crc = -1L;

    static {
        int n = 0;
        while (n < crcTable.length) {
            long l = n;
            int n2 = 0;
            while (n2 < 8) {
                l = (l & 1L) == 1L ? l >>> 1 ^ 0xC96C5795D7870F42L : (l >>>= 1);
                ++n2;
            }
            CRC64.crcTable[n] = l;
            ++n;
        }
    }

    public CRC64() {
        this.size = 8;
        this.name = "CRC64";
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            this.crc = crcTable[(byArray[n++] ^ (int)this.crc) & 0xFF] ^ this.crc >>> 8;
        }
    }

    @Override
    public byte[] finish() {
        long l = this.crc ^ 0xFFFFFFFFFFFFFFFFL;
        this.crc = -1L;
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(l >> n * 8);
            ++n;
        }
        return byArray;
    }
}

