/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.DataOutputStream;
import java.io.IOException;
import org.tukaani.xz.FinishableOutputStream;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.lz.LZEncoder;
import org.tukaani.xz.lzma.LZMAEncoder;
import org.tukaani.xz.rangecoder.RangeEncoder;

class LZMA2OutputStream
extends FinishableOutputStream {
    static final int COMPRESSED_SIZE_MAX = 65536;
    private FinishableOutputStream out;
    private final DataOutputStream outData;
    private final LZEncoder lz;
    private final RangeEncoder rc;
    private final LZMAEncoder lzma;
    private int props;
    private boolean dictResetNeeded = true;
    private boolean stateResetNeeded = true;
    private boolean propsNeeded = true;
    private int pendingSize = 0;
    private boolean finished = false;
    private IOException exception = null;

    private static int getExtraSizeBefore(int n) {
        return 65536 > n ? 65536 - n : 0;
    }

    static int getMemoryUsage(LZMA2Options lZMA2Options) {
        int n = lZMA2Options.getDictSize();
        int n2 = LZMA2OutputStream.getExtraSizeBefore(n);
        return 70 + LZMAEncoder.getMemoryUsage(lZMA2Options.getMode(), n, n2, lZMA2Options.getMatchFinder());
    }

    LZMA2OutputStream(FinishableOutputStream finishableOutputStream, LZMA2Options lZMA2Options) {
        if (finishableOutputStream == null) {
            throw new NullPointerException();
        }
        this.out = finishableOutputStream;
        this.outData = new DataOutputStream(finishableOutputStream);
        this.rc = new RangeEncoder(65536);
        int n = lZMA2Options.getDictSize();
        int n2 = LZMA2OutputStream.getExtraSizeBefore(n);
        this.lzma = LZMAEncoder.getInstance(this.rc, lZMA2Options.getLc(), lZMA2Options.getLp(), lZMA2Options.getPb(), lZMA2Options.getMode(), n, n2, lZMA2Options.getNiceLen(), lZMA2Options.getMatchFinder(), lZMA2Options.getDepthLimit());
        this.lz = this.lzma.getLZEncoder();
        this.lz.setPresetDict(n, lZMA2Options.getPresetDict());
        this.props = (lZMA2Options.getPb() * 5 + lZMA2Options.getLp()) * 9 + lZMA2Options.getLc();
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void write(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeChunk() throws IOException {
        int n;
        int n2 = this.rc.finish();
        if (n2 + 2 < (n = this.lzma.getUncompressedSize())) {
            this.writeLZMA(n, n2);
        } else {
            this.lzma.reset();
            n = this.lzma.getUncompressedSize();
            this.writeUncompressed(n);
        }
        this.pendingSize -= n;
        this.lzma.resetUncompressedSize();
        this.rc.reset();
    }

    private void writeLZMA(int n, int n2) throws IOException {
        int n3 = this.propsNeeded ? (this.dictResetNeeded ? 224 : 192) : (this.stateResetNeeded ? 160 : 128);
        this.outData.writeByte(n3 |= n - 1 >>> 16);
        this.outData.writeShort(n - 1);
        this.outData.writeShort(n2 - 1);
        if (this.propsNeeded) {
            this.outData.writeByte(this.props);
        }
        this.rc.write(this.out);
        this.propsNeeded = false;
        this.stateResetNeeded = false;
        this.dictResetNeeded = false;
    }

    private void writeUncompressed(int n) throws IOException {
        while (n > 0) {
            int n2 = Math.min(n, 65536);
            this.outData.writeByte(this.dictResetNeeded ? 1 : 2);
            this.outData.writeShort(n2 - 1);
            this.lz.copyUncompressed(this.out, n, n2);
            n -= n2;
            this.dictResetNeeded = false;
        }
        this.stateResetNeeded = true;
    }

    private void writeEndMarker() throws IOException {
        assert (!this.finished);
        if (this.exception != null) {
            throw this.exception;
        }
        this.lz.setFinishing();
        try {
            while (this.pendingSize > 0) {
                this.lzma.encodeForLZMA2();
                this.writeChunk();
            }
            this.out.write(0);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
        this.finished = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            this.lz.setFlushing();
            while (this.pendingSize > 0) {
                this.lzma.encodeForLZMA2();
                this.writeChunk();
            }
            this.out.flush();
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    @Override
    public void finish() throws IOException {
        if (!this.finished) {
            this.writeEndMarker();
            try {
                this.out.finish();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
            this.finished = true;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            block7: {
                if (!this.finished) {
                    try {
                        this.writeEndMarker();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block7;
                    this.exception = iOException;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

