/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.tukaani.xz.BCJDecoder;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.CountingInputStream;
import org.tukaani.xz.DeltaDecoder;
import org.tukaani.xz.FilterCoder;
import org.tukaani.xz.FilterDecoder;
import org.tukaani.xz.IndexIndicatorException;
import org.tukaani.xz.LZMA2Decoder;
import org.tukaani.xz.MemoryLimitException;
import org.tukaani.xz.RawCoder;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.common.DecoderUtil;

class BlockInputStream
extends InputStream {
    private final InputStream in;
    private final DataInputStream inData;
    private final CountingInputStream inCounted;
    private InputStream filterChain;
    private final Check check;
    private long uncompressedSizeInHeader = -1L;
    private long compressedSizeInHeader = -1L;
    private long compressedSizeLimit;
    private final int headerSize;
    private long uncompressedSize = 0L;
    private boolean endReached = false;

    public BlockInputStream(InputStream inputStream, Check check, int n, long l, long l2) throws IOException, IndexIndicatorException {
        long l3;
        int n2;
        this.in = inputStream;
        this.check = check;
        this.inData = new DataInputStream(inputStream);
        byte[] byArray = new byte[1024];
        this.inData.readFully(byArray, 0, 1);
        if (byArray[0] == 0) {
            throw new IndexIndicatorException();
        }
        this.headerSize = 4 * ((byArray[0] & 0xFF) + 1);
        this.inData.readFully(byArray, 1, this.headerSize - 1);
        if (!DecoderUtil.isCRC32Valid(byArray, 0, this.headerSize - 4, this.headerSize - 4)) {
            throw new CorruptedInputException("XZ Block Header is corrupt");
        }
        if ((byArray[1] & 0x3C) != 0) {
            throw new UnsupportedOptionsException("Unsupported options in XZ Block Header");
        }
        int n3 = (byArray[1] & 3) + 1;
        long[] lArray = new long[n3];
        byte[][] byArrayArray = new byte[n3][];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 2, this.headerSize - 6);
        try {
            this.compressedSizeLimit = 0x7FFFFFFFFFFFFFFCL - (long)this.headerSize - (long)check.getSize();
            if ((byArray[1] & 0x40) != 0) {
                this.compressedSizeInHeader = DecoderUtil.decodeVLI(byteArrayInputStream);
                if (this.compressedSizeInHeader == 0L || this.compressedSizeInHeader > this.compressedSizeLimit) {
                    throw new CorruptedInputException();
                }
                this.compressedSizeLimit = this.compressedSizeInHeader;
            }
            if ((byArray[1] & 0x80) != 0) {
                this.uncompressedSizeInHeader = DecoderUtil.decodeVLI(byteArrayInputStream);
            }
            n2 = 0;
            while (n2 < n3) {
                lArray[n2] = DecoderUtil.decodeVLI(byteArrayInputStream);
                l3 = DecoderUtil.decodeVLI(byteArrayInputStream);
                if (l3 > (long)byteArrayInputStream.available()) {
                    throw new CorruptedInputException();
                }
                byArrayArray[n2] = new byte[(int)l3];
                byteArrayInputStream.read(byArrayArray[n2]);
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new CorruptedInputException("XZ Block Header is corrupt");
        }
        n2 = byteArrayInputStream.available();
        while (n2 > 0) {
            if (byteArrayInputStream.read() != 0) {
                throw new UnsupportedOptionsException("Unsupported options in XZ Block Header");
            }
            --n2;
        }
        if (l != -1L) {
            n2 = this.headerSize + check.getSize();
            if ((long)n2 >= l) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            l3 = l - (long)n2;
            if (l3 > this.compressedSizeLimit || this.compressedSizeInHeader != -1L && this.compressedSizeInHeader != l3) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            if (this.uncompressedSizeInHeader != -1L && this.uncompressedSizeInHeader != l2) {
                throw new CorruptedInputException("XZ Index does not match a Block Header");
            }
            this.compressedSizeLimit = l3;
            this.compressedSizeInHeader = l3;
            this.uncompressedSizeInHeader = l2;
        }
        FilterCoder[] filterCoderArray = new FilterDecoder[lArray.length];
        int n4 = 0;
        while (n4 < filterCoderArray.length) {
            if (lArray[n4] == 33L) {
                filterCoderArray[n4] = new LZMA2Decoder(byArrayArray[n4]);
            } else if (lArray[n4] == 3L) {
                filterCoderArray[n4] = new DeltaDecoder(byArrayArray[n4]);
            } else if (BCJDecoder.isBCJFilterID(lArray[n4])) {
                filterCoderArray[n4] = new BCJDecoder(lArray[n4], byArrayArray[n4]);
            } else {
                throw new UnsupportedOptionsException("Unknown Filter ID " + lArray[n4]);
            }
            ++n4;
        }
        RawCoder.validate(filterCoderArray);
        if (n >= 0) {
            n4 = 0;
            int n5 = 0;
            while (n5 < filterCoderArray.length) {
                n4 += filterCoderArray[n5].getMemoryUsage();
                ++n5;
            }
            if (n4 > n) {
                throw new MemoryLimitException(n4, n);
            }
        }
        this.inCounted = new CountingInputStream(inputStream);
        this.filterChain = this.inCounted;
        n4 = filterCoderArray.length - 1;
        while (n4 >= 0) {
            this.filterChain = filterCoderArray[n4].getInputStream(this.filterChain);
            --n4;
        }
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        return this.read(byArray, 0, 1) == -1 ? -1 : byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.endReached) {
            return -1;
        }
        int n3 = this.filterChain.read(byArray, n, n2);
        if (n3 > 0) {
            this.check.update(byArray, n, n3);
            this.uncompressedSize += (long)n3;
            long l = this.inCounted.getSize();
            if (l < 0L || l > this.compressedSizeLimit || this.uncompressedSize < 0L || this.uncompressedSizeInHeader != -1L && this.uncompressedSize > this.uncompressedSizeInHeader) {
                throw new CorruptedInputException();
            }
            if (n3 < n2 || this.uncompressedSize == this.uncompressedSizeInHeader) {
                if (this.filterChain.read() != -1) {
                    throw new CorruptedInputException();
                }
                this.validate();
                this.endReached = true;
            }
        } else if (n3 == -1) {
            this.validate();
            this.endReached = true;
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    private void validate() throws IOException {
        var1_1 = this.inCounted.getSize();
        if ((this.compressedSizeInHeader == -1L || this.compressedSizeInHeader == var1_1) && (this.uncompressedSizeInHeader == -1L || this.uncompressedSizeInHeader == this.uncompressedSize)) ** GOTO lbl6
        throw new CorruptedInputException();
lbl-1000:
        // 1 sources

        {
            if (this.inData.readUnsignedByte() == 0) continue;
            throw new CorruptedInputException();
lbl6:
            // 2 sources

            ** while ((var1_1++ & 3L) != 0L)
        }
lbl7:
        // 1 sources

        var3_2 = new byte[this.check.getSize()];
        this.inData.readFully(var3_2);
        if (!Arrays.equals(this.check.finish(), var3_2)) {
            throw new CorruptedInputException("Integrity check (" + this.check.getName() + ") does not match");
        }
    }

    @Override
    public int available() throws IOException {
        return this.filterChain.available();
    }

    public long getUnpaddedSize() {
        return (long)this.headerSize + this.inCounted.getSize() + (long)this.check.getSize();
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }
}

