/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import org.tukaani.xz.BCJCoder;
import org.tukaani.xz.BCJOptions;
import org.tukaani.xz.FilterEncoder;
import org.tukaani.xz.FinishableOutputStream;

class BCJEncoder
extends BCJCoder
implements FilterEncoder {
    private final BCJOptions options;
    private final long filterID;
    private final byte[] props;

    BCJEncoder(BCJOptions bCJOptions, long l) {
        assert (BCJEncoder.isBCJFilterID(l));
        int n = bCJOptions.getStartOffset();
        if (n == 0) {
            this.props = new byte[0];
        } else {
            this.props = new byte[4];
            int n2 = 0;
            while (n2 < 4) {
                this.props[n2] = (byte)(n >>> n2 * 8);
                ++n2;
            }
        }
        this.filterID = l;
        this.options = (BCJOptions)bCJOptions.clone();
    }

    @Override
    public long getFilterID() {
        return this.filterID;
    }

    @Override
    public byte[] getFilterProps() {
        return this.props;
    }

    @Override
    public boolean supportsFlushing() {
        return false;
    }

    @Override
    public FinishableOutputStream getOutputStream(FinishableOutputStream finishableOutputStream) {
        return this.options.getOutputStream(finishableOutputStream);
    }
}

