/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.mimetype.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

public class CharSetMap {
    public static final String CHARSET_RESOURCE = "charset.properties";
    private static Properties commonMapper = new Properties();
    public static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final int MAP_CACHE = 0;
    private static final int MAP_COM = 5;
    private static final int MAP_HOME = 2;
    private static final int MAP_JAR = 4;
    private static final int MAP_PROG = 1;
    private static final int MAP_SYS = 3;
    private Properties[] mappers = new Properties[6];

    static {
        commonMapper.put("ar", "ISO-8859-6");
        commonMapper.put("be", "ISO-8859-5");
        commonMapper.put("bg", "ISO-8859-5");
        commonMapper.put("ca", DEFAULT_CHARSET);
        commonMapper.put("cs", "ISO-8859-2");
        commonMapper.put("da", DEFAULT_CHARSET);
        commonMapper.put("de", DEFAULT_CHARSET);
        commonMapper.put("el", "ISO-8859-7");
        commonMapper.put("en", DEFAULT_CHARSET);
        commonMapper.put("es", DEFAULT_CHARSET);
        commonMapper.put("et", DEFAULT_CHARSET);
        commonMapper.put("fi", DEFAULT_CHARSET);
        commonMapper.put("fr", DEFAULT_CHARSET);
        commonMapper.put("hr", "ISO-8859-2");
        commonMapper.put("hu", "ISO-8859-2");
        commonMapper.put("is", DEFAULT_CHARSET);
        commonMapper.put("it", DEFAULT_CHARSET);
        commonMapper.put("iw", "ISO-8859-8");
        commonMapper.put("ja", "Shift_JIS");
        commonMapper.put("ko", "EUC-KR");
        commonMapper.put("lt", "ISO-8859-2");
        commonMapper.put("lv", "ISO-8859-2");
        commonMapper.put("mk", "ISO-8859-5");
        commonMapper.put("nl", DEFAULT_CHARSET);
        commonMapper.put("no", DEFAULT_CHARSET);
        commonMapper.put("pl", "ISO-8859-2");
        commonMapper.put("pt", DEFAULT_CHARSET);
        commonMapper.put("ro", "ISO-8859-2");
        commonMapper.put("ru", "ISO-8859-5");
        commonMapper.put("sh", "ISO-8859-5");
        commonMapper.put("sk", "ISO-8859-2");
        commonMapper.put("sl", "ISO-8859-2");
        commonMapper.put("sq", "ISO-8859-2");
        commonMapper.put("sr", "ISO-8859-5");
        commonMapper.put("sv", DEFAULT_CHARSET);
        commonMapper.put("tr", "ISO-8859-9");
        commonMapper.put("uk", "ISO-8859-5");
        commonMapper.put("zh", "GB2312");
        commonMapper.put("zh_TW", "Big5");
    }

    protected static Properties loadFile(File file) throws IOException {
        return CharSetMap.loadStream(new FileInputStream(file));
    }

    protected static Properties loadPath(String string) throws IOException {
        return CharSetMap.loadFile(new File(string));
    }

    protected static Properties loadResource(String string) {
        InputStream inputStream = CharSetMap.class.getResourceAsStream(string);
        if (inputStream != null) {
            try {
                return CharSetMap.loadStream(inputStream);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    protected static Properties loadStream(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return new Properties(properties);
    }

    public CharSetMap() {
        String string;
        try {
            string = System.getProperty("user.home");
            if (string != null) {
                string = String.valueOf(string) + File.separator + CHARSET_RESOURCE;
                this.mappers[2] = CharSetMap.loadPath(string);
            }
        }
        catch (Exception exception) {}
        try {
            string = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + CHARSET_RESOURCE;
            this.mappers[3] = CharSetMap.loadPath(string);
        }
        catch (Exception exception) {}
        this.mappers[4] = CharSetMap.loadResource("/META-INF/charset.properties");
        this.mappers[5] = commonMapper;
        this.mappers[0] = new Properties();
    }

    public CharSetMap(File file) throws IOException {
        this();
        this.mappers[1] = CharSetMap.loadFile(file);
    }

    public CharSetMap(InputStream inputStream) throws IOException {
        this();
        this.mappers[1] = CharSetMap.loadStream(inputStream);
    }

    public CharSetMap(Properties properties) {
        this();
        this.mappers[1] = new Properties(properties);
    }

    public CharSetMap(String string) throws IOException {
        this();
        this.mappers[1] = CharSetMap.loadPath(string);
    }

    public String getCharSet(Locale locale) {
        String string = locale.toString();
        if (string.length() == 0 && (string = "__" + locale.getVariant()).length() == 2) {
            return this.getDefaultCharSet();
        }
        String string2 = this.searchCharSet(string);
        if (string2.length() == 0) {
            String[] stringArray = new String[3];
            stringArray[2] = locale.getVariant();
            stringArray[1] = locale.getCountry();
            stringArray[0] = locale.getLanguage();
            string2 = this.searchCharSet(stringArray);
            if (string2.length() == 0) {
                string2 = this.getDefaultCharSet();
            }
            this.mappers[0].put(string, string2);
        }
        return string2;
    }

    public String getCharSet(Locale locale, String string) {
        if (string != null && string.length() > 0) {
            String string2 = locale.toString();
            string2 = string2.length() == 0 ? ((string2 = "__" + locale.getVariant()).length() > 2 ? String.valueOf(string2) + '_' + string : String.valueOf(string2) + string) : (locale.getCountry().length() == 0 ? String.valueOf(string2) + "__" + string : String.valueOf(string2) + '_' + string);
            String string3 = this.searchCharSet(string2);
            if (string3.length() == 0) {
                String[] stringArray = new String[4];
                stringArray[3] = string;
                stringArray[2] = locale.getVariant();
                stringArray[1] = locale.getCountry();
                stringArray[0] = locale.getLanguage();
                string3 = this.searchCharSet(stringArray);
                if (string3.length() == 0) {
                    string3 = this.getDefaultCharSet();
                }
                this.mappers[0].put(string2, string3);
            }
            return string3;
        }
        return this.getCharSet(locale);
    }

    public String getCharSet(String string) {
        String string2 = this.searchCharSet(string);
        return string2.length() > 0 ? string2 : this.getDefaultCharSet();
    }

    public String getCharSet(String string, String string2) {
        String string3 = this.searchCharSet(string);
        return string3.length() > 0 ? string3 : string2;
    }

    public String getDefaultCharSet() {
        return DEFAULT_CHARSET;
    }

    private String searchCharSet(String string) {
        if (string != null && string.length() > 0) {
            int n = 0;
            while (n < this.mappers.length) {
                String string2;
                Properties properties = this.mappers[n];
                if (properties != null && (string2 = (String)properties.get(string)) != null) {
                    if (n > 0) {
                        this.mappers[0].put(string, string2);
                    }
                    return string2;
                }
                ++n;
            }
            this.mappers[0].put(string, "");
        }
        return "";
    }

    private String searchCharSet(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        while (n > 0) {
            String string = this.searchCharSet(stringArray, stringBuffer, n);
            if (string.length() > 0) {
                return string;
            }
            stringBuffer.setLength(0);
            --n;
        }
        return "";
    }

    private String searchCharSet(String[] stringArray, StringBuffer stringBuffer, int n) {
        if (--n >= 0 && stringArray[n] != null && stringArray[n].length() > 0) {
            stringBuffer.insert(0, stringArray[n]);
            int n2 = stringBuffer.length();
            int n3 = n;
            while (n3 > 0) {
                String string;
                if (n3 == n || n3 <= 1) {
                    stringBuffer.insert(0, '_');
                    ++n2;
                }
                if ((string = this.searchCharSet(stringArray, stringBuffer, n3)).length() > 0) {
                    return string;
                }
                stringBuffer.delete(0, stringBuffer.length() - n2);
                --n3;
            }
            return this.searchCharSet(stringBuffer.toString());
        }
        return "";
    }

    public synchronized void setCharSet(String string, String string2) {
        Properties properties = this.mappers[1];
        properties = properties != null ? (Properties)properties.clone() : new Properties();
        properties.put(string, string2);
        this.mappers[1] = properties;
        this.mappers[0].clear();
    }

    protected synchronized void setCommonCharSet(String string, String string2) {
        Properties properties = (Properties)this.mappers[5].clone();
        properties.put(string, string2);
        this.mappers[5] = properties;
        this.mappers[0].clear();
    }
}

