/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolUtils;
import org.apache.commons.pool.PoolableObjectFactory;

public class StackObjectPool<T>
extends BaseObjectPool<T>
implements ObjectPool<T> {
    protected static final int DEFAULT_MAX_SLEEPING = 8;
    protected static final int DEFAULT_INIT_SLEEPING_CAPACITY = 4;
    @Deprecated
    protected Stack<T> _pool = null;
    @Deprecated
    protected PoolableObjectFactory<T> _factory = null;
    @Deprecated
    protected int _maxSleeping = 8;
    @Deprecated
    protected int _numActive = 0;

    @Deprecated
    public StackObjectPool() {
        this(null, 8, 4);
    }

    @Deprecated
    public StackObjectPool(int n) {
        this(null, n, 4);
    }

    @Deprecated
    public StackObjectPool(int n, int n2) {
        this(null, n, n2);
    }

    public StackObjectPool(PoolableObjectFactory<T> poolableObjectFactory) {
        this(poolableObjectFactory, 8, 4);
    }

    public StackObjectPool(PoolableObjectFactory<T> poolableObjectFactory, int n) {
        this(poolableObjectFactory, n, 4);
    }

    public StackObjectPool(PoolableObjectFactory<T> poolableObjectFactory, int n, int n2) {
        this._factory = poolableObjectFactory;
        this._maxSleeping = n < 0 ? 8 : n;
        int n3 = n2 < 1 ? 4 : n2;
        this._pool = new Stack();
        this._pool.ensureCapacity(n3 > this._maxSleeping ? this._maxSleeping : n3);
    }

    @Override
    public synchronized T borrowObject() throws Exception {
        this.assertOpen();
        Object var1_1 = null;
        boolean bl = false;
        while (var1_1 == null) {
            if (!this._pool.empty()) {
                var1_1 = this._pool.pop();
            } else {
                if (this._factory == null) {
                    throw new NoSuchElementException();
                }
                var1_1 = this._factory.makeObject();
                bl = true;
                if (var1_1 == null) {
                    throw new NoSuchElementException("PoolableObjectFactory.makeObject() returned null.");
                }
            }
            if (this._factory == null || var1_1 == null) continue;
            try {
                this._factory.activateObject(var1_1);
                if (this._factory.validateObject(var1_1)) continue;
                throw new Exception("ValidateObject failed");
            }
            catch (Throwable throwable) {
                block12: {
                    PoolUtils.checkRethrow(throwable);
                    try {
                        try {
                            this._factory.destroyObject(var1_1);
                        }
                        catch (Throwable throwable2) {
                            PoolUtils.checkRethrow(throwable2);
                            var1_1 = null;
                            break block12;
                        }
                    }
                    catch (Throwable throwable3) {
                        var1_1 = null;
                        throw throwable3;
                    }
                    var1_1 = null;
                }
                if (!bl) continue;
                throw new NoSuchElementException("Could not create a validated object, cause: " + throwable.getMessage());
            }
        }
        ++this._numActive;
        return var1_1;
    }

    @Override
    public synchronized void returnObject(T t) throws Exception {
        boolean bl;
        boolean bl2 = bl = !this.isClosed();
        if (this._factory != null) {
            if (!this._factory.validateObject(t)) {
                bl = false;
            } else {
                try {
                    this._factory.passivateObject(t);
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
        }
        boolean bl3 = !bl;
        --this._numActive;
        if (bl) {
            Object var4_4 = null;
            if (this._pool.size() >= this._maxSleeping) {
                bl3 = true;
                var4_4 = this._pool.remove(0);
            }
            this._pool.push(t);
            t = var4_4;
        }
        this.notifyAll();
        if (bl3) {
            try {
                this._factory.destroyObject(t);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public synchronized void invalidateObject(T t) throws Exception {
        --this._numActive;
        if (this._factory != null) {
            this._factory.destroyObject(t);
        }
        this.notifyAll();
    }

    @Override
    public synchronized int getNumIdle() {
        return this._pool.size();
    }

    @Override
    public synchronized int getNumActive() {
        return this._numActive;
    }

    @Override
    public synchronized void clear() {
        if (this._factory != null) {
            Iterator iterator = this._pool.iterator();
            while (iterator.hasNext()) {
                try {
                    this._factory.destroyObject(iterator.next());
                }
                catch (Exception exception) {}
            }
        }
        this._pool.clear();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.clear();
    }

    @Override
    public synchronized void addObject() throws Exception {
        boolean bl;
        this.assertOpen();
        if (this._factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        T t = this._factory.makeObject();
        boolean bl2 = true;
        if (!this._factory.validateObject(t)) {
            bl2 = false;
        } else {
            this._factory.passivateObject(t);
        }
        boolean bl3 = bl = !bl2;
        if (bl2) {
            Object var4_4 = null;
            if (this._pool.size() >= this._maxSleeping) {
                bl = true;
                var4_4 = this._pool.remove(0);
            }
            this._pool.push(t);
            t = var4_4;
        }
        this.notifyAll();
        if (bl) {
            try {
                this._factory.destroyObject(t);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    @Deprecated
    public synchronized void setFactory(PoolableObjectFactory<T> poolableObjectFactory) throws IllegalStateException {
        this.assertOpen();
        if (this.getNumActive() > 0) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = poolableObjectFactory;
    }

    public synchronized PoolableObjectFactory<T> getFactory() {
        return this._factory;
    }

    public int getMaxSleeping() {
        return this._maxSleeping;
    }
}

