/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.commons.pool.BaseKeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.PoolUtils;

public class StackKeyedObjectPool<K, V>
extends BaseKeyedObjectPool<K, V>
implements KeyedObjectPool<K, V> {
    protected static final int DEFAULT_MAX_SLEEPING = 8;
    protected static final int DEFAULT_INIT_SLEEPING_CAPACITY = 4;
    @Deprecated
    protected HashMap<K, Stack<V>> _pools = null;
    @Deprecated
    protected KeyedPoolableObjectFactory<K, V> _factory = null;
    @Deprecated
    protected int _maxSleeping = 8;
    @Deprecated
    protected int _initSleepingCapacity = 4;
    @Deprecated
    protected int _totActive = 0;
    @Deprecated
    protected int _totIdle = 0;
    @Deprecated
    protected HashMap<K, Integer> _activeCount = null;

    public StackKeyedObjectPool() {
        this(null, 8, 4);
    }

    public StackKeyedObjectPool(int n) {
        this(null, n, 4);
    }

    public StackKeyedObjectPool(int n, int n2) {
        this(null, n, n2);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory) {
        this(keyedPoolableObjectFactory, 8);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, int n) {
        this(keyedPoolableObjectFactory, n, 4);
    }

    public StackKeyedObjectPool(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory, int n, int n2) {
        this._factory = keyedPoolableObjectFactory;
        this._maxSleeping = n < 0 ? 8 : n;
        this._initSleepingCapacity = n2 < 1 ? 4 : n2;
        this._pools = new HashMap();
        this._activeCount = new HashMap();
    }

    @Override
    public synchronized V borrowObject(K k) throws Exception {
        this.assertOpen();
        Stack<Object> stack = this._pools.get(k);
        if (stack == null) {
            stack = new Stack();
            stack.ensureCapacity(this._initSleepingCapacity > this._maxSleeping ? this._maxSleeping : this._initSleepingCapacity);
            this._pools.put(k, stack);
        }
        Object object = null;
        do {
            boolean bl = false;
            if (!stack.empty()) {
                object = stack.pop();
                --this._totIdle;
            } else {
                if (this._factory == null) {
                    throw new NoSuchElementException("pools without a factory cannot create new objects as needed.");
                }
                object = this._factory.makeObject(k);
                bl = true;
            }
            if (this._factory == null || object == null) continue;
            try {
                this._factory.activateObject(k, object);
                if (!this._factory.validateObject(k, object)) {
                    throw new Exception("ValidateObject failed");
                }
            }
            catch (Throwable throwable) {
                block13: {
                    PoolUtils.checkRethrow(throwable);
                    try {
                        try {
                            this._factory.destroyObject(k, object);
                        }
                        catch (Throwable throwable2) {
                            PoolUtils.checkRethrow(throwable2);
                            object = null;
                            break block13;
                        }
                    }
                    catch (Throwable throwable3) {
                        object = null;
                        throw throwable3;
                    }
                    object = null;
                }
                if (!bl) continue;
                throw new NoSuchElementException("Could not create a validated object, cause: " + throwable.getMessage());
            }
        } while (object == null);
        this.incrementActiveCount(k);
        return (V)object;
    }

    @Override
    public synchronized void returnObject(K k, V v) throws Exception {
        int n;
        this.decrementActiveCount(k);
        if (this._factory != null) {
            if (this._factory.validateObject(k, v)) {
                try {
                    this._factory.passivateObject(k, v);
                }
                catch (Exception exception) {
                    this._factory.destroyObject(k, v);
                    return;
                }
            } else {
                return;
            }
        }
        if (this.isClosed()) {
            if (this._factory != null) {
                try {
                    this._factory.destroyObject(k, v);
                }
                catch (Exception exception) {}
            }
            return;
        }
        Stack<Object> stack = this._pools.get(k);
        if (stack == null) {
            stack = new Stack();
            stack.ensureCapacity(this._initSleepingCapacity > this._maxSleeping ? this._maxSleeping : this._initSleepingCapacity);
            this._pools.put(k, stack);
        }
        if ((n = stack.size()) >= this._maxSleeping) {
            Object object;
            if (n > 0) {
                object = stack.remove(0);
                --this._totIdle;
            } else {
                object = v;
            }
            if (this._factory != null) {
                try {
                    this._factory.destroyObject(k, object);
                }
                catch (Exception exception) {}
            }
        }
        stack.push(v);
        ++this._totIdle;
    }

    @Override
    public synchronized void invalidateObject(K k, V v) throws Exception {
        this.decrementActiveCount(k);
        if (this._factory != null) {
            this._factory.destroyObject(k, v);
        }
        this.notifyAll();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void addObject(K k) throws Exception {
        int n;
        this.assertOpen();
        if (this._factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        V v = this._factory.makeObject(k);
        try {
            if (!this._factory.validateObject(k, v)) {
                return;
            }
        }
        catch (Exception exception) {
            try {
                this._factory.destroyObject(k, v);
                return;
            }
            catch (Exception exception2) {}
            return;
        }
        this._factory.passivateObject(k, v);
        Stack<Object> stack = this._pools.get(k);
        if (stack == null) {
            stack = new Stack();
            stack.ensureCapacity(this._initSleepingCapacity > this._maxSleeping ? this._maxSleeping : this._initSleepingCapacity);
            this._pools.put(k, stack);
        }
        if ((n = stack.size()) >= this._maxSleeping) {
            void var5_7;
            if (n > 0) {
                Object e = stack.remove(0);
                --this._totIdle;
            } else {
                V v2 = v;
            }
            try {
                this._factory.destroyObject(k, var5_7);
                return;
            }
            catch (Exception exception) {
                if (v != var5_7) return;
                throw exception;
            }
        } else {
            stack.push(v);
            ++this._totIdle;
        }
    }

    @Override
    public synchronized int getNumIdle() {
        return this._totIdle;
    }

    @Override
    public synchronized int getNumActive() {
        return this._totActive;
    }

    @Override
    public synchronized int getNumActive(K k) {
        return this.getActiveCount(k);
    }

    @Override
    public synchronized int getNumIdle(K k) {
        try {
            return this._pools.get(k).size();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public synchronized void clear() {
        for (K k : this._pools.keySet()) {
            Stack<V> stack = this._pools.get(k);
            this.destroyStack(k, stack);
        }
        this._totIdle = 0;
        this._pools.clear();
        this._activeCount.clear();
    }

    @Override
    public synchronized void clear(K k) {
        Stack<V> stack = this._pools.remove(k);
        this.destroyStack(k, stack);
    }

    private synchronized void destroyStack(K k, Stack<V> stack) {
        if (stack == null) {
            return;
        }
        if (this._factory != null) {
            Iterator iterator = stack.iterator();
            while (iterator.hasNext()) {
                try {
                    this._factory.destroyObject(k, iterator.next());
                }
                catch (Exception exception) {}
            }
        }
        this._totIdle -= stack.size();
        this._activeCount.remove(k);
        stack.clear();
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" contains ").append(this._pools.size()).append(" distinct pools: ");
        for (K k : this._pools.keySet()) {
            stringBuffer.append(" |").append(k).append("|=");
            Stack<V> stack = this._pools.get(k);
            stringBuffer.append(stack.size());
        }
        return stringBuffer.toString();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.clear();
    }

    @Override
    @Deprecated
    public synchronized void setFactory(KeyedPoolableObjectFactory<K, V> keyedPoolableObjectFactory) throws IllegalStateException {
        if (this.getNumActive() > 0) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = keyedPoolableObjectFactory;
    }

    public synchronized KeyedPoolableObjectFactory<K, V> getFactory() {
        return this._factory;
    }

    private int getActiveCount(K k) {
        try {
            return this._activeCount.get(k);
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    private void incrementActiveCount(K k) {
        ++this._totActive;
        Integer n = this._activeCount.get(k);
        if (n == null) {
            this._activeCount.put(k, new Integer(1));
        } else {
            this._activeCount.put(k, new Integer(n + 1));
        }
    }

    private void decrementActiveCount(K k) {
        --this._totActive;
        Integer n = this._activeCount.get(k);
        if (n != null) {
            if (n <= 1) {
                this._activeCount.remove(k);
            } else {
                this._activeCount.put(k, new Integer(n - 1));
            }
        }
    }

    public Map<K, Stack<V>> getPools() {
        return this._pools;
    }

    public int getMaxSleeping() {
        return this._maxSleeping;
    }

    public int getInitSleepingCapacity() {
        return this._initSleepingCapacity;
    }

    public int getTotActive() {
        return this._totActive;
    }

    public int getTotIdle() {
        return this._totIdle;
    }

    public Map<K, Integer> getActiveCount() {
        return this._activeCount;
    }
}

