/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolUtils;
import org.apache.commons.pool.PoolableObjectFactory;

public class SoftReferenceObjectPool<T>
extends BaseObjectPool<T>
implements ObjectPool<T> {
    private final List<SoftReference<T>> _pool;
    private PoolableObjectFactory<T> _factory = null;
    private final ReferenceQueue<T> refQueue = new ReferenceQueue();
    private int _numActive = 0;

    @Deprecated
    public SoftReferenceObjectPool() {
        this._pool = new ArrayList<SoftReference<T>>();
        this._factory = null;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory<T> poolableObjectFactory) {
        this._pool = new ArrayList<SoftReference<T>>();
        this._factory = poolableObjectFactory;
    }

    @Deprecated
    public SoftReferenceObjectPool(PoolableObjectFactory<T> poolableObjectFactory, int n) throws Exception, IllegalArgumentException {
        if (poolableObjectFactory == null) {
            throw new IllegalArgumentException("factory required to prefill the pool.");
        }
        this._pool = new ArrayList<SoftReference<T>>(n);
        this._factory = poolableObjectFactory;
        PoolUtils.prefill(this, n);
    }

    @Override
    public synchronized T borrowObject() throws Exception {
        this.assertOpen();
        Object var1_1 = null;
        boolean bl = false;
        while (var1_1 == null) {
            if (this._pool.isEmpty()) {
                if (this._factory == null) {
                    throw new NoSuchElementException();
                }
                bl = true;
                var1_1 = this._factory.makeObject();
            } else {
                SoftReference<T> softReference = this._pool.remove(this._pool.size() - 1);
                var1_1 = softReference.get();
                softReference.clear();
            }
            if (this._factory == null || var1_1 == null) continue;
            try {
                this._factory.activateObject(var1_1);
                if (this._factory.validateObject(var1_1)) continue;
                throw new Exception("ValidateObject failed");
            }
            catch (Throwable throwable) {
                block11: {
                    PoolUtils.checkRethrow(throwable);
                    try {
                        try {
                            this._factory.destroyObject(var1_1);
                        }
                        catch (Throwable throwable2) {
                            PoolUtils.checkRethrow(throwable2);
                            var1_1 = null;
                            break block11;
                        }
                    }
                    catch (Throwable throwable3) {
                        var1_1 = null;
                        throw throwable3;
                    }
                    var1_1 = null;
                }
                if (!bl) continue;
                throw new NoSuchElementException("Could not create a validated object, cause: " + throwable.getMessage());
            }
        }
        ++this._numActive;
        return var1_1;
    }

    @Override
    public synchronized void returnObject(T t) throws Exception {
        boolean bl;
        boolean bl2 = bl = !this.isClosed();
        if (this._factory != null) {
            if (!this._factory.validateObject(t)) {
                bl = false;
            } else {
                try {
                    this._factory.passivateObject(t);
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
        }
        boolean bl3 = !bl;
        --this._numActive;
        if (bl) {
            this._pool.add(new SoftReference<T>(t, this.refQueue));
        }
        this.notifyAll();
        if (bl3 && this._factory != null) {
            try {
                this._factory.destroyObject(t);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public synchronized void invalidateObject(T t) throws Exception {
        --this._numActive;
        if (this._factory != null) {
            this._factory.destroyObject(t);
        }
        this.notifyAll();
    }

    @Override
    public synchronized void addObject() throws Exception {
        boolean bl;
        this.assertOpen();
        if (this._factory == null) {
            throw new IllegalStateException("Cannot add objects without a factory.");
        }
        T t = this._factory.makeObject();
        boolean bl2 = true;
        if (!this._factory.validateObject(t)) {
            bl2 = false;
        } else {
            this._factory.passivateObject(t);
        }
        boolean bl3 = bl = !bl2;
        if (bl2) {
            this._pool.add(new SoftReference<T>(t, this.refQueue));
            this.notifyAll();
        }
        if (bl) {
            try {
                this._factory.destroyObject(t);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public synchronized int getNumIdle() {
        this.pruneClearedReferences();
        return this._pool.size();
    }

    @Override
    public synchronized int getNumActive() {
        return this._numActive;
    }

    @Override
    public synchronized void clear() {
        if (this._factory != null) {
            Iterator<SoftReference<T>> iterator = this._pool.iterator();
            while (iterator.hasNext()) {
                try {
                    T t = iterator.next().get();
                    if (t == null) continue;
                    this._factory.destroyObject(t);
                }
                catch (Exception exception) {}
            }
        }
        this._pool.clear();
        this.pruneClearedReferences();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.clear();
    }

    @Override
    @Deprecated
    public synchronized void setFactory(PoolableObjectFactory<T> poolableObjectFactory) throws IllegalStateException {
        this.assertOpen();
        if (this.getNumActive() > 0) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this._factory = poolableObjectFactory;
    }

    private void pruneClearedReferences() {
        Reference<T> reference;
        while ((reference = this.refQueue.poll()) != null) {
            try {
                this._pool.remove(reference);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    public synchronized PoolableObjectFactory<T> getFactory() {
        return this._factory;
    }
}

