/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.pool.impl.CursorableLinkedList;

class CursorableSubList<E>
extends CursorableLinkedList<E>
implements List<E> {
    protected CursorableLinkedList<E> _list = null;
    protected CursorableLinkedList.Listable<E> _pre = null;
    protected CursorableLinkedList.Listable<E> _post = null;

    CursorableSubList(CursorableLinkedList<E> cursorableLinkedList, int n, int n2) {
        if (n < 0 || cursorableLinkedList.size() < n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        this._list = cursorableLinkedList;
        if (n < cursorableLinkedList.size()) {
            this._head.setNext(this._list.getListableAt(n));
            this._pre = this._head.next() == null ? null : this._head.next().prev();
        } else {
            this._pre = this._list.getListableAt(n - 1);
        }
        if (n == n2) {
            this._head.setNext(null);
            this._head.setPrev(null);
            this._post = n2 < cursorableLinkedList.size() ? this._list.getListableAt(n2) : null;
        } else {
            this._head.setPrev(this._list.getListableAt(n2 - 1));
            this._post = this._head.prev().next();
        }
        this._size = n2 - n;
        this._modCount = this._list._modCount;
    }

    @Override
    public void clear() {
        this.checkForComod();
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public Iterator<E> iterator() {
        this.checkForComod();
        return super.iterator();
    }

    @Override
    public int size() {
        this.checkForComod();
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkForComod();
        return super.isEmpty();
    }

    @Override
    public Object[] toArray() {
        this.checkForComod();
        return super.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        this.checkForComod();
        return super.toArray(TArray);
    }

    @Override
    public boolean contains(Object object) {
        this.checkForComod();
        return super.contains(object);
    }

    @Override
    public boolean remove(Object object) {
        this.checkForComod();
        return super.remove(object);
    }

    @Override
    public E removeFirst() {
        this.checkForComod();
        return super.removeFirst();
    }

    @Override
    public E removeLast() {
        this.checkForComod();
        return super.removeLast();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.checkForComod();
        return super.addAll(collection);
    }

    @Override
    public boolean add(E e) {
        this.checkForComod();
        return super.add(e);
    }

    @Override
    public boolean addFirst(E e) {
        this.checkForComod();
        return super.addFirst(e);
    }

    @Override
    public boolean addLast(E e) {
        this.checkForComod();
        return super.addLast(e);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.checkForComod();
        return super.removeAll(collection);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        this.checkForComod();
        return super.containsAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        this.checkForComod();
        return super.addAll(n, collection);
    }

    @Override
    public int hashCode() {
        this.checkForComod();
        return super.hashCode();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.checkForComod();
        return super.retainAll(collection);
    }

    @Override
    public E set(int n, E e) {
        this.checkForComod();
        return super.set(n, e);
    }

    @Override
    public boolean equals(Object object) {
        this.checkForComod();
        return super.equals(object);
    }

    @Override
    public E get(int n) {
        this.checkForComod();
        return super.get(n);
    }

    @Override
    public E getFirst() {
        this.checkForComod();
        return super.getFirst();
    }

    @Override
    public E getLast() {
        this.checkForComod();
        return super.getLast();
    }

    @Override
    public void add(int n, E e) {
        this.checkForComod();
        super.add(n, e);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        this.checkForComod();
        return super.listIterator(n);
    }

    @Override
    public E remove(int n) {
        this.checkForComod();
        return super.remove(n);
    }

    @Override
    public int indexOf(Object object) {
        this.checkForComod();
        return super.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        this.checkForComod();
        return super.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        this.checkForComod();
        return super.listIterator();
    }

    @Override
    public List<E> subList(int n, int n2) {
        this.checkForComod();
        return super.subList(n, n2);
    }

    @Override
    protected CursorableLinkedList.Listable<E> insertListable(CursorableLinkedList.Listable<E> listable, CursorableLinkedList.Listable<E> listable2, E e) {
        ++this._modCount;
        ++this._size;
        CursorableLinkedList.Listable<E> listable3 = this._list.insertListable(listable == null ? this._pre : listable, listable2 == null ? this._post : listable2, e);
        if (this._head.next() == null) {
            this._head.setNext(listable3);
            this._head.setPrev(listable3);
        }
        if (listable == this._head.prev()) {
            this._head.setPrev(listable3);
        }
        if (listable2 == this._head.next()) {
            this._head.setNext(listable3);
        }
        this.broadcastListableInserted(listable3);
        return listable3;
    }

    @Override
    protected void removeListable(CursorableLinkedList.Listable<E> listable) {
        ++this._modCount;
        --this._size;
        if (this._head.next() == listable && this._head.prev() == listable) {
            this._head.setNext(null);
            this._head.setPrev(null);
        }
        if (this._head.next() == listable) {
            this._head.setNext(listable.next());
        }
        if (this._head.prev() == listable) {
            this._head.setPrev(listable.prev());
        }
        this._list.removeListable(listable);
        this.broadcastListableRemoved(listable);
    }

    protected void checkForComod() throws ConcurrentModificationException {
        if (this._modCount != this._list._modCount) {
            throw new ConcurrentModificationException();
        }
    }
}

