/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.pool.impl.CursorableSubList;

class CursorableLinkedList<E>
implements List<E>,
Serializable {
    private static final long serialVersionUID = 8836393098519411393L;
    protected transient int _size = 0;
    protected transient Listable<E> _head = new Listable<Object>(null, null, null);
    protected transient int _modCount = 0;
    protected transient List<WeakReference<Cursor>> _cursors = new ArrayList<WeakReference<Cursor>>();

    CursorableLinkedList() {
    }

    @Override
    public boolean add(E e) {
        this.insertListable(this._head.prev(), null, e);
        return true;
    }

    @Override
    public void add(int n, E e) {
        if (n == this._size) {
            this.add(e);
        } else {
            if (n < 0 || n > this._size) {
                throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(n)) + " < 0 or " + String.valueOf(n) + " > " + this._size);
            }
            Listable<E> listable = this.isEmpty() ? null : this.getListableAt(n);
            Listable<E> listable2 = listable == null ? null : listable.prev();
            this.insertListable(listable2, listable, e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.insertListable(this._head.prev(), null, iterator.next());
        }
        return true;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        if (this._size == n || this._size == 0) {
            return this.addAll(collection);
        }
        Listable<E> listable = this.getListableAt(n);
        Listable<E> listable2 = listable == null ? null : listable.prev();
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            listable2 = this.insertListable(listable2, listable, iterator.next());
        }
        return true;
    }

    public boolean addFirst(E e) {
        this.insertListable(null, this._head.next(), e);
        return true;
    }

    public boolean addLast(E e) {
        this.insertListable(this._head.prev(), null, e);
        return true;
    }

    @Override
    public void clear() {
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public boolean contains(Object object) {
        Listable<E> listable = this._head.next();
        Listable<E> listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            if (object == null && listable.value() == null || object != null && object.equals(listable.value())) {
                return true;
            }
            listable2 = listable;
            listable = listable2.next();
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public Cursor cursor() {
        return new Cursor(0);
    }

    public Cursor cursor(int n) {
        return new Cursor(n);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        ListIterator listIterator = ((List)object).listIterator();
        Listable<E> listable = this._head.next();
        Listable<E> listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            if (!listIterator.hasNext() || (listable.value() == null ? listIterator.next() != null : !listable.value().equals(listIterator.next()))) {
                return false;
            }
            listable2 = listable;
            listable = listable2.next();
        }
        return !listIterator.hasNext();
    }

    @Override
    public E get(int n) {
        return this.getListableAt(n).value();
    }

    @Override
    public E getFirst() {
        try {
            return this._head.next().value();
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public E getLast() {
        try {
            return this._head.prev().value();
        }
        catch (NullPointerException nullPointerException) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int hashCode() {
        int n = 1;
        Listable<E> listable = this._head.next();
        Listable<E> listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            n = 31 * n + (listable.value() == null ? 0 : listable.value().hashCode());
            listable2 = listable;
            listable = listable2.next();
        }
        return n;
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        if (object == null) {
            Listable<E> listable = this._head.next();
            Listable<E> listable2 = null;
            while (listable != null && listable2 != this._head.prev()) {
                if (listable.value() == null) {
                    return n;
                }
                ++n;
                listable2 = listable;
                listable = listable2.next();
            }
        } else {
            Listable<E> listable = this._head.next();
            Listable<E> listable3 = null;
            while (listable != null && listable3 != this._head.prev()) {
                if (object.equals(listable.value())) {
                    return n;
                }
                ++n;
                listable3 = listable;
                listable = listable3.next();
            }
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this._size - 1;
        if (object == null) {
            Listable<E> listable = this._head.prev();
            Listable<E> listable2 = null;
            while (listable != null && listable2 != this._head.next()) {
                if (listable.value() == null) {
                    return n;
                }
                --n;
                listable2 = listable;
                listable = listable2.prev();
            }
        } else {
            Listable<E> listable = this._head.prev();
            Listable<E> listable3 = null;
            while (listable != null && listable3 != this._head.next()) {
                if (object.equals(listable.value())) {
                    return n;
                }
                --n;
                listable3 = listable;
                listable = listable3.prev();
            }
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException(String.valueOf(n) + " < 0 or > " + this._size);
        }
        return new ListIter(n);
    }

    @Override
    public boolean remove(Object object) {
        Listable<E> listable = this._head.next();
        Listable<E> listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            if (object == null && listable.value() == null) {
                this.removeListable(listable);
                return true;
            }
            if (object != null && object.equals(listable.value())) {
                this.removeListable(listable);
                return true;
            }
            listable2 = listable;
            listable = listable2.next();
        }
        return false;
    }

    @Override
    public E remove(int n) {
        Listable<E> listable = this.getListableAt(n);
        E e = listable.value();
        this.removeListable(listable);
        return e;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (collection.size() == 0 || this._size == 0) {
            return false;
        }
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public E removeFirst() {
        if (this._head.next() != null) {
            E e = this._head.next().value();
            this.removeListable(this._head.next());
            return e;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E removeLast() {
        if (this._head.prev() != null) {
            E e = this._head.prev().value();
            this.removeListable(this._head.prev());
            return e;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public E set(int n, E e) {
        Listable<E> listable = this.getListableAt(n);
        E e2 = listable.setValue(e);
        this.broadcastListableChanged(listable);
        return e2;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this._size];
        int n = 0;
        Listable<E> listable = this._head.next();
        Listable<E> listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            objectArray[n++] = listable.value();
            listable2 = listable;
            listable = listable2.next();
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this._size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this._size);
        }
        int n = 0;
        Listable<E> listable = this._head.next();
        Listable<E> listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            objectArray[n++] = listable.value();
            listable2 = listable;
            listable = listable2.next();
        }
        if (objectArray.length > this._size) {
            objectArray[this._size] = null;
        }
        return objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Listable<E> listable = this._head.next();
        Listable<E> listable2 = null;
        while (listable != null && listable2 != this._head.prev()) {
            if (this._head.next() != listable) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(listable.value());
            listable2 = listable;
            listable = listable2.next();
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public List<E> subList(int n, int n2) {
        if (n < 0 || n2 > this._size || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n == 0 && n2 == this._size) {
            return this;
        }
        return new CursorableSubList(this, n, n2);
    }

    protected Listable<E> insertListable(Listable<E> listable, Listable<E> listable2, E e) {
        ++this._modCount;
        ++this._size;
        Listable<E> listable3 = new Listable<E>(listable, listable2, e);
        if (listable != null) {
            listable.setNext(listable3);
        } else {
            this._head.setNext(listable3);
        }
        if (listable2 != null) {
            listable2.setPrev(listable3);
        } else {
            this._head.setPrev(listable3);
        }
        this.broadcastListableInserted(listable3);
        return listable3;
    }

    protected void removeListable(Listable<E> listable) {
        ++this._modCount;
        --this._size;
        if (this._head.next() == listable) {
            this._head.setNext(listable.next());
        }
        if (listable.next() != null) {
            listable.next().setPrev(listable.prev());
        }
        if (this._head.prev() == listable) {
            this._head.setPrev(listable.prev());
        }
        if (listable.prev() != null) {
            listable.prev().setNext(listable.next());
        }
        this.broadcastListableRemoved(listable);
    }

    protected Listable<E> getListableAt(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(n)) + " < 0 or " + String.valueOf(n) + " >= " + this._size);
        }
        if (n <= this._size / 2) {
            Listable<E> listable = this._head.next();
            int n2 = 0;
            while (n2 < n) {
                listable = listable.next();
                ++n2;
            }
            return listable;
        }
        Listable<E> listable = this._head.prev();
        int n3 = this._size - 1;
        while (n3 > n) {
            listable = listable.prev();
            --n3;
        }
        return listable;
    }

    protected void registerCursor(Cursor cursor) {
        Iterator<WeakReference<Cursor>> iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference<Cursor> weakReference = iterator.next();
            if (weakReference.get() != null) continue;
            iterator.remove();
        }
        this._cursors.add(new WeakReference<Cursor>(cursor));
    }

    protected void unregisterCursor(Cursor cursor) {
        Iterator<WeakReference<Cursor>> iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference<Cursor> weakReference = iterator.next();
            Cursor cursor2 = (Cursor)weakReference.get();
            if (cursor2 == null) {
                iterator.remove();
                continue;
            }
            if (cursor2 != cursor) continue;
            weakReference.clear();
            iterator.remove();
            break;
        }
    }

    protected void invalidateCursors() {
        Iterator<WeakReference<Cursor>> iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference<Cursor> weakReference = iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor != null) {
                cursor.invalidate();
                weakReference.clear();
            }
            iterator.remove();
        }
    }

    protected void broadcastListableChanged(Listable<E> listable) {
        Iterator<WeakReference<Cursor>> iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference<Cursor> weakReference = iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            cursor.listableChanged(listable);
        }
    }

    protected void broadcastListableRemoved(Listable<E> listable) {
        Iterator<WeakReference<Cursor>> iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference<Cursor> weakReference = iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            cursor.listableRemoved(listable);
        }
    }

    protected void broadcastListableInserted(Listable<E> listable) {
        Iterator<WeakReference<Cursor>> iterator = this._cursors.iterator();
        while (iterator.hasNext()) {
            WeakReference<Cursor> weakReference = iterator.next();
            Cursor cursor = (Cursor)weakReference.get();
            if (cursor == null) {
                iterator.remove();
                continue;
            }
            cursor.listableInserted(listable);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        Listable<E> listable = this._head.next();
        while (listable != null) {
            objectOutputStream.writeObject(listable.value());
            listable = listable.next();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._size = 0;
        this._modCount = 0;
        this._cursors = new ArrayList<WeakReference<Cursor>>();
        this._head = new Listable<Object>(null, null, null);
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            this.add(objectInputStream.readObject());
            ++n2;
        }
    }

    public class Cursor
    extends ListIter
    implements ListIterator<E> {
        boolean _valid;

        Cursor(int n) {
            super(n);
            this._valid = false;
            this._valid = true;
            CursorableLinkedList.this.registerCursor(this);
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            this.checkForComod();
            Listable listable = CursorableLinkedList.this.insertListable(this._cur.prev(), this._cur.next(), e);
            this._cur.setPrev(listable);
            this._cur.setNext(listable.next());
            this._lastReturned = null;
            ++this._nextIndex;
            ++this._expectedModCount;
        }

        protected void listableRemoved(Listable<E> listable) {
            if (CursorableLinkedList.this._head.prev() == null) {
                this._cur.setNext(null);
            } else if (this._cur.next() == listable) {
                this._cur.setNext(listable.next());
            }
            if (CursorableLinkedList.this._head.next() == null) {
                this._cur.setPrev(null);
            } else if (this._cur.prev() == listable) {
                this._cur.setPrev(listable.prev());
            }
            if (this._lastReturned == listable) {
                this._lastReturned = null;
            }
        }

        protected void listableInserted(Listable<E> listable) {
            if (this._cur.next() == null && this._cur.prev() == null) {
                this._cur.setNext(listable);
            } else if (this._cur.prev() == listable.prev()) {
                this._cur.setNext(listable);
            }
            if (this._cur.next() == listable.next()) {
                this._cur.setPrev(listable);
            }
            if (this._lastReturned == listable) {
                this._lastReturned = null;
            }
        }

        protected void listableChanged(Listable<E> listable) {
            if (this._lastReturned == listable) {
                this._lastReturned = null;
            }
        }

        @Override
        protected void checkForComod() {
            if (!this._valid) {
                throw new ConcurrentModificationException();
            }
        }

        protected void invalidate() {
            this._valid = false;
        }

        public void close() {
            if (this._valid) {
                this._valid = false;
                CursorableLinkedList.this.unregisterCursor(this);
            }
        }
    }

    class ListIter
    implements ListIterator<E> {
        Listable<E> _cur = null;
        Listable<E> _lastReturned = null;
        int _expectedModCount;
        int _nextIndex;

        ListIter(int n) {
            this._expectedModCount = CursorableLinkedList.this._modCount;
            this._nextIndex = 0;
            if (n == 0) {
                this._cur = new Listable<Object>(null, CursorableLinkedList.this._head.next(), null);
                this._nextIndex = 0;
            } else if (n == CursorableLinkedList.this._size) {
                this._cur = new Listable<Object>(CursorableLinkedList.this._head.prev(), null, null);
                this._nextIndex = CursorableLinkedList.this._size;
            } else {
                Listable listable = CursorableLinkedList.this.getListableAt(n);
                this._cur = new Listable<Object>(listable.prev(), listable, null);
                this._nextIndex = n;
            }
        }

        @Override
        public E previous() {
            this.checkForComod();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Object e = this._cur.prev().value();
            this._lastReturned = this._cur.prev();
            this._cur.setNext(this._cur.prev());
            this._cur.setPrev(this._cur.prev().prev());
            --this._nextIndex;
            return e;
        }

        @Override
        public boolean hasNext() {
            this.checkForComod();
            return this._cur.next() != null && this._cur.prev() != CursorableLinkedList.this._head.prev();
        }

        @Override
        public E next() {
            this.checkForComod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object e = this._cur.next().value();
            this._lastReturned = this._cur.next();
            this._cur.setPrev(this._cur.next());
            this._cur.setNext(this._cur.next().next());
            ++this._nextIndex;
            return e;
        }

        @Override
        public int previousIndex() {
            this.checkForComod();
            if (!this.hasPrevious()) {
                return -1;
            }
            return this._nextIndex - 1;
        }

        @Override
        public boolean hasPrevious() {
            this.checkForComod();
            return this._cur.prev() != null && this._cur.next() != CursorableLinkedList.this._head.next();
        }

        @Override
        public void set(E e) {
            this.checkForComod();
            try {
                this._lastReturned.setValue(e);
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalStateException();
            }
        }

        @Override
        public int nextIndex() {
            this.checkForComod();
            if (!this.hasNext()) {
                return CursorableLinkedList.this.size();
            }
            return this._nextIndex;
        }

        @Override
        public void remove() {
            this.checkForComod();
            if (this._lastReturned == null) {
                throw new IllegalStateException();
            }
            this._cur.setNext(this._lastReturned == CursorableLinkedList.this._head.prev() ? null : this._lastReturned.next());
            this._cur.setPrev(this._lastReturned == CursorableLinkedList.this._head.next() ? null : this._lastReturned.prev());
            CursorableLinkedList.this.removeListable(this._lastReturned);
            this._lastReturned = null;
            --this._nextIndex;
            ++this._expectedModCount;
        }

        @Override
        public void add(E e) {
            this.checkForComod();
            this._cur.setPrev(CursorableLinkedList.this.insertListable(this._cur.prev(), this._cur.next(), e));
            this._lastReturned = null;
            ++this._nextIndex;
            ++this._expectedModCount;
        }

        protected void checkForComod() {
            if (this._expectedModCount != CursorableLinkedList.this._modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    static class Listable<E>
    implements Serializable {
        private Listable<E> _prev = null;
        private Listable<E> _next = null;
        private E _val = null;

        Listable(Listable<E> listable, Listable<E> listable2, E e) {
            this._prev = listable;
            this._next = listable2;
            this._val = e;
        }

        Listable<E> next() {
            return this._next;
        }

        Listable<E> prev() {
            return this._prev;
        }

        E value() {
            return this._val;
        }

        void setNext(Listable<E> listable) {
            this._next = listable;
        }

        void setPrev(Listable<E> listable) {
            this._prev = listable;
        }

        E setValue(E e) {
            E e2 = this._val;
            this._val = e;
            return e2;
        }
    }
}

