/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.SLF4JLocationAwareLog;
import org.apache.commons.logging.impl.SLF4JLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLogFactory
extends LogFactory {
    Map loggerMap;
    public static final String LOG_PROPERTY = "org.apache.commons.logging.Log";
    protected Hashtable attributes = new Hashtable();

    public SLF4JLogFactory() {
        this.loggerMap = new HashMap();
    }

    @Override
    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    @Override
    public String[] getAttributeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            arrayList.add((String)enumeration.nextElement());
        }
        String[] stringArray = new String[arrayList.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)arrayList.get(n);
            ++n;
        }
        return stringArray;
    }

    @Override
    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Log getInstance(String string) throws LogConfigurationException {
        Log log = null;
        Map map = this.loggerMap;
        synchronized (map) {
            log = (Log)this.loggerMap.get(string);
            if (log == null) {
                Logger logger = LoggerFactory.getLogger((String)string);
                log = logger instanceof LocationAwareLogger ? new SLF4JLocationAwareLog((LocationAwareLogger)logger) : new SLF4JLog(logger);
                this.loggerMap.put(string, log);
            }
        }
        return log;
    }

    @Override
    public void release() {
        System.out.println("WARN: The method " + SLF4JLogFactory.class + "#release() was invoked.");
        System.out.println("WARN: Please see http://www.slf4j.org/codes.html#release for an explanation.");
        System.out.flush();
    }

    @Override
    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (object == null) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
    }
}

