/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

@Deprecated
public class WildcardFilter
extends AbstractFileFilter
implements Serializable {
    private final String[] wildcards;

    public WildcardFilter(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.wildcards = new String[]{string};
    }

    public WildcardFilter(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        this.wildcards = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.wildcards, 0, stringArray.length);
    }

    public WildcardFilter(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("The wildcard list must not be null");
        }
        this.wildcards = list.toArray(new String[list.size()]);
    }

    @Override
    public boolean accept(File file, String string) {
        if (file != null && new File(file, string).isDirectory()) {
            return false;
        }
        String[] stringArray = this.wildcards;
        int n = this.wildcards.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (FilenameUtils.wildcardMatch(string, string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String[] stringArray = this.wildcards;
        int n = this.wildcards.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (FilenameUtils.wildcardMatch(file.getName(), string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

