/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class WildcardFileFilter
extends AbstractFileFilter
implements Serializable {
    private final String[] wildcards;
    private final IOCase caseSensitivity;

    public WildcardFileFilter(String string) {
        this(string, null);
    }

    public WildcardFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.wildcards = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public WildcardFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public WildcardFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The wildcard array must not be null");
        }
        this.wildcards = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.wildcards, 0, stringArray.length);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public WildcardFileFilter(List<String> list) {
        this(list, null);
    }

    public WildcardFileFilter(List<String> list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The wildcard list must not be null");
        }
        this.wildcards = list.toArray(new String[list.size()]);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    @Override
    public boolean accept(File file, String string) {
        String[] stringArray = this.wildcards;
        int n = this.wildcards.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (FilenameUtils.wildcardMatch(string, string2, this.caseSensitivity)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean accept(File file) {
        String string = file.getName();
        String[] stringArray = this.wildcards;
        int n = this.wildcards.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (FilenameUtils.wildcardMatch(string, string2, this.caseSensitivity)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.wildcards != null) {
            int n = 0;
            while (n < this.wildcards.length) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.wildcards[n]);
                ++n;
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

