/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class SuffixFileFilter
extends AbstractFileFilter
implements Serializable {
    private final String[] suffixes;
    private final IOCase caseSensitivity;

    public SuffixFileFilter(String string) {
        this(string, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The suffix must not be null");
        }
        this.suffixes = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public SuffixFileFilter(String[] stringArray) {
        this(stringArray, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of suffixes must not be null");
        }
        this.suffixes = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.suffixes, 0, stringArray.length);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public SuffixFileFilter(List<String> list) {
        this(list, IOCase.SENSITIVE);
    }

    public SuffixFileFilter(List<String> list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The list of suffixes must not be null");
        }
        this.suffixes = list.toArray(new String[list.size()]);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    @Override
    public boolean accept(File file) {
        String string = file.getName();
        String[] stringArray = this.suffixes;
        int n = this.suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (this.caseSensitivity.checkEndsWith(string, string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String string) {
        String[] stringArray = this.suffixes;
        int n = this.suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (this.caseSensitivity.checkEndsWith(string, string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.suffixes != null) {
            int n = 0;
            while (n < this.suffixes.length) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.suffixes[n]);
                ++n;
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

