/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class PrefixFileFilter
extends AbstractFileFilter
implements Serializable {
    private final String[] prefixes;
    private final IOCase caseSensitivity;

    public PrefixFileFilter(String string) {
        this(string, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The prefix must not be null");
        }
        this.prefixes = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public PrefixFileFilter(String[] stringArray) {
        this(stringArray, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of prefixes must not be null");
        }
        this.prefixes = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.prefixes, 0, stringArray.length);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public PrefixFileFilter(List<String> list) {
        this(list, IOCase.SENSITIVE);
    }

    public PrefixFileFilter(List<String> list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The list of prefixes must not be null");
        }
        this.prefixes = list.toArray(new String[list.size()]);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    @Override
    public boolean accept(File file) {
        String string = file.getName();
        String[] stringArray = this.prefixes;
        int n = this.prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (this.caseSensitivity.checkStartsWith(string, string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String string) {
        String[] stringArray = this.prefixes;
        int n = this.prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (this.caseSensitivity.checkStartsWith(string, string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.prefixes != null) {
            int n = 0;
            while (n < this.prefixes.length) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.prefixes[n]);
                ++n;
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

