/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class NameFileFilter
extends AbstractFileFilter
implements Serializable {
    private final String[] names;
    private final IOCase caseSensitivity;

    public NameFileFilter(String string) {
        this(string, null);
    }

    public NameFileFilter(String string, IOCase iOCase) {
        if (string == null) {
            throw new IllegalArgumentException("The wildcard must not be null");
        }
        this.names = new String[]{string};
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public NameFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public NameFileFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The array of names must not be null");
        }
        this.names = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.names, 0, stringArray.length);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    public NameFileFilter(List<String> list) {
        this(list, null);
    }

    public NameFileFilter(List<String> list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The list of names must not be null");
        }
        this.names = list.toArray(new String[list.size()]);
        this.caseSensitivity = iOCase == null ? IOCase.SENSITIVE : iOCase;
    }

    @Override
    public boolean accept(File file) {
        String string = file.getName();
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (this.caseSensitivity.checkEquals(string, string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String string) {
        String[] stringArray = this.names;
        int n = this.names.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (this.caseSensitivity.checkEquals(string, string2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.names != null) {
            int n = 0;
            while (n < this.names.length) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.names[n]);
                ++n;
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

