/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.commons.io.comparator.AbstractFileComparator;

public class CompositeFileComparator
extends AbstractFileComparator
implements Serializable {
    private static final Comparator<?>[] NO_COMPARATORS = new Comparator[0];
    private final Comparator<File>[] delegates;

    public CompositeFileComparator(Comparator<File> ... comparatorArray) {
        if (comparatorArray == null) {
            this.delegates = NO_COMPARATORS;
        } else {
            this.delegates = new Comparator[comparatorArray.length];
            System.arraycopy(comparatorArray, 0, this.delegates, 0, comparatorArray.length);
        }
    }

    public CompositeFileComparator(Iterable<Comparator<File>> iterable) {
        if (iterable == null) {
            this.delegates = NO_COMPARATORS;
        } else {
            ArrayList<Comparator<File>> arrayList = new ArrayList<Comparator<File>>();
            for (Comparator<File> comparator : iterable) {
                arrayList.add(comparator);
            }
            this.delegates = arrayList.toArray(new Comparator[arrayList.size()]);
        }
    }

    @Override
    public int compare(File file, File file2) {
        int n = 0;
        Comparator<File>[] comparatorArray = this.delegates;
        int n2 = this.delegates.length;
        int n3 = 0;
        while (n3 < n2) {
            Comparator<File> comparator = comparatorArray[n3];
            n = comparator.compare(file, file2);
            if (n != 0) break;
            ++n3;
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append('{');
        int n = 0;
        while (n < this.delegates.length) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.delegates[n]);
            ++n;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

