/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.OutputStream;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts;

    static {
        int[] nArray = new int[8];
        nArray[0] = 28;
        nArray[1] = 24;
        nArray[2] = 20;
        nArray[3] = 16;
        nArray[4] = 12;
        nArray[5] = 8;
        nArray[6] = 4;
        _shifts = nArray;
    }

    public static void dump(byte[] byArray, long l, OutputStream outputStream, int n) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (n < 0 || n >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + n + " into array of length " + byArray.length);
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long l2 = l + (long)n;
        StringBuilder stringBuilder = new StringBuilder(74);
        int n2 = n;
        while (n2 < byArray.length) {
            int n3 = byArray.length - n2;
            if (n3 > 16) {
                n3 = 16;
            }
            HexDump.dump(stringBuilder, l2).append(' ');
            int n4 = 0;
            while (n4 < 16) {
                if (n4 < n3) {
                    HexDump.dump(stringBuilder, byArray[n4 + n2]);
                } else {
                    stringBuilder.append("  ");
                }
                stringBuilder.append(' ');
                ++n4;
            }
            n4 = 0;
            while (n4 < n3) {
                if (byArray[n4 + n2] >= 32 && byArray[n4 + n2] < 127) {
                    stringBuilder.append((char)byArray[n4 + n2]);
                } else {
                    stringBuilder.append('.');
                }
                ++n4;
            }
            stringBuilder.append(EOL);
            outputStream.write(stringBuilder.toString().getBytes());
            outputStream.flush();
            stringBuilder.setLength(0);
            l2 += (long)n3;
            n2 += 16;
        }
    }

    private static StringBuilder dump(StringBuilder stringBuilder, long l) {
        int n = 0;
        while (n < 8) {
            stringBuilder.append(_hexcodes[(int)(l >> _shifts[n]) & 0xF]);
            ++n;
        }
        return stringBuilder;
    }

    private static StringBuilder dump(StringBuilder stringBuilder, byte by) {
        int n = 0;
        while (n < 2) {
            stringBuilder.append(_hexcodes[by >> _shifts[n + 6] & 0xF]);
            ++n;
        }
        return stringBuilder;
    }
}

