/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.Serializable;

public class ByteOrderMark
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ByteOrderMark UTF_8 = new ByteOrderMark("UTF-8", 239, 187, 191);
    public static final ByteOrderMark UTF_16BE = new ByteOrderMark("UTF-16BE", 254, 255);
    public static final ByteOrderMark UTF_16LE = new ByteOrderMark("UTF-16LE", 255, 254);
    public static final ByteOrderMark UTF_32BE = new ByteOrderMark("UTF-32BE", 0, 0, 254, 255);
    public static final ByteOrderMark UTF_32LE = new ByteOrderMark("UTF-32LE", 255, 254, 0, 0);
    private final String charsetName;
    private final int[] bytes;

    public ByteOrderMark(String string, int ... nArray) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No charsetName specified");
        }
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException("No bytes specified");
        }
        this.charsetName = string;
        this.bytes = new int[nArray.length];
        System.arraycopy(nArray, 0, this.bytes, 0, nArray.length);
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public int length() {
        return this.bytes.length;
    }

    public int get(int n) {
        return this.bytes[n];
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.bytes.length];
        int n = 0;
        while (n < this.bytes.length) {
            byArray[n] = (byte)this.bytes[n];
            ++n;
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ByteOrderMark)) {
            return false;
        }
        ByteOrderMark byteOrderMark = (ByteOrderMark)object;
        if (this.bytes.length != byteOrderMark.length()) {
            return false;
        }
        int n = 0;
        while (n < this.bytes.length) {
            if (this.bytes[n] != byteOrderMark.get(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = this.getClass().hashCode();
        int[] nArray = this.bytes;
        int n2 = this.bytes.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            n += n4;
            ++n3;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('[');
        stringBuilder.append(this.charsetName);
        stringBuilder.append(": ");
        int n = 0;
        while (n < this.bytes.length) {
            if (n > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("0x");
            stringBuilder.append(Integer.toHexString(0xFF & this.bytes[n]).toUpperCase());
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

