/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import org.apache.commons.httpclient.NameValuePair;

public class ParameterFormatter {
    private static final char[] SEPARATORS = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}', ' ', '\t'};
    private static final char[] UNSAFE_CHARS = new char[]{'\"', '\\'};
    private boolean alwaysUseQuotes = true;

    private static boolean isOneOf(char[] cArray, char c) {
        int n = 0;
        while (n < cArray.length) {
            if (c == cArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean isUnsafeChar(char c) {
        return ParameterFormatter.isOneOf(UNSAFE_CHARS, c);
    }

    private static boolean isSeparator(char c) {
        return ParameterFormatter.isOneOf(SEPARATORS, c);
    }

    public boolean isAlwaysUseQuotes() {
        return this.alwaysUseQuotes;
    }

    public void setAlwaysUseQuotes(boolean bl) {
        this.alwaysUseQuotes = bl;
    }

    public static void formatValue(StringBuffer stringBuffer, String string, boolean bl) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Value buffer may not be null");
        }
        if (bl) {
            stringBuffer.append('\"');
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (ParameterFormatter.isUnsafeChar(c)) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                ++n;
            }
            stringBuffer.append('\"');
        } else {
            int n = stringBuffer.length();
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (ParameterFormatter.isSeparator(c)) {
                    bl2 = true;
                }
                if (ParameterFormatter.isUnsafeChar(c)) {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
                ++n2;
            }
            if (bl2) {
                stringBuffer.insert(n, '\"');
                stringBuffer.append('\"');
            }
        }
    }

    public void format(StringBuffer stringBuffer, NameValuePair nameValuePair) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (nameValuePair == null) {
            throw new IllegalArgumentException("Parameter may not be null");
        }
        stringBuffer.append(nameValuePair.getName());
        String string = nameValuePair.getValue();
        if (string != null) {
            stringBuffer.append("=");
            ParameterFormatter.formatValue(stringBuffer, string, this.alwaysUseQuotes);
        }
    }

    public String format(NameValuePair nameValuePair) {
        StringBuffer stringBuffer = new StringBuffer();
        this.format(stringBuffer, nameValuePair);
        return stringBuffer.toString();
    }
}

