/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.httpclient.util.DateParseException;

public class DateParser {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final Collection DEFAULT_PATTERNS = Arrays.asList("EEE MMM d HH:mm:ss yyyy", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz");

    public static Date parseDate(String string) throws DateParseException {
        return DateParser.parseDate(string, null);
    }

    public static Date parseDate(String string, Collection collection) throws DateParseException {
        if (string == null) {
            throw new IllegalArgumentException("dateValue is null");
        }
        if (collection == null) {
            collection = DEFAULT_PATTERNS;
        }
        if (string.length() > 1 && string.startsWith("'") && string.endsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        SimpleDateFormat simpleDateFormat = null;
        for (String string2 : collection) {
            if (simpleDateFormat == null) {
                simpleDateFormat = new SimpleDateFormat(string2, Locale.US);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            } else {
                simpleDateFormat.applyPattern(string2);
            }
            try {
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {}
        }
        throw new DateParseException("Unable to parse the date " + string);
    }

    private DateParser() {
    }
}

