/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Part {
    private static final Log LOG = LogFactory.getLog(Part.class);
    protected static final String BOUNDARY = "----------------314159265358979323846";
    protected static final byte[] BOUNDARY_BYTES = EncodingUtil.getAsciiBytes("----------------314159265358979323846");
    private static final byte[] DEFAULT_BOUNDARY_BYTES = BOUNDARY_BYTES;
    protected static final String CRLF = "\r\n";
    protected static final byte[] CRLF_BYTES = EncodingUtil.getAsciiBytes("\r\n");
    protected static final String QUOTE = "\"";
    protected static final byte[] QUOTE_BYTES = EncodingUtil.getAsciiBytes("\"");
    protected static final String EXTRA = "--";
    protected static final byte[] EXTRA_BYTES = EncodingUtil.getAsciiBytes("--");
    protected static final String CONTENT_DISPOSITION = "Content-Disposition: form-data; name=";
    protected static final byte[] CONTENT_DISPOSITION_BYTES = EncodingUtil.getAsciiBytes("Content-Disposition: form-data; name=");
    protected static final String CONTENT_TYPE = "Content-Type: ";
    protected static final byte[] CONTENT_TYPE_BYTES = EncodingUtil.getAsciiBytes("Content-Type: ");
    protected static final String CHARSET = "; charset=";
    protected static final byte[] CHARSET_BYTES = EncodingUtil.getAsciiBytes("; charset=");
    protected static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding: ";
    protected static final byte[] CONTENT_TRANSFER_ENCODING_BYTES = EncodingUtil.getAsciiBytes("Content-Transfer-Encoding: ");
    private byte[] boundaryBytes;

    public static String getBoundary() {
        return BOUNDARY;
    }

    public abstract String getName();

    public abstract String getContentType();

    public abstract String getCharSet();

    public abstract String getTransferEncoding();

    protected byte[] getPartBoundary() {
        if (this.boundaryBytes == null) {
            return DEFAULT_BOUNDARY_BYTES;
        }
        return this.boundaryBytes;
    }

    void setPartBoundary(byte[] byArray) {
        this.boundaryBytes = byArray;
    }

    public boolean isRepeatable() {
        return true;
    }

    protected void sendStart(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendStart(OutputStream out)");
        outputStream.write(EXTRA_BYTES);
        outputStream.write(this.getPartBoundary());
        outputStream.write(CRLF_BYTES);
    }

    protected void sendDispositionHeader(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendDispositionHeader(OutputStream out)");
        outputStream.write(CONTENT_DISPOSITION_BYTES);
        outputStream.write(QUOTE_BYTES);
        outputStream.write(EncodingUtil.getAsciiBytes(this.getName()));
        outputStream.write(QUOTE_BYTES);
    }

    protected void sendContentTypeHeader(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendContentTypeHeader(OutputStream out)");
        String string = this.getContentType();
        if (string != null) {
            outputStream.write(CRLF_BYTES);
            outputStream.write(CONTENT_TYPE_BYTES);
            outputStream.write(EncodingUtil.getAsciiBytes(string));
            String string2 = this.getCharSet();
            if (string2 != null) {
                outputStream.write(CHARSET_BYTES);
                outputStream.write(EncodingUtil.getAsciiBytes(string2));
            }
        }
    }

    protected void sendTransferEncodingHeader(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendTransferEncodingHeader(OutputStream out)");
        String string = this.getTransferEncoding();
        if (string != null) {
            outputStream.write(CRLF_BYTES);
            outputStream.write(CONTENT_TRANSFER_ENCODING_BYTES);
            outputStream.write(EncodingUtil.getAsciiBytes(string));
        }
    }

    protected void sendEndOfHeader(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendEndOfHeader(OutputStream out)");
        outputStream.write(CRLF_BYTES);
        outputStream.write(CRLF_BYTES);
    }

    protected abstract void sendData(OutputStream var1) throws IOException;

    protected abstract long lengthOfData() throws IOException;

    protected void sendEnd(OutputStream outputStream) throws IOException {
        LOG.trace("enter sendEnd(OutputStream out)");
        outputStream.write(CRLF_BYTES);
    }

    public void send(OutputStream outputStream) throws IOException {
        LOG.trace("enter send(OutputStream out)");
        this.sendStart(outputStream);
        this.sendDispositionHeader(outputStream);
        this.sendContentTypeHeader(outputStream);
        this.sendTransferEncodingHeader(outputStream);
        this.sendEndOfHeader(outputStream);
        this.sendData(outputStream);
        this.sendEnd(outputStream);
    }

    public long length() throws IOException {
        LOG.trace("enter length()");
        if (this.lengthOfData() < 0L) {
            return -1L;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.sendStart(byteArrayOutputStream);
        this.sendDispositionHeader(byteArrayOutputStream);
        this.sendContentTypeHeader(byteArrayOutputStream);
        this.sendTransferEncodingHeader(byteArrayOutputStream);
        this.sendEndOfHeader(byteArrayOutputStream);
        this.sendEnd(byteArrayOutputStream);
        return (long)byteArrayOutputStream.size() + this.lengthOfData();
    }

    public String toString() {
        return this.getName();
    }

    public static void sendParts(OutputStream outputStream, Part[] partArray) throws IOException {
        Part.sendParts(outputStream, partArray, DEFAULT_BOUNDARY_BYTES);
    }

    public static void sendParts(OutputStream outputStream, Part[] partArray, byte[] byArray) throws IOException {
        if (partArray == null) {
            throw new IllegalArgumentException("Parts may not be null");
        }
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("partBoundary may not be empty");
        }
        int n = 0;
        while (n < partArray.length) {
            partArray[n].setPartBoundary(byArray);
            partArray[n].send(outputStream);
            ++n;
        }
        outputStream.write(EXTRA_BYTES);
        outputStream.write(byArray);
        outputStream.write(EXTRA_BYTES);
        outputStream.write(CRLF_BYTES);
    }

    public static long getLengthOfParts(Part[] partArray) throws IOException {
        return Part.getLengthOfParts(partArray, DEFAULT_BOUNDARY_BYTES);
    }

    public static long getLengthOfParts(Part[] partArray, byte[] byArray) throws IOException {
        LOG.trace("getLengthOfParts(Parts[])");
        if (partArray == null) {
            throw new IllegalArgumentException("Parts may not be null");
        }
        long l = 0L;
        int n = 0;
        while (n < partArray.length) {
            partArray[n].setPartBoundary(byArray);
            long l2 = partArray[n].length();
            if (l2 < 0L) {
                return -1L;
            }
            l += l2;
            ++n;
        }
        l += (long)EXTRA_BYTES.length;
        l += (long)byArray.length;
        l += (long)EXTRA_BYTES.length;
        return l += (long)CRLF_BYTES.length;
    }
}

