/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultipartRequestEntity
implements RequestEntity {
    private static final Log log = LogFactory.getLog(MultipartRequestEntity.class);
    private static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static byte[] MULTIPART_CHARS = EncodingUtil.getAsciiBytes("-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    protected Part[] parts;
    private byte[] multipartBoundary;
    private HttpMethodParams params;

    private static byte[] generateMultipartBoundary() {
        Random random = new Random();
        byte[] byArray = new byte[random.nextInt(11) + 30];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)];
            ++n;
        }
        return byArray;
    }

    public MultipartRequestEntity(Part[] partArray, HttpMethodParams httpMethodParams) {
        if (partArray == null) {
            throw new IllegalArgumentException("parts cannot be null");
        }
        if (httpMethodParams == null) {
            throw new IllegalArgumentException("params cannot be null");
        }
        this.parts = partArray;
        this.params = httpMethodParams;
    }

    protected byte[] getMultipartBoundary() {
        if (this.multipartBoundary == null) {
            String string = (String)this.params.getParameter("http.method.multipart.boundary");
            this.multipartBoundary = string != null ? EncodingUtil.getAsciiBytes(string) : MultipartRequestEntity.generateMultipartBoundary();
        }
        return this.multipartBoundary;
    }

    @Override
    public boolean isRepeatable() {
        int n = 0;
        while (n < this.parts.length) {
            if (!this.parts[n].isRepeatable()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public void writeRequest(OutputStream outputStream) throws IOException {
        Part.sendParts(outputStream, this.parts, this.getMultipartBoundary());
    }

    @Override
    public long getContentLength() {
        try {
            return Part.getLengthOfParts(this.parts, this.getMultipartBoundary());
        }
        catch (Exception exception) {
            log.error("An exception occurred while getting the length of the parts", exception);
            return 0L;
        }
    }

    @Override
    public String getContentType() {
        StringBuffer stringBuffer = new StringBuffer(MULTIPART_FORM_CONTENT_TYPE);
        stringBuffer.append("; boundary=");
        stringBuffer.append(EncodingUtil.getAsciiString(this.getMultipartBoundary()));
        return stringBuffer.toString();
    }
}

