/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.RequestEntity;

public class FileRequestEntity
implements RequestEntity {
    final File file;
    final String contentType;

    public FileRequestEntity(File file, String string) {
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        this.file = file;
        this.contentType = string;
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public void writeRequest(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n = 0;
        try (FileInputStream fileInputStream = new FileInputStream(this.file);){
            while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }
    }
}

