/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.cookie;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.cookie.CookieSpecBase;
import org.apache.commons.httpclient.cookie.MalformedCookieException;

public class NetscapeDraftSpec
extends CookieSpecBase {
    @Override
    public Cookie[] parse(String string, int n, String string2, boolean bl, String string3) throws MalformedCookieException {
        LOG.trace("enter NetscapeDraftSpec.parse(String, port, path, boolean, Header)");
        if (string == null) {
            throw new IllegalArgumentException("Host of origin may not be null");
        }
        if (string.trim().equals("")) {
            throw new IllegalArgumentException("Host of origin may not be blank");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid port: " + n);
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Path of origin may not be null.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Header may not be null.");
        }
        if (string2.trim().equals("")) {
            string2 = "/";
        }
        string = string.toLowerCase();
        String string4 = string2;
        int n2 = string4.lastIndexOf("/");
        if (n2 >= 0) {
            if (n2 == 0) {
                n2 = 1;
            }
            string4 = string4.substring(0, n2);
        }
        HeaderElement headerElement = new HeaderElement(string3.toCharArray());
        Cookie cookie = new Cookie(string, headerElement.getName(), headerElement.getValue(), string4, null, false);
        NameValuePair[] nameValuePairArray = headerElement.getParameters();
        if (nameValuePairArray != null) {
            int n3 = 0;
            while (n3 < nameValuePairArray.length) {
                this.parseAttribute(nameValuePairArray[n3], cookie);
                ++n3;
            }
        }
        return new Cookie[]{cookie};
    }

    @Override
    public void parseAttribute(NameValuePair nameValuePair, Cookie cookie) throws MalformedCookieException {
        if (nameValuePair == null) {
            throw new IllegalArgumentException("Attribute may not be null.");
        }
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null.");
        }
        String string = nameValuePair.getName().toLowerCase();
        String string2 = nameValuePair.getValue();
        if (string.equals("expires")) {
            if (string2 == null) {
                throw new MalformedCookieException("Missing value for expires attribute");
            }
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
                Date date = simpleDateFormat.parse(string2);
                cookie.setExpiryDate(date);
            }
            catch (ParseException parseException) {
                throw new MalformedCookieException("Invalid expires attribute: " + parseException.getMessage());
            }
        } else {
            super.parseAttribute(nameValuePair, cookie);
        }
    }

    @Override
    public boolean domainMatch(String string, String string2) {
        return string.endsWith(string2);
    }

    @Override
    public void validate(String string, int n, String string2, boolean bl, Cookie cookie) throws MalformedCookieException {
        LOG.trace("enterNetscapeDraftCookieProcessor RCF2109CookieProcessor.validate(Cookie)");
        super.validate(string, n, string2, bl, cookie);
        if (string.indexOf(".") >= 0) {
            int n2 = new StringTokenizer(cookie.getDomain(), ".").countTokens();
            if (NetscapeDraftSpec.isSpecialDomain(cookie.getDomain())) {
                if (n2 < 2) {
                    throw new MalformedCookieException("Domain attribute \"" + cookie.getDomain() + "\" violates the Netscape cookie specification for " + "special domains");
                }
            } else if (n2 < 3) {
                throw new MalformedCookieException("Domain attribute \"" + cookie.getDomain() + "\" violates the Netscape cookie specification");
            }
        }
    }

    private static boolean isSpecialDomain(String string) {
        String string2 = string.toUpperCase();
        return string2.endsWith(".COM") || string2.endsWith(".EDU") || string2.endsWith(".NET") || string2.endsWith(".GOV") || string2.endsWith(".MIL") || string2.endsWith(".ORG") || string2.endsWith(".INT");
    }
}

