/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.util.EncodingUtil;

final class NTLM {
    public static final String DEFAULT_CHARSET = "ASCII";
    private byte[] currentResponse;
    private int currentPosition = 0;
    private String credentialCharset = "ASCII";

    NTLM() {
    }

    public final String getResponseFor(String string, String string2, String string3, String string4, String string5) throws AuthenticationException {
        String string6 = string == null || string.trim().equals("") ? this.getType1Message(string4, string5) : this.getType3Message(string2, string3, string4, string5, this.parseType2Message(string));
        return string6;
    }

    private Cipher getCipher(byte[] byArray) throws AuthenticationException {
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            byArray = this.setupKey(byArray);
            cipher.init(1, new SecretKeySpec(byArray, "DES"));
            return cipher;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthenticationException("DES encryption is not available.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException("Invalid key for DES encryption.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new AuthenticationException("NoPadding option for DES is not available.", noSuchPaddingException);
        }
    }

    private byte[] setupKey(byte[] byArray) {
        byte[] byArray2 = new byte[]{(byte)(byArray[0] >> 1 & 0xFF), (byte)(((byArray[0] & 1) << 6 | (byArray[1] & 0xFF) >> 2 & 0xFF) & 0xFF), (byte)(((byArray[1] & 3) << 5 | (byArray[2] & 0xFF) >> 3 & 0xFF) & 0xFF), (byte)(((byArray[2] & 7) << 4 | (byArray[3] & 0xFF) >> 4 & 0xFF) & 0xFF), (byte)(((byArray[3] & 0xF) << 3 | (byArray[4] & 0xFF) >> 5 & 0xFF) & 0xFF), (byte)(((byArray[4] & 0x1F) << 2 | (byArray[5] & 0xFF) >> 6 & 0xFF) & 0xFF), (byte)(((byArray[5] & 0x3F) << 1 | (byArray[6] & 0xFF) >> 7 & 0xFF) & 0xFF), (byte)(byArray[6] & 0x7F)};
        int n = 0;
        while (n < byArray2.length) {
            byArray2[n] = (byte)(byArray2[n] << 1);
            ++n;
        }
        return byArray2;
    }

    private byte[] encrypt(byte[] byArray, byte[] byArray2) throws AuthenticationException {
        Cipher cipher = this.getCipher(byArray);
        try {
            byte[] byArray3 = cipher.doFinal(byArray2);
            return byArray3;
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new AuthenticationException("Invalid block size for DES encryption.", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new AuthenticationException("Data not padded correctly for DES encryption.", badPaddingException);
        }
    }

    private void prepareResponse(int n) {
        this.currentResponse = new byte[n];
        this.currentPosition = 0;
    }

    private void addByte(byte by) {
        this.currentResponse[this.currentPosition] = by;
        ++this.currentPosition;
    }

    private void addBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            this.currentResponse[this.currentPosition] = byArray[n];
            ++this.currentPosition;
            ++n;
        }
    }

    private String getResponse() {
        byte[] byArray;
        if (this.currentResponse.length > this.currentPosition) {
            byte[] byArray2 = new byte[this.currentPosition];
            int n = 0;
            while (n < this.currentPosition) {
                byArray2[n] = this.currentResponse[n];
                ++n;
            }
            byArray = byArray2;
        } else {
            byArray = this.currentResponse;
        }
        return EncodingUtil.getAsciiString(Base64.encodeBase64((byte[])byArray));
    }

    public String getType1Message(String string, String string2) {
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        byte[] byArray = EncodingUtil.getBytes(string, DEFAULT_CHARSET);
        byte[] byArray2 = EncodingUtil.getBytes(string2, DEFAULT_CHARSET);
        int n = 32 + byArray.length + byArray2.length;
        this.prepareResponse(n);
        byte[] byArray3 = EncodingUtil.getBytes("NTLMSSP", DEFAULT_CHARSET);
        this.addBytes(byArray3);
        this.addByte((byte)0);
        this.addByte((byte)1);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)6);
        this.addByte((byte)82);
        this.addByte((byte)0);
        this.addByte((byte)0);
        int n2 = byArray2.length;
        byte[] byArray4 = this.convertShort(n2);
        this.addByte(byArray4[0]);
        this.addByte(byArray4[1]);
        this.addByte(byArray4[0]);
        this.addByte(byArray4[1]);
        byte[] byArray5 = this.convertShort(byArray.length + 32);
        this.addByte(byArray5[0]);
        this.addByte(byArray5[1]);
        this.addByte((byte)0);
        this.addByte((byte)0);
        byte[] byArray6 = this.convertShort(byArray.length);
        this.addByte(byArray6[0]);
        this.addByte(byArray6[1]);
        this.addByte(byArray6[0]);
        this.addByte(byArray6[1]);
        byte[] byArray7 = this.convertShort(32);
        this.addByte(byArray7[0]);
        this.addByte(byArray7[1]);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(byArray);
        this.addBytes(byArray2);
        return this.getResponse();
    }

    public byte[] parseType2Message(String string) {
        byte[] byArray = Base64.decodeBase64((byte[])EncodingUtil.getBytes(string, DEFAULT_CHARSET));
        byte[] byArray2 = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray2[n] = byArray[n + 24];
            ++n;
        }
        return byArray2;
    }

    public String getType3Message(String string, String string2, String string3, String string4, byte[] byArray) throws AuthenticationException {
        int n = 0;
        int n2 = 24;
        string4 = string4.toUpperCase();
        string3 = string3.toUpperCase();
        string = string.toUpperCase();
        byte[] byArray2 = EncodingUtil.getBytes(string4, DEFAULT_CHARSET);
        byte[] byArray3 = EncodingUtil.getBytes(string3, DEFAULT_CHARSET);
        byte[] byArray4 = EncodingUtil.getBytes(string, this.credentialCharset);
        int n3 = byArray2.length;
        int n4 = byArray3.length;
        int n5 = byArray4.length;
        int n6 = 64 + n + n2 + n3 + n5 + n4;
        this.prepareResponse(n6);
        byte[] byArray5 = EncodingUtil.getBytes("NTLMSSP", DEFAULT_CHARSET);
        this.addBytes(byArray5);
        this.addByte((byte)0);
        this.addByte((byte)3);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(24));
        this.addBytes(this.convertShort(24));
        this.addBytes(this.convertShort(n6 - 24));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(0));
        this.addBytes(this.convertShort(0));
        this.addBytes(this.convertShort(n6));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(n3));
        this.addBytes(this.convertShort(n3));
        this.addBytes(this.convertShort(64));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(n5));
        this.addBytes(this.convertShort(n5));
        this.addBytes(this.convertShort(64 + n3));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(this.convertShort(n4));
        this.addBytes(this.convertShort(n4));
        this.addBytes(this.convertShort(64 + n3 + n5));
        int n7 = 0;
        while (n7 < 6) {
            this.addByte((byte)0);
            ++n7;
        }
        this.addBytes(this.convertShort(n6));
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addByte((byte)6);
        this.addByte((byte)82);
        this.addByte((byte)0);
        this.addByte((byte)0);
        this.addBytes(byArray2);
        this.addBytes(byArray4);
        this.addBytes(byArray3);
        this.addBytes(this.hashPassword(string2, byArray));
        return this.getResponse();
    }

    private byte[] hashPassword(String string, byte[] byArray) throws AuthenticationException {
        byte[] byArray2 = EncodingUtil.getBytes(string.toUpperCase(), this.credentialCharset);
        byte[] byArray3 = new byte[7];
        byte[] byArray4 = new byte[7];
        int n = byArray2.length;
        if (n > 7) {
            n = 7;
        }
        int n2 = 0;
        while (n2 < n) {
            byArray3[n2] = byArray2[n2];
            ++n2;
        }
        while (n2 < 7) {
            byArray3[n2] = 0;
            ++n2;
        }
        n = byArray2.length;
        if (n > 14) {
            n = 14;
        }
        n2 = 7;
        while (n2 < n) {
            byArray4[n2 - 7] = byArray2[n2];
            ++n2;
        }
        while (n2 < 14) {
            byArray4[n2 - 7] = 0;
            ++n2;
        }
        byte[] byArray5 = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
        byte[] byArray6 = this.encrypt(byArray3, byArray5);
        byte[] byArray7 = this.encrypt(byArray4, byArray5);
        byte[] byArray8 = new byte[21];
        int n3 = 0;
        while (n3 < byArray6.length) {
            byArray8[n3] = byArray6[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < byArray7.length) {
            byArray8[n3 + 8] = byArray7[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < 5) {
            byArray8[n3 + 16] = 0;
            ++n3;
        }
        byte[] byArray9 = new byte[24];
        this.calcResp(byArray8, byArray, byArray9);
        return byArray9;
    }

    private void calcResp(byte[] byArray, byte[] byArray2, byte[] byArray3) throws AuthenticationException {
        byte[] byArray4 = new byte[7];
        byte[] byArray5 = new byte[7];
        byte[] byArray6 = new byte[7];
        int n = 0;
        while (n < 7) {
            byArray4[n] = byArray[n];
            ++n;
        }
        n = 0;
        while (n < 7) {
            byArray5[n] = byArray[n + 7];
            ++n;
        }
        n = 0;
        while (n < 7) {
            byArray6[n] = byArray[n + 14];
            ++n;
        }
        byte[] byArray7 = this.encrypt(byArray4, byArray2);
        byte[] byArray8 = this.encrypt(byArray5, byArray2);
        byte[] byArray9 = this.encrypt(byArray6, byArray2);
        int n2 = 0;
        while (n2 < 8) {
            byArray3[n2] = byArray7[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < 8) {
            byArray3[n2 + 8] = byArray8[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < 8) {
            byArray3[n2 + 16] = byArray9[n2];
            ++n2;
        }
    }

    private byte[] convertShort(int n) {
        byte[] byArray = new byte[2];
        String string = Integer.toString(n, 16);
        while (string.length() < 4) {
            string = "0" + string;
        }
        String string2 = string.substring(2, 4);
        String string3 = string.substring(0, 2);
        byArray[0] = (byte)Integer.parseInt(string2, 16);
        byArray[1] = (byte)Integer.parseInt(string3, 16);
        return byArray;
    }

    public String getCredentialCharset() {
        return this.credentialCharset;
    }

    public void setCredentialCharset(String string) {
        this.credentialCharset = string;
    }
}

